/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.metrics.Histogram;
import org.apache.beam.sdk.metrics.Metric;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.util.HistogramData;

@Internal
public class DelegatingHistogram
implements Metric,
Histogram,
Serializable {
    private final MetricName name;
    private final HistogramData.BucketType bucketType;
    private final boolean processWideContainer;

    public DelegatingHistogram(MetricName name, HistogramData.BucketType bucketType, boolean processWideContainer) {
        this.name = name;
        this.bucketType = bucketType;
        this.processWideContainer = processWideContainer;
    }

    @Override
    public void update(double value) {
        MetricsContainer container;
        MetricsContainer metricsContainer = container = this.processWideContainer ? MetricsEnvironment.getProcessWideContainer() : MetricsEnvironment.getCurrentContainer();
        if (container != null) {
            container.getHistogram(this.name, this.bucketType).update(value);
        }
    }

    @Override
    public MetricName getName() {
        return this.name;
    }
}

