/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.outbound;

import java.util.List;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.async.connection.BoltProtocolUtil;
import org.neo4j.driver.internal.async.outbound.ChunkAwareByteBufOutput;
import org.neo4j.driver.internal.logging.ChannelActivityLogger;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBuf;
import org.neo4j.driver.internal.shaded.io.netty.buffer.ByteBufUtil;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelHandlerContext;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.EncoderException;
import org.neo4j.driver.internal.shaded.io.netty.handler.codec.MessageToMessageEncoder;

public class OutboundMessageHandler
extends MessageToMessageEncoder<Message> {
    public static final String NAME = OutboundMessageHandler.class.getSimpleName();
    private final ChunkAwareByteBufOutput output = new ChunkAwareByteBufOutput();
    private final MessageFormat.Writer writer;
    private final Logging logging;
    private Logger log;

    public OutboundMessageHandler(MessageFormat messageFormat, Logging logging) {
        this.writer = messageFormat.newWriter(this.output);
        this.logging = logging;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        this.log = new ChannelActivityLogger(ctx.channel(), this.logging, this.getClass());
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.log = null;
    }

    @Override
    protected void encode(ChannelHandlerContext ctx, Message msg, List<Object> out) {
        this.log.debug("C: %s", msg);
        ByteBuf messageBuf = ctx.alloc().ioBuffer();
        this.output.start(messageBuf);
        try {
            this.writer.write(msg);
            this.output.stop();
        }
        catch (Throwable error) {
            this.output.stop();
            messageBuf.release();
            throw new EncoderException("Failed to write outbound message: " + msg, error);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("C: %s", ByteBufUtil.hexDump(messageBuf));
        }
        BoltProtocolUtil.writeMessageBoundary(messageBuf);
        out.add(messageBuf);
    }
}

