/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.services.kinesis.model.Shard;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.kinesis.CheckpointGenerator;
import org.apache.beam.sdk.io.kinesis.KinesisReaderCheckpoint;
import org.apache.beam.sdk.io.kinesis.ShardCheckpoint;
import org.apache.beam.sdk.io.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.kinesis.StartingPoint;
import org.apache.beam.sdk.io.kinesis.TransientKinesisException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynamicCheckpointGenerator
implements CheckpointGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicCheckpointGenerator.class);
    private final String streamName;
    private final StartingPoint startingPoint;

    public DynamicCheckpointGenerator(String streamName, StartingPoint startingPoint) {
        this.streamName = streamName;
        this.startingPoint = startingPoint;
    }

    @Override
    public KinesisReaderCheckpoint generate(SimplifiedKinesisClient kinesis) throws TransientKinesisException {
        List<Shard> streamShards = kinesis.listShardsAtPoint(this.streamName, this.startingPoint);
        LOG.info("Creating a checkpoint with following shards {} at {}", streamShards, (Object)this.startingPoint.getTimestamp());
        return new KinesisReaderCheckpoint(streamShards.stream().map(shard -> new ShardCheckpoint(this.streamName, shard.getShardId(), this.startingPoint)).collect(Collectors.toList()));
    }

    public String toString() {
        return String.format("Checkpoint generator for %s: %s", this.streamName, this.startingPoint);
    }
}

