/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.utils;

import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.WrappedArray;

public class ScalaInterop {
    private ScalaInterop() {
    }

    public static <T> Seq<T> seqOf(T ... t) {
        return new WrappedArray.ofRef((Object[])t);
    }

    public static <T> List<T> concat(List<T> a, List<T> b) {
        return b.$colon$colon$colon(a);
    }

    public static <T> Seq<T> listOf(T t) {
        return ScalaInterop.emptyList().$colon$colon(t);
    }

    public static <T> List<T> emptyList() {
        return Nil$.MODULE$;
    }

    public static <T> Iterator<T> scalaIterator(Iterable<T> iterable) {
        return ScalaInterop.scalaIterator(iterable.iterator());
    }

    public static <T> Iterator<T> scalaIterator(java.util.Iterator<T> it) {
        return JavaConverters.asScalaIterator(it);
    }

    public static <T> java.util.Iterator<T> javaIterator(Iterator<T> it) {
        return JavaConverters.asJavaIterator(it);
    }

    public static <T1, T2> Tuple2<T1, T2> tuple(T1 t1, T2 t2) {
        return new Tuple2(t1, t2);
    }

    public static <T, V> PartialFunction<T, T> replace(final Class<V> clazz, final T replace) {
        return new PartialFunction<T, T>(){

            public boolean isDefinedAt(T x) {
                return clazz.isAssignableFrom(x.getClass());
            }

            public T apply(T x) {
                return replace;
            }
        };
    }

    public static <T, V> PartialFunction<T, V> match(final Class<V> clazz) {
        return new PartialFunction<T, V>(){

            public boolean isDefinedAt(T x) {
                return clazz.isAssignableFrom(x.getClass());
            }

            public V apply(T x) {
                return x;
            }
        };
    }

    public static <T, V> Fun1<T, V> fun1(Fun1<T, V> fun) {
        return fun;
    }

    public static <T1, T2, V> Fun2<T1, T2, V> fun2(Fun2<T1, T2, V> fun) {
        return fun;
    }

    public static interface Fun2<T1, T2, V>
    extends Function2<T1, T2, V>,
    Serializable {
    }

    public static interface Fun1<T, V>
    extends Function1<T, V>,
    Serializable {
    }
}

