/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.vaccess;

import com.ibm.as400.vaccess.ErrorEventSupport;
import com.ibm.as400.vaccess.ErrorListener;
import com.ibm.as400.vaccess.ListDataEventSupport;
import com.ibm.as400.vaccess.PropertyChangeSupport;
import com.ibm.as400.vaccess.VNode;
import com.ibm.as400.vaccess.VObject;
import com.ibm.as400.vaccess.VObjectEvent;
import com.ibm.as400.vaccess.VObjectListener;
import com.ibm.as400.vaccess.VetoableChangeSupport;
import com.ibm.as400.vaccess.WorkingEventSupport;
import com.ibm.as400.vaccess.WorkingListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

public class AS400ListModel
implements ListModel,
Serializable {
    private static final String copyright = "Copyright (C) 1997-2000 International Business Machines Corporation and others.";
    VNode root_ = null;
    private transient ErrorEventSupport errorEventSupport_;
    transient ListDataEventSupport listDataEventSupport_;
    private transient VObjectListener objectListener_;
    private transient PropertyChangeSupport propertyChangeSupport_;
    private transient VetoableChangeSupport vetoableChangeSupport_;
    private transient WorkingEventSupport workingEventSupport_;

    public AS400ListModel() {
        this.initializeTransient();
    }

    public AS400ListModel(VNode vNode) {
        if (vNode == null) {
            throw new NullPointerException("root");
        }
        this.root_ = vNode;
        this.initializeTransient();
    }

    public void addErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.addErrorListener(errorListener);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.listDataEventSupport_.addListDataListener(listDataListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.addVetoableChangeListener(vetoableChangeListener);
    }

    public void addWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.addWorkingListener(workingListener);
    }

    public Object getElementAt(int n) {
        if (this.root_ == null) {
            return null;
        }
        if (n < 0 || n >= this.root_.getDetailsChildCount()) {
            return null;
        }
        return this.root_.getDetailsChildAt(n);
    }

    public VNode getRoot() {
        return this.root_;
    }

    public int getSize() {
        if (this.root_ == null) {
            return 0;
        }
        return this.root_.getDetailsChildCount();
    }

    private void initializeTransient() {
        this.errorEventSupport_ = new ErrorEventSupport(this);
        this.listDataEventSupport_ = new ListDataEventSupport(this);
        this.objectListener_ = new VObjectListener_();
        this.propertyChangeSupport_ = new PropertyChangeSupport(this);
        this.vetoableChangeSupport_ = new VetoableChangeSupport(this);
        this.workingEventSupport_ = new WorkingEventSupport(this);
        if (this.root_ != null) {
            this.root_.addErrorListener(this.errorEventSupport_);
            this.root_.addVObjectListener(this.objectListener_);
            this.root_.addWorkingListener(this.workingEventSupport_);
        }
    }

    public void load() {
        int n = this.getSize();
        if (this.root_ != null) {
            this.root_.load();
            int n2 = this.root_.getDetailsChildCount();
            for (int i = 0; i < n2; ++i) {
                VObject vObject = this.root_.getDetailsChildAt(i);
                if (vObject == null) continue;
                this.root_.getDetailsChildAt(i);
            }
        }
        this.listDataEventSupport_.fireIntervalRemoved(0, n);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removeErrorListener(ErrorListener errorListener) {
        this.errorEventSupport_.removeErrorListener(errorListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.listDataEventSupport_.removeListDataListener(listDataListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.removePropertyChangeListener(propertyChangeListener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetoableChangeSupport_.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void removeWorkingListener(WorkingListener workingListener) {
        this.workingEventSupport_.removeWorkingListener(workingListener);
    }

    public void setRoot(VNode vNode) throws PropertyVetoException {
        if (vNode == null) {
            throw new NullPointerException("root");
        }
        VNode vNode2 = this.root_;
        VNode vNode3 = vNode;
        this.vetoableChangeSupport_.fireVetoableChange("root", vNode2, vNode3);
        if (vNode2 != vNode3) {
            int n = this.root_ == null ? 0 : this.root_.getDetailsChildCount();
            if (vNode2 != null) {
                vNode2.removeErrorListener(this.errorEventSupport_);
                vNode2.removeVObjectListener(this.objectListener_);
                vNode2.removeWorkingListener(this.workingEventSupport_);
            }
            vNode3.addErrorListener(this.errorEventSupport_);
            vNode3.addVObjectListener(this.objectListener_);
            vNode3.addWorkingListener(this.workingEventSupport_);
            this.root_ = vNode3;
            this.listDataEventSupport_.fireContentsChanged(0, n);
        }
        this.propertyChangeSupport_.firePropertyChange("root", vNode2, vNode3);
    }

    public void sort(Object[] objectArray, boolean[] blArray) {
        if (objectArray == null) {
            throw new NullPointerException("propertyIdentifiers");
        }
        if (blArray == null) {
            throw new NullPointerException("orders");
        }
        if (this.root_ != null && this.root_.isSortable()) {
            this.root_.sortDetailsChildren(objectArray, blArray);
            this.listDataEventSupport_.fireContentsChanged(0, this.getSize());
        }
    }

    private class VObjectListener_
    implements VObjectListener,
    Serializable {
        private VObjectListener_() {
        }

        public void objectChanged(VObjectEvent vObjectEvent) {
            VObject vObject = vObjectEvent.getObject();
            if (vObject == AS400ListModel.this.root_) {
                if (!vObjectEvent.isDuringLoad()) {
                    AS400ListModel.this.load();
                }
                AS400ListModel.this.listDataEventSupport_.fireContentsChanged(0, AS400ListModel.this.root_.getDetailsChildCount());
            } else {
                int n = AS400ListModel.this.root_.getDetailsIndex(vObject);
                if (n >= 0) {
                    AS400ListModel.this.listDataEventSupport_.fireContentsChanged(n, n);
                }
            }
        }

        public void objectCreated(VObjectEvent vObjectEvent) {
            int n;
            VObject vObject = vObjectEvent.getObject();
            VNode vNode = vObjectEvent.getParent();
            if (vNode == AS400ListModel.this.root_ && (n = AS400ListModel.this.root_.getDetailsIndex(vObject)) >= 0) {
                AS400ListModel.this.listDataEventSupport_.fireIntervalAdded(n, n);
            }
        }

        public void objectDeleted(VObjectEvent vObjectEvent) {
            VObject vObject = vObjectEvent.getObject();
            int n = AS400ListModel.this.root_.getDetailsIndex(vObject);
            if (n >= 0) {
                AS400ListModel.this.listDataEventSupport_.fireIntervalRemoved(n, n);
            }
        }
    }
}

