/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import com.ibm.as400.security.auth.AS400Credential;
import com.ibm.as400.security.auth.ProfileHandleImpl;
import java.beans.PropertyVetoException;

public final class ProfileHandleCredential
extends AS400Credential {
    static final long serialVersionUID = 4L;
    private byte[] handle_ = null;
    public static final int HANDLE_LENGTH = 12;

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof ProfileHandleCredential)) {
            return false;
        }
        return this.hashCode() == ((ProfileHandleCredential)object).hashCode();
    }

    public byte[] getHandle() {
        return this.handle_;
    }

    public int hashCode() {
        int n = 19913;
        if (this.handle_ != null) {
            for (int i = 0; i < this.handle_.length; ++i) {
                n ^= this.handle_[i];
            }
        }
        n ^= this.isPrivate() ? 13431 : 14427;
        if (this.getPrincipal() != null) {
            n ^= this.getPrincipal().hashCode();
        }
        if (this.getSystem() != null) {
            n ^= this.getSystem().getSystemName().hashCode();
        }
        return n;
    }

    String implClassNameNative() {
        return "com.ibm.as400.access.ProfileHandleImplNative";
    }

    String implClassNameRemote() {
        return "com.ibm.as400.security.auth.ProfileHandleImplRemote";
    }

    void initTransient() {
        super.initTransient();
        this.handle_ = null;
    }

    void invalidateProperties() {
        super.invalidateProperties();
        this.handle_ = null;
    }

    public void setHandle() throws PropertyVetoException, AS400SecurityException {
        this.validatePropertySet("system", this.getSystem());
        ProfileHandleImpl profileHandleImpl = (ProfileHandleImpl)this.getImplPrimitive();
        this.setHandle(profileHandleImpl.getCurrentHandle());
        this.setImpl(profileHandleImpl);
        this.fireCreated();
    }

    public void setHandle(byte[] byArray) throws PropertyVetoException {
        this.validatePropertyChange("handle");
        if (byArray != null && byArray.length != 12) {
            Trace.log(2, "Handle of length " + byArray.length + " not valid ");
            throw new ExtendedIllegalArgumentException("bytes", 1);
        }
        byte[] byArray2 = this.getHandle();
        this.fireVetoableChange("handle", byArray2, byArray);
        this.handle_ = byArray;
        this.firePropertyChange("handle", byArray2, byArray);
    }

    boolean typeIsStandalone() {
        return true;
    }

    void validateProperties() {
        super.validateProperties();
        this.validatePropertySet("handle", this.getHandle());
    }
}

