/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.IFSDataStreamReq;
import com.ibm.as400.access.Trace;

class IFSUnlockBytesReq
extends IFSDataStreamReq {
    private static final int HEADER_LENGTH = 20;
    private static final int FILE_HANDLE_OFFSET = 22;
    private static final int BASE_OFFSET_OFFSET = 26;
    private static final int RELATIVE_OFFSET_OFFSET = 30;
    private static final int UNLOCK_LENGTH_OFFSET = 34;
    private static final int UNLOCK_FLAGS_OFFSET = 38;
    private static final int LARGE_BASE_OFFSET_OFFSET = 40;
    private static final int LARGE_RELATIVE_OFFSET_OFFSET = 48;
    private static final int LARGE_UNLOCK_LENGTH_OFFSET = 56;

    IFSUnlockBytesReq(int n, long l, long l2, boolean bl, int n2) {
        super(20 + IFSUnlockBytesReq.getTemplateLength(n2));
        this.setLength(this.data_.length);
        this.setTemplateLen(IFSUnlockBytesReq.getTemplateLength(n2));
        this.setReqRepID(8);
        this.set32bit(n, 22);
        this.set16bit(bl ? 0 : 1, 38);
        if (n2 < 16) {
            if (l > Integer.MAX_VALUE) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Specified offset value (" + l + ") exceeds maximum file length supported by system.");
                }
                l = Integer.MAX_VALUE;
            }
            if (l2 > Integer.MAX_VALUE) {
                if (Trace.traceOn_) {
                    Trace.log(4, "Specified length value (" + l2 + ") exceeds maximum file length supported by system.");
                }
                l2 = Integer.MAX_VALUE;
            }
            this.set32bit(0, 26);
            this.set32bit((int)l, 30);
            this.set32bit((int)l2, 34);
        } else {
            this.set32bit(0, 26);
            this.set32bit(0, 30);
            this.set32bit(0, 34);
            this.set64bit(0L, 40);
            this.set64bit(l, 48);
            this.set64bit(l2, 56);
        }
    }

    private static final int getTemplateLength(int n) {
        return n < 16 ? 20 : 44;
    }
}

