/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.gettablenames;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.gettablenames.GetTableNames;
import org.apache.hop.pipeline.transforms.gettablenames.GetTableNamesData;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="GetTableNames.Injection.", groups={"FIELDS", "SETTINGS", "OUTPUT"})
@Transform(id="GetTableNames", image="gettablenames.svg", name="i18n::GetTableNames.Name", description="i18n::GetTableNames.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::GetTableNamesMeta.keyword"}, documentationUrl="/pipeline/transforms/gettablenames.html")
public class GetTableNamesMeta
extends BaseTransformMeta<GetTableNames, GetTableNamesData> {
    private static final Class<?> PKG = GetTableNamesMeta.class;
    private DatabaseMeta database;
    @Injection(name="SCHEMANAME", group="FIELDS")
    private String schemaname;
    @Injection(name="TABLENAMEFIELDNAME", group="OUTPUT")
    private String tablenamefieldname;
    @Injection(name="SQLCREATIONFIELDNAME", group="OUTPUT")
    private String sqlcreationfieldname;
    @Injection(name="OBJECTTYPEFIELDNAME", group="OUTPUT")
    private String objecttypefieldname;
    @Injection(name="ISSYSTEMOBJECTFIELDNAME", group="OUTPUT")
    private String issystemobjectfieldname;
    @Injection(name="INCLUDECATALOG", group="SETTINGS")
    private boolean includeCatalog;
    @Injection(name="INCLUDESCHEMA", group="SETTINGS")
    private boolean includeSchema;
    @Injection(name="INCLUDETABLE", group="SETTINGS")
    private boolean includeTable;
    @Injection(name="INCLUDEVIEW", group="SETTINGS")
    private boolean includeView;
    @Injection(name="INCLUDEPROCEDURE", group="SETTINGS")
    private boolean includeProcedure;
    @Injection(name="INCLUDESYNONYM", group="SETTINGS")
    private boolean includeSynonym;
    @Injection(name="ADDSCHEMAINOUTPUT", group="SETTINGS")
    private boolean addSchemaInOutput;
    @Injection(name="DYNAMICSCHEMA", group="FIELDS")
    private boolean dynamicSchema;
    @Injection(name="SCHEMANAMEFIELD", group="FIELDS")
    private String schemaNameField;
    private IHopMetadataProvider metadataProvider;

    public DatabaseMeta getDatabase() {
        return this.database;
    }

    public void setDatabase(DatabaseMeta database) {
        this.database = database;
    }

    public String getTablenameFieldName() {
        return this.tablenamefieldname;
    }

    public void setTablenameFieldName(String tablenamefieldname) {
        this.tablenamefieldname = tablenamefieldname;
    }

    public String getSqlCreationFieldName() {
        return this.sqlcreationfieldname;
    }

    public void setSqlCreationFieldName(String sqlcreationfieldname) {
        this.sqlcreationfieldname = sqlcreationfieldname;
    }

    public String getSchemaName() {
        return this.schemaname;
    }

    public void setSchemaName(String schemaname) {
        this.schemaname = schemaname;
    }

    public void setObjectTypeFieldName(String objecttypefieldname) {
        this.objecttypefieldname = objecttypefieldname;
    }

    public void setIsSystemObjectFieldName(String issystemobjectfieldname) {
        this.issystemobjectfieldname = issystemobjectfieldname;
    }

    public void setSystemObjectFieldName(String issystemobjectfieldname) {
        this.issystemobjectfieldname = issystemobjectfieldname;
    }

    public String getObjectTypeFieldName() {
        return this.objecttypefieldname;
    }

    public String isSystemObjectFieldName() {
        return this.issystemobjectfieldname;
    }

    public String getSchemaFieldName() {
        return this.schemaNameField;
    }

    public void setSchemaFieldName(String schemaNameField) {
        this.schemaNameField = schemaNameField;
    }

    public void setIncludeTable(boolean includetable) {
        this.includeTable = includetable;
    }

    public boolean isIncludeTable() {
        return this.includeTable;
    }

    public void setIncludeSchema(boolean includeSchema) {
        this.includeSchema = includeSchema;
    }

    public boolean isIncludeSchema() {
        return this.includeSchema;
    }

    public void setIncludeCatalog(boolean includeCatalog) {
        this.includeCatalog = includeCatalog;
    }

    public boolean isIncludeCatalog() {
        return this.includeCatalog;
    }

    public void setIncludeView(boolean includeView) {
        this.includeView = includeView;
    }

    public boolean isIncludeView() {
        return this.includeView;
    }

    public void setIncludeProcedure(boolean includeProcedure) {
        this.includeProcedure = includeProcedure;
    }

    public boolean isIncludeProcedure() {
        return this.includeProcedure;
    }

    public void setIncludeSynonym(boolean includeSynonym) {
        this.includeSynonym = includeSynonym;
    }

    public boolean isIncludeSynonym() {
        return this.includeSynonym;
    }

    public void setDynamicSchema(boolean dynamicSchema) {
        this.dynamicSchema = dynamicSchema;
    }

    public boolean isDynamicSchema() {
        return this.dynamicSchema;
    }

    public void setAddSchemaInOut(boolean addSchemaInOutput) {
        this.addSchemaInOutput = addSchemaInOutput;
    }

    public boolean isAddSchemaInOut() {
        return this.addSchemaInOutput;
    }

    @Injection(name="CONNECTIONNAME")
    public void setConnection(String connectionName) {
        try {
            this.database = DatabaseMeta.loadDatabase((IHopMetadataProvider)this.metadataProvider, (String)connectionName);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load connection '" + connectionName + "'", e);
        }
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public Object clone() {
        GetTableNamesMeta retval = (GetTableNamesMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.database = null;
        this.schemaname = null;
        this.includeCatalog = false;
        this.includeSchema = false;
        this.includeTable = true;
        this.includeProcedure = true;
        this.includeView = true;
        this.includeSynonym = true;
        this.addSchemaInOutput = false;
        this.tablenamefieldname = "tablename";
        this.sqlcreationfieldname = null;
        this.objecttypefieldname = "type";
        this.issystemobjectfieldname = "is system";
        this.dynamicSchema = false;
        this.schemaNameField = null;
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        String realSqlCreation;
        String sysobject;
        String realObjectType;
        String realtablename = variables.resolve(this.tablenamefieldname);
        if (!Utils.isEmpty((CharSequence)realtablename)) {
            ValueMetaString v = new ValueMetaString(realtablename);
            v.setLength(500);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)(realObjectType = variables.resolve(this.objecttypefieldname)))) {
            ValueMetaString v = new ValueMetaString(realObjectType);
            v.setLength(500);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)(sysobject = variables.resolve(this.issystemobjectfieldname)))) {
            ValueMetaBoolean v = new ValueMetaBoolean(sysobject);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)(realSqlCreation = variables.resolve(this.sqlcreationfieldname)))) {
            ValueMetaString v = new ValueMetaString(realSqlCreation);
            v.setLength(500);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((IValueMeta)v);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XmlHandler.addTagValue((String)"connection", (String)(this.database == null ? "" : this.database.getName())));
        retval.append("    " + XmlHandler.addTagValue((String)"schemaname", (String)this.schemaname));
        retval.append("    " + XmlHandler.addTagValue((String)"tablenamefieldname", (String)this.tablenamefieldname));
        retval.append("    " + XmlHandler.addTagValue((String)"objecttypefieldname", (String)this.objecttypefieldname));
        retval.append("    " + XmlHandler.addTagValue((String)"issystemobjectfieldname", (String)this.issystemobjectfieldname));
        retval.append("    " + XmlHandler.addTagValue((String)"sqlcreationfieldname", (String)this.sqlcreationfieldname));
        retval.append("    " + XmlHandler.addTagValue((String)"includeCatalog", (boolean)this.includeCatalog));
        retval.append("    " + XmlHandler.addTagValue((String)"includeSchema", (boolean)this.includeSchema));
        retval.append("    " + XmlHandler.addTagValue((String)"includeTable", (boolean)this.includeTable));
        retval.append("    " + XmlHandler.addTagValue((String)"includeView", (boolean)this.includeView));
        retval.append("    " + XmlHandler.addTagValue((String)"includeProcedure", (boolean)this.includeProcedure));
        retval.append("    " + XmlHandler.addTagValue((String)"includeSynonym", (boolean)this.includeSynonym));
        retval.append("    " + XmlHandler.addTagValue((String)"addSchemaInOutput", (boolean)this.addSchemaInOutput));
        retval.append("    " + XmlHandler.addTagValue((String)"dynamicSchema", (boolean)this.dynamicSchema));
        retval.append("    " + XmlHandler.addTagValue((String)"schemaNameField", (String)this.schemaNameField));
        return retval.toString();
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.metadataProvider = metadataProvider;
            String con = XmlHandler.getTagValue((Node)transformNode, (String)"connection");
            this.database = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)con);
            this.schemaname = XmlHandler.getTagValue((Node)transformNode, (String)"schemaname");
            this.tablenamefieldname = XmlHandler.getTagValue((Node)transformNode, (String)"tablenamefieldname");
            this.objecttypefieldname = XmlHandler.getTagValue((Node)transformNode, (String)"objecttypefieldname");
            this.sqlcreationfieldname = XmlHandler.getTagValue((Node)transformNode, (String)"sqlcreationfieldname");
            this.issystemobjectfieldname = XmlHandler.getTagValue((Node)transformNode, (String)"issystemobjectfieldname");
            this.includeCatalog = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"includeCatalog"));
            this.includeSchema = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"includeSchema"));
            this.includeTable = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"includeTable"));
            this.includeView = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"includeView"));
            this.includeProcedure = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"includeProcedure"));
            this.includeSynonym = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"includeSynonym"));
            this.addSchemaInOutput = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"addSchemaInOutput"));
            this.dynamicSchema = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"dynamicSchema"));
            this.schemaNameField = XmlHandler.getTagValue((Node)transformNode, (String)"schemaNameField");
            if (XmlHandler.getTagValue((Node)transformNode, (String)"schenameNameField") != null) {
                this.schemaNameField = XmlHandler.getTagValue((Node)transformNode, (String)"schenameNameField");
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"GetTableNamesMeta.Exception.UnableToReadTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        if (this.database == null) {
            errorMessage = BaseMessages.getString(PKG, (String)"GetTableNamesMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (Utils.isEmpty((CharSequence)this.tablenamefieldname)) {
            errorMessage = BaseMessages.getString(PKG, (String)"GetTableNamesMeta.CheckResult.TablenameFieldNameMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"GetTableNamesMeta.CheckResult.TablenameFieldNameOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        cr = input.length > 0 && !this.isDynamicSchema() ? new CheckResult(4, BaseMessages.getString(PKG, (String)"GetTableNamesMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GetTableNamesMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

