/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.PartitionLookupUtils;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import java.io.Serializable;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartition;
import org.apache.beam.sdk.testing.SerializableMatchers;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.splittabledofn.ManualWatermarkEstimator;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.sdk.transforms.splittabledofn.WatermarkEstimators;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;

class SubscriptionPartitionLoader
extends PTransform<PBegin, PCollection<SubscriptionPartition>> {
    private final TopicPath topic;
    private final SubscriptionPath subscription;
    private final SerializableFunction<TopicPath, Integer> getPartitionCount;
    private final Duration pollDuration;
    private final SerializableMatchers.SerializableSupplier<Boolean> terminate;

    SubscriptionPartitionLoader(TopicPath topic, SubscriptionPath subscription) {
        this(topic, subscription, (SerializableFunction<TopicPath, Integer>)((SerializableFunction & Serializable)PartitionLookupUtils::numPartitions), Duration.standardMinutes((long)1L), (SerializableMatchers.SerializableSupplier<Boolean>)(SerializableMatchers.SerializableSupplier & Serializable)() -> false);
    }

    @VisibleForTesting
    SubscriptionPartitionLoader(TopicPath topic, SubscriptionPath subscription, SerializableFunction<TopicPath, Integer> getPartitionCount, Duration pollDuration, SerializableMatchers.SerializableSupplier<Boolean> terminate) {
        this.topic = topic;
        this.subscription = subscription;
        this.getPartitionCount = getPartitionCount;
        this.pollDuration = pollDuration;
        this.terminate = terminate;
    }

    public PCollection<SubscriptionPartition> expand(PBegin input) {
        return (PCollection)((PCollection)input.apply("Impulse", (PTransform)Impulse.create())).apply("Watch Partition Count", (PTransform)ParDo.of((DoFn)new GeneratorFn()));
    }

    private class GeneratorFn
    extends DoFn<byte[], SubscriptionPartition> {
        private GeneratorFn() {
        }

        @DoFn.ProcessElement
        public DoFn.ProcessContinuation processElement(RestrictionTracker<Integer, Integer> restrictionTracker, DoFn.OutputReceiver<SubscriptionPartition> output, ManualWatermarkEstimator<Instant> estimator) {
            int previousCount = (Integer)restrictionTracker.currentRestriction();
            int newCount = (Integer)SubscriptionPartitionLoader.this.getPartitionCount.apply((Object)SubscriptionPartitionLoader.this.topic);
            if (!restrictionTracker.tryClaim((Object)newCount)) {
                return DoFn.ProcessContinuation.stop();
            }
            if (newCount > previousCount) {
                for (int i = previousCount; i < newCount; ++i) {
                    output.outputWithTimestamp((Object)SubscriptionPartition.of(SubscriptionPartitionLoader.this.subscription, Partition.of((long)i)), estimator.currentWatermark());
                }
            }
            estimator.setWatermark(this.getWatermark());
            return DoFn.ProcessContinuation.resume().withResumeDelay(SubscriptionPartitionLoader.this.pollDuration);
        }

        @DoFn.GetInitialWatermarkEstimatorState
        public Instant getInitialWatermarkEstimatorState(@DoFn.Timestamp Instant initial) {
            return Instant.EPOCH;
        }

        @DoFn.GetInitialRestriction
        public Integer getInitialRestriction() {
            return 0;
        }

        @DoFn.NewTracker
        public RestrictionTracker<Integer, Integer> newTracker(final @DoFn.Restriction Integer input) {
            return new RestrictionTracker<Integer, Integer>(){
                private boolean terminated = false;
                private int position = input;

                public boolean tryClaim(Integer newPosition) {
                    Preconditions.checkArgument((newPosition >= this.position ? 1 : 0) != 0);
                    if (this.terminated) {
                        return false;
                    }
                    if (((Boolean)SubscriptionPartitionLoader.this.terminate.get()).booleanValue()) {
                        this.terminated = true;
                        return false;
                    }
                    this.position = newPosition;
                    return true;
                }

                public Integer currentRestriction() {
                    return this.position;
                }

                public @Nullable SplitResult<Integer> trySplit(double fractionOfRemainder) {
                    if (fractionOfRemainder != 0.0) {
                        return null;
                    }
                    if (this.terminated) {
                        return null;
                    }
                    this.terminated = true;
                    return SplitResult.of((Object)this.position, (Object)this.position);
                }

                public void checkDone() throws IllegalStateException {
                    Preconditions.checkState((boolean)this.terminated);
                }

                public RestrictionTracker.IsBounded isBounded() {
                    return RestrictionTracker.IsBounded.UNBOUNDED;
                }
            };
        }

        @DoFn.NewWatermarkEstimator
        public ManualWatermarkEstimator<Instant> newWatermarkEstimator(@DoFn.WatermarkEstimatorState Instant state) {
            return new WatermarkEstimators.Manual(state);
        }

        private Instant getWatermark() {
            return Instant.now().minus((ReadableDuration)this.watermarkDelay());
        }

        private Duration watermarkDelay() {
            return SubscriptionPartitionLoader.this.pollDuration.multipliedBy(3L).dividedBy(2L);
        }
    }
}

