/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.AvroSource;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQuerySourceBase;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryTableSourceDef;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.nullness.qual.Nullable;

@VisibleForTesting
class BigQueryTableSource<T>
extends BigQuerySourceBase<T> {
    private final BigQueryTableSourceDef tableDef;
    private final AtomicReference<@Nullable Long> tableSizeBytes;

    static <T> BigQueryTableSource<T> create(String stepUuid, BigQueryTableSourceDef tableDef, BigQueryServices bqServices, Coder<T> coder, SerializableFunction<TableSchema, AvroSource.DatumReaderFactory<T>> readerFactory, boolean useAvroLogicalTypes) {
        return new BigQueryTableSource<T>(stepUuid, tableDef, bqServices, coder, readerFactory, useAvroLogicalTypes);
    }

    private BigQueryTableSource(String stepUuid, BigQueryTableSourceDef tableDef, BigQueryServices bqServices, Coder<T> coder, SerializableFunction<TableSchema, AvroSource.DatumReaderFactory<T>> readerFactory, boolean useAvroLogicalTypes) {
        super(stepUuid, bqServices, coder, readerFactory, useAvroLogicalTypes);
        this.tableDef = tableDef;
        this.tableSizeBytes = new AtomicReference();
    }

    @Override
    protected TableReference getTableToExtract(BigQueryOptions bqOptions) throws IOException {
        return this.tableDef.getTableReference(bqOptions);
    }

    public synchronized long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
        Long maybeNumBytes = this.tableSizeBytes.get();
        if (maybeNumBytes != null) {
            return maybeNumBytes;
        }
        BigQueryOptions bqOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
        TableReference tableRef = this.tableDef.getTableReference(bqOptions);
        try (BigQueryServices.DatasetService datasetService = this.bqServices.getDatasetService(bqOptions);){
            Table table = datasetService.getTable(tableRef);
            if (table == null) {
                throw new IllegalStateException("Table not found: " + table);
            }
            Long numBytes = table.getNumBytes();
            if (table.getStreamingBuffer() != null && table.getStreamingBuffer().getEstimatedBytes() != null) {
                numBytes = numBytes + table.getStreamingBuffer().getEstimatedBytes().longValue();
            }
            this.tableSizeBytes.compareAndSet(null, numBytes);
            long l = numBytes;
            return l;
        }
    }

    @Override
    protected void cleanupTempResource(BigQueryOptions bqOptions) throws Exception {
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"table", this.tableDef.getJsonTable()));
        builder.add(DisplayData.item((String)"launchesBigQueryJobs", (Boolean)true).withLabel("This transform launches BigQuery jobs to read/write elements."));
    }
}

