/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.execution;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.invoke.CallSite;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.json.HopJson;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.row.RowBuffer;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.execution.Execution;
import org.apache.hop.execution.ExecutionBuilder;
import org.apache.hop.execution.ExecutionData;
import org.apache.hop.execution.ExecutionDataBuilder;
import org.apache.hop.execution.ExecutionDataSetMeta;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.execution.ExecutionStateBuilder;
import org.apache.hop.execution.ExecutionStateComponentMetrics;
import org.apache.hop.execution.ExecutionType;
import org.apache.hop.execution.IExecutionInfoLocation;
import org.apache.hop.execution.IExecutionMatcher;
import org.apache.hop.execution.plugin.ExecutionInfoLocationPlugin;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.neo4j.actions.index.IndexUpdate;
import org.apache.hop.neo4j.actions.index.Neo4jIndex;
import org.apache.hop.neo4j.actions.index.ObjectType;
import org.apache.hop.neo4j.actions.index.UpdateType;
import org.apache.hop.neo4j.execution.builder.CypherCreateBuilder;
import org.apache.hop.neo4j.execution.builder.CypherDeleteBuilder;
import org.apache.hop.neo4j.execution.builder.CypherMergeBuilder;
import org.apache.hop.neo4j.execution.builder.CypherQueryBuilder;
import org.apache.hop.neo4j.execution.builder.CypherRelationshipBuilder;
import org.apache.hop.neo4j.execution.builder.ICypherBuilder;
import org.apache.hop.neo4j.shared.NeoConnection;
import org.apache.hop.neo4j.shared.NeoConnectionTypeMetadata;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.workflow.delegates.HopGuiWorkflowClipboardDelegate;
import org.apache.hop.workflow.action.ActionMeta;
import org.apache.hop.workflow.action.IAction;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;

@GuiPlugin(description="Neo4j execution information location GUI elements")
@ExecutionInfoLocationPlugin(id="neo4j-location", name="Neo4j location", description="Stores execution information in a Neo4j graph database")
public class NeoExecutionInfoLocation
implements IExecutionInfoLocation {
    public static final String EL_EXECUTION = "Execution";
    public static final String EP_ID = "id";
    public static final String EP_NAME = "name";
    public static final String EP_COPY_NR = "copyNr";
    public static final String EP_FILENAME = "filename";
    public static final String EP_PARENT_ID = "parentId";
    public static final String EP_EXECUTION_TYPE = "executionType";
    public static final String EP_EXECUTOR_XML = "executorXml";
    public static final String EP_METADATA_JSON = "metadataJson";
    public static final String EP_RUN_CONFIG_NAME = "runConfigName";
    public static final String EP_LOG_LEVEL = "logLevel";
    public static final String EP_REGISTRATION_DATE = "registrationDate";
    public static final String EP_EXECUTION_START_DATE = "executionStartDate";
    public static final String EP_LOGGING_TEXT = "loggingText";
    public static final String EP_STATUS_DESCRIPTION = "statusDescription";
    public static final String EP_UPDATE_TIME = "updateTime";
    public static final String EP_CHILD_IDS = "childIds";
    public static final String EP_FAILED = "failed";
    public static final String EP_DETAILS = "details";
    public static final String EP_CONTAINER_ID = "containerId";
    public static final String CL_EXECUTION_METRIC = "ExecutionMetric";
    public static final String CP_ID = "id";
    public static final String CP_NAME = "name";
    public static final String CP_COPY_NR = "copyNr";
    public static final String CP_METRIC_KEY = "metricKey";
    public static final String CP_METRIC_VALUE = "metricValue";
    public static final String DL_EXECUTION_DATA = "ExecutionData";
    public static final String DP_PARENT_ID = "parentId";
    public static final String DP_OWNER_ID = "ownerId";
    public static final String DP_FINISHED = "finished";
    public static final String DP_EXECUTION_TYPE = "executionType";
    public static final String DP_COLLECTION_DATE = "collectionDate";
    public static final String ML_EXECUTION_DATA_SET_META = "ExecutionDataSetMeta";
    public static final String MP_PARENT_ID = "parentId";
    public static final String MP_OWNER_ID = "ownerId";
    public static final String MP_SET_KEY = "setKey";
    public static final String MP_NAME = "name";
    public static final String MP_COPY_NR = "copyNr";
    public static final String MP_DESCRIPTION = "description";
    public static final String MP_FIELD_NAME = "fieldName";
    public static final String MP_LOG_CHANNEL_ID = "logChannelId";
    public static final String MP_SAMPLE_DESCRIPTION = "sampleDescription";
    public static final String TL_EXECUTION_DATA_SET = "ExecutionDataSet";
    public static final String TP_PARENT_ID = "parentId";
    public static final String TP_OWNER_ID = "ownerId";
    public static final String TP_SET_KEY = "setKey";
    public static final String TP_ROW_META_JSON = "rowMetaJson";
    public static final String OL_EXECUTION_DATA_SET_ROW = "ExecutionDataSetRow";
    public static final String OP_PARENT_ID = "parentId";
    public static final String OP_OWNER_ID = "ownerId";
    public static final String OP_SET_KEY = "setKey";
    public static final String OP_ROW_NR = "rowNr";
    public static final String R_EXECUTES = "EXECUTES";
    public static final String R_HAS_DATA = "HAS_DATA";
    public static final String R_HAS_METADATA = "HAS_METADATA";
    public static final String R_HAS_DATASET = "HAS_DATASET";
    public static final String R_HAS_ROW = "HAS_ROW";
    @HopMetadataProperty
    protected String pluginId;
    @HopMetadataProperty
    protected String pluginName;
    @GuiWidgetElement(id="connectionName", order="010", parentId="ExecutionInfoLocation-PluginSpecific-Options", type=GuiElementType.METADATA, typeMetadata=NeoConnectionTypeMetadata.class, toolTip="i18n::NeoExecutionInfoLocation.Connection.Tooltip", label="i18n::NeoExecutionInfoLocation.Connection.Label")
    @HopMetadataProperty(key="connection")
    protected String connectionName;
    private ILogChannel log;
    private Driver driver;
    private Session session;

    public NeoExecutionInfoLocation() {
    }

    public NeoExecutionInfoLocation(NeoExecutionInfoLocation location) {
        this.pluginId = location.pluginId;
        this.pluginName = location.pluginName;
        this.connectionName = location.connectionName;
    }

    public NeoExecutionInfoLocation clone() {
        return new NeoExecutionInfoLocation(this);
    }

    public void initialize(IVariables variables, IHopMetadataProvider metadataProvider) throws HopException {
        this.log = LogChannel.GENERAL;
        this.validateSettings();
        try {
            NeoConnection connection = (NeoConnection)metadataProvider.getSerializer(NeoConnection.class).load(variables.resolve(this.connectionName));
            if (connection == null) {
                throw new HopException("Unable to find Neo4j connection " + this.connectionName);
            }
            this.driver = connection.getDriver(this.log, variables);
            this.session = connection.getSession(this.log, this.driver, variables);
        }
        catch (Exception e) {
            throw new HopException("Error initializing Neo4j Execution Information location for connection " + this.connectionName, (Throwable)e);
        }
    }

    public void close() throws HopException {
        try {
            this.session.close();
            this.driver.close();
        }
        catch (Exception e) {
            throw new HopException("Error closing Neo4j execution information location", (Throwable)e);
        }
    }

    @GuiWidgetElement(id="createIndexesButton", order="020", parentId="ExecutionInfoLocation-PluginSpecific-Options", type=GuiElementType.BUTTON, label="i18n::NeoExecutionInfoLocation.CreateIndexes.Label", toolTip="i18n::NeoExecutionInfoLocation.CreateIndexes.Tooltip")
    public void createIndexesButton(Object object) {
        StringBuilder cypher = new StringBuilder();
        this.addIndex(cypher, "idx_execution_id", EL_EXECUTION, "id");
        this.addIndex(cypher, "idx_execution_failed", EL_EXECUTION, EP_FAILED);
        this.addIndex(cypher, "idx_execution_parent_id", EL_EXECUTION, "parentId");
        this.addIndex(cypher, "idx_execution_metric_id", EL_EXECUTION, "id", "name", "copyNr");
        this.addIndex(cypher, "idx_execution_data_id", DL_EXECUTION_DATA, "parentId", "ownerId");
        this.addIndex(cypher, "idx_execution_data_set_meta_id", ML_EXECUTION_DATA_SET_META, "parentId", "ownerId", "setKey");
        this.addIndex(cypher, "idx_execution_data_set_id", TL_EXECUTION_DATA_SET, "parentId", "ownerId", "setKey");
        this.addIndex(cypher, "idx_execution_data_set_row_id", OL_EXECUTION_DATA_SET_ROW, "parentId", "ownerId", "setKey");
        EnterTextDialog textDialog = new EnterTextDialog(HopGui.getInstance().getShell(), "Indexes DDL", "Here is the list of Cypher statements to execute for the Neo4j location", cypher.toString());
        textDialog.open();
    }

    private void addIndex(StringBuilder cypher, String indexName, String label, String ... keys) {
        assert (keys != null && keys.length > 0) : "specify one or more keys";
        Object keysClause = "ON ";
        boolean firstKey = true;
        for (String key : keys) {
            if (firstKey) {
                firstKey = false;
                keysClause = (String)keysClause + "( ";
            } else {
                keysClause = (String)keysClause + ", ";
            }
            keysClause = (String)keysClause + "n." + key;
        }
        keysClause = (String)keysClause + ") ";
        cypher.append("CREATE INDEX ").append(indexName).append(" IF NOT EXISTS FOR (n:").append(label).append(") ").append((String)keysClause);
        cypher.append(Const.CR).append(";").append(Const.CR);
    }

    @GuiWidgetElement(id="createIndexesAction", order="030", parentId="ExecutionInfoLocation-PluginSpecific-Options", type=GuiElementType.BUTTON, label="i18n::NeoExecutionInfoLocation.CreateIndexAction.Label", toolTip="i18n::NeoExecutionInfoLocation.CreateIndexAction.Tooltip")
    public void copyIndexActionToClipboardButton(Object object) {
        try {
            Neo4jIndex neo4jIndex = new Neo4jIndex("Neo4j Index", null);
            String connectionName = ((NeoExecutionInfoLocation)object).getConnectionName();
            if (StringUtils.isNotEmpty((String)connectionName)) {
                NeoConnection neoConnection = (NeoConnection)HopGui.getInstance().getMetadataProvider().getSerializer(NeoConnection.class).load(connectionName);
                neo4jIndex.setConnection(neoConnection);
            }
            this.addIndex(neo4jIndex, "idx_execution_id", EL_EXECUTION, "id");
            this.addIndex(neo4jIndex, "idx_execution_failed", EL_EXECUTION, EP_FAILED);
            this.addIndex(neo4jIndex, "idx_execution_parent_id", EL_EXECUTION, "parentId");
            this.addIndex(neo4jIndex, "idx_execution_metric_id", EL_EXECUTION, "id", "name", "copyNr");
            this.addIndex(neo4jIndex, "idx_execution_data_id", DL_EXECUTION_DATA, "parentId", "ownerId");
            this.addIndex(neo4jIndex, "idx_execution_data_set_meta_id", ML_EXECUTION_DATA_SET_META, "parentId", "ownerId", "setKey");
            this.addIndex(neo4jIndex, "idx_execution_data_set_id", TL_EXECUTION_DATA_SET, "parentId", "ownerId", "setKey");
            this.addIndex(neo4jIndex, "idx_execution_data_set_row_id", OL_EXECUTION_DATA_SET_ROW, "parentId", "ownerId", "setKey");
            ActionMeta actionMeta = new ActionMeta((IAction)neo4jIndex);
            actionMeta.setLocation(50, 50);
            HopGuiWorkflowClipboardDelegate.copyActionsToClipboard(List.of(actionMeta));
            MessageBox box = new MessageBox(HopGui.getInstance().getShell(), 34);
            box.setText("Copied to clipboard");
            box.setMessage("A Neo4j Index action was copied to the clipboard.  You can paste this in a workflow to make sure you have great performance when updating execution information in this Neo4j location.");
            box.open();
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), "Error", "Error copying Neo4j Index action to the clipboard", e);
        }
    }

    private void addIndex(Neo4jIndex neo4jIndex, String indexName, String label, String ... keys) {
        StringBuilder properties = new StringBuilder();
        for (String key : keys) {
            if (properties.length() > 0) {
                properties.append(",");
            }
            properties.append(key);
        }
        IndexUpdate indexUpdate = new IndexUpdate(UpdateType.CREATE, ObjectType.NODE, indexName, label, properties.toString());
        neo4jIndex.getIndexUpdates().add(indexUpdate);
    }

    private void validateSettings() throws HopException {
        if (StringUtils.isEmpty((String)this.connectionName)) {
            throw new HopException("Please specify a Neo4j connection to send execution information to.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerExecution(Execution execution) throws HopException {
        NeoExecutionInfoLocation neoExecutionInfoLocation = this;
        synchronized (neoExecutionInfoLocation) {
            try {
                assert (execution.getName() != null) : "Please register executions with a name";
                assert (execution.getExecutionType() != null) : "Please register executions with an execution type";
                this.session.writeTransaction(transaction -> this.registerNeo4jExecution(transaction, execution));
            }
            catch (Exception e) {
                throw new HopException("Error registering execution in Neo4j", (Throwable)e);
            }
        }
    }

    private boolean registerNeo4jExecution(Transaction transaction, Execution execution) {
        try {
            CypherMergeBuilder builder = CypherMergeBuilder.of().withLabelAndKey(EL_EXECUTION, "id", execution.getId()).withValue("name", execution.getName()).withValue("copyNr", execution.getCopyNr()).withValue(EP_FILENAME, execution.getFilename()).withValue("parentId", execution.getParentId()).withValue("executionType", execution.getExecutionType().name()).withValue(EP_EXECUTOR_XML, execution.getExecutorXml()).withValue(EP_METADATA_JSON, execution.getMetadataJson()).withValue(EP_RUN_CONFIG_NAME, execution.getRunConfigurationName()).withValue(EP_LOG_LEVEL, execution.getLogLevel() == null ? null : execution.getLogLevel().getCode()).withValue(EP_REGISTRATION_DATE, execution.getRegistrationDate()).withValue(EP_EXECUTION_START_DATE, execution.getExecutionStartDate());
            this.execute(transaction, builder);
            if (StringUtils.isNotEmpty((String)execution.getParentId())) {
                CypherRelationshipBuilder selfRelationshipBuilder = CypherRelationshipBuilder.of().withMatch(EL_EXECUTION, "e1", "id", execution.getId()).withMatch(EL_EXECUTION, "e2", "id", execution.getParentId()).withMerge("e2", "e1", R_EXECUTES);
                this.execute(transaction, selfRelationshipBuilder);
            }
            transaction.commit();
            return true;
        }
        catch (Exception e) {
            transaction.rollback();
            throw e;
        }
    }

    public boolean deleteExecution(String executionId) throws HopException {
        NeoExecutionInfoLocation neoExecutionInfoLocation = this;
        synchronized (neoExecutionInfoLocation) {
            try {
                return (Boolean)this.session.writeTransaction(transaction -> this.deleteNeo4jExecution(transaction, executionId));
            }
            catch (Exception e) {
                throw new HopException("Error deleting execution with id " + executionId + " in Neo4j", (Throwable)e);
            }
        }
    }

    private boolean deleteNeo4jExecution(Transaction transaction, String executionId) {
        List<Execution> childExecutions = this.findNeo4jExecutions(transaction, executionId);
        for (Execution childExecution : childExecutions) {
            this.deleteNeo4jExecution(transaction, childExecution.getId());
        }
        this.execute(transaction, ((CypherDeleteBuilder)CypherDeleteBuilder.of().withMatch(OL_EXECUTION_DATA_SET_ROW, "n", Map.of("parentId", executionId))).withDetachDelete("n"));
        this.execute(transaction, ((CypherDeleteBuilder)CypherDeleteBuilder.of().withMatch(ML_EXECUTION_DATA_SET_META, "n", Map.of("parentId", executionId))).withDetachDelete("n"));
        this.execute(transaction, ((CypherDeleteBuilder)CypherDeleteBuilder.of().withMatch(TL_EXECUTION_DATA_SET, "n", Map.of("parentId", executionId))).withDetachDelete("n"));
        this.execute(transaction, ((CypherDeleteBuilder)CypherDeleteBuilder.of().withMatch(DL_EXECUTION_DATA, "n", Map.of("parentId", executionId))).withDetachDelete("n"));
        this.execute(transaction, ((CypherDeleteBuilder)CypherDeleteBuilder.of().withMatch(CL_EXECUTION_METRIC, "n", Map.of("id", executionId))).withDetachDelete("n"));
        this.execute(transaction, ((CypherDeleteBuilder)CypherDeleteBuilder.of().withMatch(EL_EXECUTION, "n", Map.of("id", executionId))).withDetachDelete("n"));
        return true;
    }

    public Execution getExecution(String executionId) throws HopException {
        NeoExecutionInfoLocation neoExecutionInfoLocation = this;
        synchronized (neoExecutionInfoLocation) {
            try {
                return (Execution)this.session.readTransaction(transaction -> this.getNeo4jExecution(transaction, executionId));
            }
            catch (Exception e) {
                throw new HopException("Error getting execution from Neo4j", (Throwable)e);
            }
        }
    }

    private Execution getNeo4jExecution(Transaction transaction, String executionId) {
        CypherQueryBuilder builder = CypherQueryBuilder.of().withLabelAndKey("n", EL_EXECUTION, "id", executionId).withReturnValues("n", "name", "copyNr", EP_FILENAME, "parentId", "executionType", EP_EXECUTOR_XML, EP_METADATA_JSON, EP_RUN_CONFIG_NAME, EP_LOG_LEVEL, EP_REGISTRATION_DATE, EP_EXECUTION_START_DATE);
        Result result = transaction.run(builder.cypher(), builder.parameters());
        if (!result.hasNext()) {
            return null;
        }
        Record record = result.next();
        return ExecutionBuilder.of().withId(executionId).withParentId(this.getString(record, "parentId")).withName(this.getString(record, "name")).withCopyNr(this.getString(record, "copyNr")).withFilename(this.getString(record, EP_FILENAME)).withExecutorType(ExecutionType.valueOf((String)this.getString(record, "executionType"))).withExecutorXml(this.getString(record, EP_EXECUTOR_XML)).withMetadataJson(this.getString(record, EP_METADATA_JSON)).withRunConfigurationName(this.getString(record, EP_RUN_CONFIG_NAME)).withLogLevel(LogLevel.getLogLevelForCode((String)this.getString(record, EP_LOG_LEVEL))).withRegistrationDate(this.getDate(record, EP_REGISTRATION_DATE)).withExecutionStartDate(this.getDate(record, EP_EXECUTION_START_DATE)).build();
    }

    public List<String> getExecutionIds(boolean includeChildren, int limit) throws HopException {
        NeoExecutionInfoLocation neoExecutionInfoLocation = this;
        synchronized (neoExecutionInfoLocation) {
            try {
                return (List)this.session.readTransaction(transaction -> this.getNeo4jExecutionIds(transaction, includeChildren, limit));
            }
            catch (Exception e) {
                throw new HopException("Error getting execution from Neo4j", (Throwable)e);
            }
        }
    }

    private List<String> getNeo4jExecutionIds(Transaction transaction, boolean includeChildren, int limit) {
        ArrayList<String> ids = new ArrayList<String>();
        CypherQueryBuilder builder = CypherQueryBuilder.of().withLabelWithoutKey("n", EL_EXECUTION);
        if (!includeChildren) {
            builder.withWhereIsNull("n", "parentId");
        }
        builder.withReturnValues("n", "id").withOrderBy("n", EP_REGISTRATION_DATE, false).withLimit(limit);
        Result result = transaction.run(builder.cypher());
        while (result.hasNext()) {
            Record record = result.next();
            ids.add(this.getString(record, "id"));
        }
        return ids;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateExecutionState(ExecutionState executionState) throws HopException {
        NeoExecutionInfoLocation neoExecutionInfoLocation = this;
        synchronized (neoExecutionInfoLocation) {
            try {
                assert (executionState.getName() != null) : "Please update execution states with a name";
                assert (executionState.getExecutionType() != null) : "Please update execution states with an execution type";
                this.session.writeTransaction(transaction -> this.updateNeo4jExecutionState(transaction, executionState));
            }
            catch (Exception e) {
                throw new HopException("Error updating execution state in Neo4j", (Throwable)e);
            }
        }
    }

    private boolean updateNeo4jExecutionState(Transaction transaction, ExecutionState state) {
        try {
            CypherMergeBuilder stateCypherBuilder = CypherMergeBuilder.of().withLabelAndKey(EL_EXECUTION, "id", state.getId()).withValue(EP_STATUS_DESCRIPTION, state.getStatusDescription()).withValue(EP_LOGGING_TEXT, state.getLoggingText()).withValue(EP_UPDATE_TIME, state.getUpdateTime()).withValue(EP_CHILD_IDS, state.getChildIds()).withValue(EP_FAILED, state.isFailed()).withValue(EP_DETAILS, state.getDetails()).withValue(EP_CONTAINER_ID, state.getContainerId());
            transaction.run(stateCypherBuilder.cypher(), stateCypherBuilder.parameters());
            if (state.getMetrics() != null) {
                for (ExecutionStateComponentMetrics metric : state.getMetrics()) {
                    for (String metricKey : metric.getMetrics().keySet()) {
                        CypherCreateBuilder metricBuilder = CypherCreateBuilder.of().withLabelAndKeys(CL_EXECUTION_METRIC, Map.of("id", state.getId(), "name", metric.getComponentName(), "copyNr", metric.getComponentCopy(), CP_METRIC_KEY, metricKey)).withValue(CP_METRIC_VALUE, metric.getMetrics().get(metricKey));
                        this.execute(transaction, metricBuilder);
                    }
                }
            }
            transaction.commit();
            return true;
        }
        catch (Exception e) {
            transaction.rollback();
            throw e;
        }
    }

    public ExecutionState getExecutionState(String executionId) throws HopException {
        NeoExecutionInfoLocation neoExecutionInfoLocation = this;
        synchronized (neoExecutionInfoLocation) {
            try {
                return (ExecutionState)this.session.readTransaction(transaction -> this.getNeo4jExecutionState(transaction, executionId));
            }
            catch (Exception e) {
                throw new HopException("Error getting execution from Neo4j", (Throwable)e);
            }
        }
    }

    private ExecutionState getNeo4jExecutionState(Transaction transaction, String executionId) {
        CypherQueryBuilder executionBuilder = CypherQueryBuilder.of().withLabelAndKey("n", EL_EXECUTION, "id", executionId).withReturnValues("n", "name", "executionType", "copyNr", "parentId", EP_LOGGING_TEXT, EP_STATUS_DESCRIPTION, EP_UPDATE_TIME, EP_CHILD_IDS, EP_FAILED, EP_DETAILS, EP_CONTAINER_ID);
        Result result = transaction.run(executionBuilder.cypher(), executionBuilder.parameters());
        if (!result.hasNext()) {
            return null;
        }
        Record record = result.next();
        ExecutionStateBuilder stateBuilder = ExecutionStateBuilder.of().withId(executionId).withName(this.getString(record, "name")).withCopyNr(this.getString(record, "copyNr")).withParentId(this.getString(record, "parentId")).withLoggingText(this.getString(record, EP_LOGGING_TEXT)).withExecutionType(ExecutionType.valueOf((String)this.getString(record, "executionType"))).withStatusDescription(this.getString(record, EP_STATUS_DESCRIPTION)).withUpdateTime(this.getDate(record, EP_UPDATE_TIME)).withChildIds(this.getList(record, EP_CHILD_IDS)).withFailed(this.getBoolean(record, EP_FAILED)).withDetails(this.getMap(record, EP_DETAILS)).withContainerId(this.getString(record, EP_CONTAINER_ID));
        Result metricsResult = this.execute(transaction, CypherQueryBuilder.of().withLabelAndKeys("n", CL_EXECUTION_METRIC, Map.of("id", executionId)).withReturnValues("n", "name", "copyNr", CP_METRIC_KEY, CP_METRIC_VALUE));
        HashMap<String, ExecutionStateComponentMetrics> metricsMap = new HashMap<String, ExecutionStateComponentMetrics>();
        while (metricsResult.hasNext()) {
            Record metricsRecord = metricsResult.next();
            String componentName = this.getString(metricsRecord, "name");
            String componentCopy = this.getString(metricsRecord, "copyNr");
            String componentKey = componentName + "." + componentCopy;
            String metricKey = this.getString(metricsRecord, CP_METRIC_KEY);
            Long metricValue = this.getLong(metricsRecord, CP_METRIC_VALUE);
            if (metricValue == null) continue;
            ExecutionStateComponentMetrics metric = metricsMap.computeIfAbsent(componentKey, f -> new ExecutionStateComponentMetrics(componentName, componentCopy));
            metric.getMetrics().put(metricKey, metricValue);
        }
        stateBuilder.withMetrics(new ArrayList(metricsMap.values()));
        return stateBuilder.build();
    }

    public List<Execution> findExecutions(String parentExecutionId) throws HopException {
        NeoExecutionInfoLocation neoExecutionInfoLocation = this;
        synchronized (neoExecutionInfoLocation) {
            try {
                return (List)this.session.readTransaction(transaction -> this.findNeo4jExecutions(transaction, parentExecutionId));
            }
            catch (Exception e) {
                throw new HopException("Error getting execution from Neo4j", (Throwable)e);
            }
        }
    }

    public Execution findPreviousSuccessfulExecution(ExecutionType executionType, String name) throws HopException {
        NeoExecutionInfoLocation neoExecutionInfoLocation = this;
        synchronized (neoExecutionInfoLocation) {
            try {
                return (Execution)this.session.readTransaction(transaction -> this.findNeo4jPreviousSuccessfulExecution(transaction, executionType, name));
            }
            catch (Exception e) {
                throw new HopException("Error find previous successful execution in Neo4j", (Throwable)e);
            }
        }
    }

    private Execution findNeo4jPreviousSuccessfulExecution(Transaction transaction, ExecutionType executionType, String name) {
        List<Execution> executions = this.findNeo4jExecutions(transaction, e -> e.getExecutionType() == executionType && name.equals(e.getName()));
        for (Execution execution : executions) {
            ExecutionState executionState = this.getNeo4jExecutionState(transaction, execution.getId());
            if (executionState == null || executionState.isFailed()) continue;
            return execution;
        }
        return null;
    }

    private List<Execution> findNeo4jExecutions(Transaction transaction, String parentExecutionId) {
        ArrayList<Execution> executions = new ArrayList<Execution>();
        Result result = this.execute(transaction, CypherQueryBuilder.of().withLabelAndKey("n", EL_EXECUTION, "parentId", parentExecutionId).withReturnValues("n", "id"));
        while (result.hasNext()) {
            Record record = result.next();
            String executionId = this.getString(record, "id");
            try {
                Execution execution = this.getNeo4jExecution(transaction, executionId);
                if (execution == null) continue;
                executions.add(execution);
            }
            catch (Exception e) {
                this.log.logError("Error loading execution with id : " + executionId + " from Neo4j (non-fatal)", (Throwable)e);
            }
        }
        return executions;
    }

    public List<Execution> findExecutions(IExecutionMatcher matcher) throws HopException {
        NeoExecutionInfoLocation neoExecutionInfoLocation = this;
        synchronized (neoExecutionInfoLocation) {
            try {
                return (List)this.session.readTransaction(transaction -> this.findNeo4jExecutions(transaction, matcher));
            }
            catch (Exception e) {
                throw new HopException("Error getting execution from Neo4j", (Throwable)e);
            }
        }
    }

    private List<Execution> findNeo4jExecutions(Transaction transaction, IExecutionMatcher matcher) {
        ArrayList<Execution> executions = new ArrayList<Execution>();
        List<String> ids = this.getNeo4jExecutionIds(transaction, true, 0);
        for (String id : ids) {
            Execution execution = this.getNeo4jExecution(transaction, id);
            if (execution == null || !matcher.matches(execution)) continue;
            executions.add(execution);
        }
        return executions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerData(ExecutionData data) throws HopException {
        NeoExecutionInfoLocation neoExecutionInfoLocation = this;
        synchronized (neoExecutionInfoLocation) {
            try {
                this.session.writeTransaction(transaction -> this.registerNeo4jData(transaction, data));
            }
            catch (Exception e) {
                throw new HopException("Error getting execution from Neo4j", (Throwable)e);
            }
        }
    }

    private boolean registerNeo4jData(Transaction transaction, ExecutionData data) {
        try {
            assert (data != null) : "no execution data provided";
            assert (data.getExecutionType() != null) : "execution data has no type";
            CypherMergeBuilder stateCypherBuilder = CypherMergeBuilder.of().withLabelAndKeys(DL_EXECUTION_DATA, Map.of("parentId", data.getParentId(), "ownerId", data.getOwnerId())).withValue("executionType", data.getExecutionType().name()).withValue(DP_FINISHED, data.isFinished()).withValue(DP_COLLECTION_DATE, data.getCollectionDate());
            this.execute(transaction, stateCypherBuilder);
            CypherRelationshipBuilder executionDataRelCypherBuilder = ((CypherRelationshipBuilder)CypherRelationshipBuilder.of().withMatch(EL_EXECUTION, "n", "id", data.getParentId()).withMatch(DL_EXECUTION_DATA, "d", Map.of("parentId", data.getParentId(), "ownerId", data.getOwnerId()))).withMerge("n", "d", R_HAS_DATA);
            this.execute(transaction, executionDataRelCypherBuilder);
            ExecutionDataSetMeta dataSetMeta = data.getDataSetMeta();
            if (dataSetMeta != null) {
                this.saveDataSetMeta(transaction, data.getParentId(), data.getOwnerId(), dataSetMeta);
                this.execute(transaction, ((CypherRelationshipBuilder)((CypherRelationshipBuilder)CypherRelationshipBuilder.of().withMatch(DL_EXECUTION_DATA, "s", Map.of("parentId", data.getParentId(), "ownerId", data.getOwnerId()))).withMatch(ML_EXECUTION_DATA_SET_META, "m", Map.of("parentId", data.getParentId(), "ownerId", data.getOwnerId(), "setKey", dataSetMeta.getSetKey()))).withMerge("s", "m", R_HAS_METADATA));
            }
            for (String setKey : data.getDataSets().keySet()) {
                RowBuffer rowBuffer = (RowBuffer)data.getDataSets().get(setKey);
                ExecutionDataSetMeta setMeta = (ExecutionDataSetMeta)data.getSetMetaData().get(setKey);
                this.saveNeo4jRowsAndMeta(transaction, data.getParentId(), data.getOwnerId(), rowBuffer, setMeta);
            }
            transaction.commit();
            return true;
        }
        catch (Exception e) {
            transaction.rollback();
            throw e;
        }
    }

    private void saveNeo4jRowsAndMeta(Transaction transaction, String parentId, String ownerId, RowBuffer rowBuffer, ExecutionDataSetMeta setMeta) {
        try {
            IRowMeta rowMeta = rowBuffer.getRowMeta();
            String rowMetaJson = rowMeta == null ? null : JsonRowMeta.toJson((IRowMeta)rowMeta);
            this.execute(transaction, CypherMergeBuilder.of().withLabelAndKeys(TL_EXECUTION_DATA_SET, Map.of("parentId", parentId, "ownerId", ownerId, "setKey", setMeta.getSetKey())).withValue(TP_ROW_META_JSON, rowMetaJson));
            this.execute(transaction, ((CypherRelationshipBuilder)((CypherRelationshipBuilder)CypherRelationshipBuilder.of().withMatch(DL_EXECUTION_DATA, "d", Map.of("parentId", parentId, "ownerId", ownerId))).withMatch(TL_EXECUTION_DATA_SET, "s", Map.of("parentId", parentId, "ownerId", ownerId, "setKey", setMeta.getSetKey()))).withMerge("d", "s", R_HAS_DATASET));
            this.saveDataSetMeta(transaction, parentId, ownerId, setMeta);
            this.execute(transaction, ((CypherRelationshipBuilder)((CypherRelationshipBuilder)CypherRelationshipBuilder.of().withMatch(TL_EXECUTION_DATA_SET, "s", Map.of("parentId", parentId, "ownerId", ownerId, "setKey", setMeta.getSetKey()))).withMatch(ML_EXECUTION_DATA_SET_META, "m", Map.of("parentId", parentId, "ownerId", ownerId, "setKey", setMeta.getSetKey()))).withMerge("s", "m", R_HAS_METADATA));
            this.execute(transaction, ((CypherDeleteBuilder)((CypherDeleteBuilder)CypherDeleteBuilder.of().withMatch(TL_EXECUTION_DATA_SET, "s", Map.of("parentId", parentId, "ownerId", ownerId, "setKey", setMeta.getSetKey()))).withMatch(OL_EXECUTION_DATA_SET_ROW, "r", Map.of("parentId", parentId, "ownerId", ownerId, "setKey", setMeta.getSetKey()))).withRelationshipMatch(R_HAS_ROW, "rel", "s", "r").withDelete("r", "rel"));
            for (int rowNr = 1; rowNr <= rowBuffer.getBuffer().size(); ++rowNr) {
                Object[] row = (Object[])rowBuffer.getBuffer().get(rowNr - 1);
                CypherCreateBuilder builder = CypherCreateBuilder.of().withLabelAndKeys(OL_EXECUTION_DATA_SET_ROW, Map.of("parentId", parentId, "ownerId", ownerId, "setKey", setMeta.getSetKey(), OP_ROW_NR, rowNr));
                for (int v = 0; v < rowMeta.size(); ++v) {
                    IValueMeta valueMeta = rowMeta.getValueMeta(v);
                    builder.withValue("field" + v, valueMeta.getNativeDataType(row[v]));
                }
                this.execute(transaction, builder);
                this.execute(transaction, ((CypherRelationshipBuilder)((CypherRelationshipBuilder)CypherRelationshipBuilder.of().withMatch(TL_EXECUTION_DATA_SET, "s", Map.of("parentId", parentId, "ownerId", ownerId, "setKey", setMeta.getSetKey()))).withMatch(OL_EXECUTION_DATA_SET_ROW, "r", Map.of("parentId", parentId, "ownerId", ownerId, "setKey", setMeta.getSetKey(), OP_ROW_NR, rowNr))).withCreate("s", "r", R_HAS_ROW));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void saveDataSetMeta(Transaction transaction, String parentId, String ownerId, ExecutionDataSetMeta dataSetMeta) {
        this.execute(transaction, CypherMergeBuilder.of().withLabelAndKeys(ML_EXECUTION_DATA_SET_META, Map.of("parentId", parentId, "ownerId", ownerId, "setKey", dataSetMeta.getSetKey())).withValue("name", dataSetMeta.getName()).withValue("copyNr", dataSetMeta.getCopyNr()).withValue(MP_DESCRIPTION, dataSetMeta.getDescription()).withValue(MP_FIELD_NAME, dataSetMeta.getFieldName()).withValue(MP_LOG_CHANNEL_ID, dataSetMeta.getLogChannelId()).withValue(MP_SAMPLE_DESCRIPTION, dataSetMeta.getSampleDescription()));
    }

    public ExecutionData getExecutionData(String parentExecutionId, String executionId) throws HopException {
        NeoExecutionInfoLocation neoExecutionInfoLocation = this;
        synchronized (neoExecutionInfoLocation) {
            try {
                return (ExecutionData)this.session.readTransaction(transaction -> this.getNeo4jExecutionData(transaction, parentExecutionId, executionId));
            }
            catch (Exception e) {
                throw new HopException("Error getting execution from Neo4j", (Throwable)e);
            }
        }
    }

    private ExecutionData getNeo4jExecutionData(Transaction transaction, String parentExecutionId, String executionId) {
        ExecutionDataBuilder builder = ExecutionDataBuilder.of().withParentId(parentExecutionId).withOwnerId(executionId);
        HashMap<String, Object> keyValueMap = new HashMap<String, Object>();
        keyValueMap.put("parentId", parentExecutionId);
        if (StringUtils.isNotEmpty((String)executionId)) {
            keyValueMap.put("ownerId", executionId);
        }
        Result result = this.execute(transaction, CypherQueryBuilder.of().withLabelAndKeys("n", DL_EXECUTION_DATA, keyValueMap).withReturnValues("n", "executionType", "ownerId", DP_FINISHED, DP_COLLECTION_DATE));
        boolean foundData = false;
        boolean allFinished = true;
        while (result.hasNext()) {
            Record dataRecord = result.next();
            foundData = true;
            boolean finished = this.getBoolean(dataRecord, DP_FINISHED);
            if (!finished) {
                allFinished = false;
            }
            String ownerId = this.getString(dataRecord, "ownerId");
            builder.withExecutionType(ExecutionType.valueOf((String)this.getString(dataRecord, "executionType")));
            builder.withCollectionDate(this.getDate(dataRecord, DP_COLLECTION_DATE));
            ExecutionDataSetMeta setMeta = this.getNeo4jExecutionDataSetMeta(transaction, parentExecutionId, ownerId);
            if (setMeta != null) {
                if (StringUtils.isNotEmpty((String)executionId)) {
                    builder.withDataSetMeta(setMeta);
                } else {
                    builder.addSetMeta(setMeta.getSetKey(), setMeta);
                }
            }
            Result dataSetsResults = this.execute(transaction, CypherQueryBuilder.of().withLabelAndKeys("n", TL_EXECUTION_DATA_SET, Map.of("parentId", parentExecutionId, "ownerId", ownerId)).withReturnValues("n", "setKey", TP_ROW_META_JSON));
            while (dataSetsResults.hasNext()) {
                ExecutionDataSetMeta dataSetMeta;
                Record record = dataSetsResults.next();
                String setKey = this.getString(record, "setKey");
                String rowMetaJson = this.getString(record, TP_ROW_META_JSON);
                Object rowMeta = StringUtils.isEmpty((String)rowMetaJson) ? new RowMeta() : JsonRowMeta.fromJson((String)rowMetaJson);
                if (rowMeta.isEmpty() || (dataSetMeta = this.getNeo4jExecutionDataSetMeta(transaction, parentExecutionId, ownerId, setKey)) == null) continue;
                builder.addSetMeta(setKey, dataSetMeta);
                ArrayList<CallSite> fieldNames = new ArrayList<CallSite>();
                HashMap<CallSite, String> fieldMap = new HashMap<CallSite, String>();
                for (int v = 0; v < rowMeta.size(); ++v) {
                    String fieldName = "field" + v;
                    fieldNames.add((CallSite)((Object)fieldName));
                    fieldMap.put((CallSite)((Object)fieldName), rowMeta.getValueMeta(v).getName());
                }
                Result rowsResult = this.execute(transaction, CypherQueryBuilder.of().withLabelAndKeys("n", OL_EXECUTION_DATA_SET_ROW, Map.of("parentId", parentExecutionId, "ownerId", ownerId, "setKey", setKey)).withReturnValues("n", fieldNames.toArray(new String[0])).withOrderBy("n", OP_ROW_NR, true));
                RowBuffer rowBuffer = new RowBuffer(rowMeta);
                while (rowsResult.hasNext()) {
                    Record rowsRecord = rowsResult.next();
                    Object[] row = new Object[rowMeta.size()];
                    for (int v = 0; v < rowMeta.size(); ++v) {
                        IValueMeta valueMeta = rowMeta.getValueMeta(v);
                        Value value = rowsRecord.get("n.field" + v);
                        row[v] = this.extractHopValue(valueMeta, value);
                    }
                    rowBuffer.addRow(row);
                }
                builder.addDataSet(setKey, rowBuffer);
            }
        }
        builder.withFinished(allFinished);
        if (!foundData) {
            return null;
        }
        return builder.build();
    }

    private Object extractHopValue(IValueMeta valueMeta, Value value) {
        if (value == null) {
            return null;
        }
        if (value.isNull()) {
            return null;
        }
        switch (valueMeta.getType()) {
            case 2: {
                return value.asString();
            }
            case 5: {
                return value.asLong();
            }
            case 3: {
                LocalDateTime localDateTime = value.asLocalDateTime();
                return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
            }
            case 4: {
                return value.asBoolean();
            }
            case 1: {
                return value.asDouble();
            }
        }
        this.log.logError("Data type not yet supported : " + valueMeta.getTypeDesc() + " (non-fatal, returning null)");
        return null;
    }

    private ExecutionDataSetMeta getNeo4jExecutionDataSetMeta(Transaction transaction, String parentExecutionId, String ownerId) {
        Result result = this.execute(transaction, CypherQueryBuilder.of().withLabelAndKeys("d", DL_EXECUTION_DATA, Map.of("parentId", parentExecutionId, "ownerId", ownerId)).withMatch("n", ML_EXECUTION_DATA_SET_META, Map.of("parentId", parentExecutionId, "ownerId", ownerId, "setKey", ownerId)).withRelationship("d", "n", R_HAS_METADATA).withReturnValues("n", "setKey", "name", "copyNr", MP_DESCRIPTION, MP_FIELD_NAME, MP_LOG_CHANNEL_ID, MP_SAMPLE_DESCRIPTION));
        if (result.hasNext()) {
            return this.extractDataSetMeta(result.next());
        }
        return null;
    }

    private ExecutionDataSetMeta getNeo4jExecutionDataSetMeta(Transaction transaction, String parentExecutionId, String ownerId, String setKey) {
        Result result = this.execute(transaction, CypherQueryBuilder.of().withLabelAndKeys("n", ML_EXECUTION_DATA_SET_META, Map.of("parentId", parentExecutionId, "ownerId", ownerId, "setKey", setKey)).withReturnValues("n", "setKey", "name", "copyNr", MP_DESCRIPTION, MP_FIELD_NAME, MP_LOG_CHANNEL_ID, MP_SAMPLE_DESCRIPTION));
        if (result.hasNext()) {
            return this.extractDataSetMeta(result.next());
        }
        return null;
    }

    private ExecutionDataSetMeta extractDataSetMeta(Record record) {
        ExecutionDataSetMeta setMeta = new ExecutionDataSetMeta();
        setMeta.setSetKey(this.getString(record, "setKey"));
        setMeta.setName(this.getString(record, "name"));
        setMeta.setCopyNr(this.getString(record, "copyNr"));
        setMeta.setLogChannelId(this.getString(record, MP_LOG_CHANNEL_ID));
        setMeta.setDescription(this.getString(record, MP_DESCRIPTION));
        setMeta.setSampleDescription(this.getString(record, MP_SAMPLE_DESCRIPTION));
        setMeta.setFieldName(this.getString(record, MP_FIELD_NAME));
        return setMeta;
    }

    public Execution findLastExecution(ExecutionType executionType, String name) throws HopException {
        try {
            List<String> ids = this.getExecutionIds(true, 100);
            for (String id : ids) {
                Execution execution = this.getExecution(id);
                if (execution.getExecutionType() != executionType || !name.equals(execution.getName())) continue;
                return execution;
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException("Error looking up the last execution of type " + executionType + " and name " + name, (Throwable)e);
        }
    }

    public List<String> findChildIds(ExecutionType parentExecutionType, String parentExecutionId) throws HopException {
        try {
            ExecutionState state = this.getExecutionState(parentExecutionId);
            if (state != null) {
                return state.getChildIds();
            }
            return Collections.emptyList();
        }
        catch (Exception e) {
            throw new HopException("Error finding children of " + parentExecutionType.name() + " execution " + parentExecutionId, (Throwable)e);
        }
    }

    public String findParentId(String childId) throws HopException {
        try {
            for (String id : this.getExecutionIds(true, 100)) {
                ExecutionState executionState = this.getExecutionState(id);
                List childIds = executionState.getChildIds();
                if (childIds == null || !childIds.contains(childId)) continue;
                return id;
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException("Error finding parent execution for child ID " + childId, (Throwable)e);
        }
    }

    private Result execute(Transaction transaction, ICypherBuilder builder) {
        return transaction.run(builder.cypher(), builder.parameters());
    }

    private Date getDate(Record record, String key) {
        return this.getDate("n", record, key);
    }

    private Date getDate(String nodeAlias, Record record, String key) {
        Value value = record.get(nodeAlias + "." + key);
        if (value == null) {
            return null;
        }
        if (value.isNull()) {
            return null;
        }
        LocalDateTime localDateTime = value.asLocalDateTime();
        if (localDateTime == null) {
            return null;
        }
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    private String getString(Record record, String key) {
        return this.getString("n", record, key);
    }

    private String getString(String nodeAlias, Record record, String key) {
        Value value = record.get(nodeAlias + "." + key);
        if (value == null) {
            return null;
        }
        if (value.isNull()) {
            return null;
        }
        return value.asString();
    }

    private boolean getBoolean(Record record, String key) {
        return this.getBoolean("n", record, key);
    }

    private boolean getBoolean(String nodeAlias, Record record, String key) {
        Value value = record.get(nodeAlias + "." + key);
        if (value == null) {
            return false;
        }
        if (value.isNull()) {
            return false;
        }
        return value.asBoolean();
    }

    private Long getLong(Record record, String key) {
        return this.getLong("n", record, key);
    }

    private Long getLong(String nodeAlias, Record record, String key) {
        Value value = record.get(nodeAlias + "." + key);
        if (value == null) {
            return null;
        }
        if (value.isNull()) {
            return null;
        }
        return value.asLong();
    }

    private List<String> getList(Record record, String key) {
        return this.getList("n", record, key);
    }

    private List<String> getList(String nodeAlias, Record record, String key) {
        Value value = record.get(nodeAlias + "." + key);
        if (value == null) {
            return null;
        }
        if (value.isNull()) {
            return null;
        }
        List list = value.asList(Value::asString);
        return list;
    }

    private Map<String, String> getMap(Record record, String key) {
        return this.getMap("n", record, key);
    }

    private Map<String, String> getMap(String nodeAlias, Record record, String key) {
        Value value = record.get(nodeAlias + "." + key);
        if (value == null) {
            return null;
        }
        if (value.isNull()) {
            return null;
        }
        String jsonString = value.asString();
        ObjectMapper objectMapper = HopJson.newMapper();
        TypeReference<HashMap<String, String>> typeRef = new TypeReference<HashMap<String, String>>(){};
        try {
            return (Map)objectMapper.readValue(jsonString, (TypeReference)typeRef);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error reading converting JSON String to a Map: " + jsonString, e);
        }
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public Driver getDriver() {
        return this.driver;
    }

    public Session getSession() {
        return this.session;
    }
}

