/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.environment;

import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.fnexecution.control.InstructionRequestHandler;
import org.apache.beam.runners.fnexecution.environment.ProcessManager;
import org.apache.beam.runners.fnexecution.environment.RemoteEnvironment;

public class ProcessEnvironment
implements RemoteEnvironment {
    private final ProcessManager processManager;
    private final RunnerApi.Environment environment;
    private final String workerId;
    private final InstructionRequestHandler instructionHandler;
    private boolean isClosed;

    public static RemoteEnvironment create(ProcessManager processManager, RunnerApi.Environment environment, String workerId, InstructionRequestHandler instructionHandler) {
        return new ProcessEnvironment(processManager, environment, workerId, instructionHandler);
    }

    private ProcessEnvironment(ProcessManager processManager, RunnerApi.Environment environment, String workerId, InstructionRequestHandler instructionHandler) {
        this.processManager = processManager;
        this.environment = environment;
        this.workerId = workerId;
        this.instructionHandler = instructionHandler;
    }

    @Override
    public RunnerApi.Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public InstructionRequestHandler getInstructionRequestHandler() {
        return this.instructionHandler;
    }

    @Override
    public synchronized void close() throws Exception {
        if (this.isClosed) {
            return;
        }
        Exception exception = null;
        try {
            this.processManager.stopProcess(this.workerId);
        }
        catch (Exception e) {
            exception = e;
        }
        try {
            this.instructionHandler.close();
        }
        catch (Exception e) {
            if (exception != null) {
                exception.addSuppressed(e);
            }
            exception = e;
        }
        this.isClosed = true;
        if (exception != null) {
            throw exception;
        }
    }
}

