/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.WindowingStrategy;

public class CreateDataflowView<ElemT, ViewT>
extends PTransform<PCollection<ElemT>, PCollection<ElemT>> {
    private final PCollectionView<ViewT> view;
    private final boolean streaming;

    public static <ElemT, ViewT> CreateDataflowView<ElemT, ViewT> forBatch(PCollectionView<ViewT> view) {
        return new CreateDataflowView<ElemT, ViewT>(view, false);
    }

    public static <ElemT, ViewT> CreateDataflowView<ElemT, ViewT> forStreaming(PCollectionView<ViewT> view) {
        return new CreateDataflowView<ElemT, ViewT>(view, true);
    }

    private CreateDataflowView(PCollectionView<ViewT> view, boolean streaming) {
        this.view = view;
        this.streaming = streaming;
    }

    public PCollection<ElemT> expand(PCollection<ElemT> input) {
        if (this.streaming) {
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)input.getWindowingStrategy(), (PCollection.IsBounded)input.isBounded(), (Coder)input.getCoder());
        }
        return this.view.getPCollection();
    }

    public PCollectionView<ViewT> getView() {
        return this.view;
    }
}

