/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.shared;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.hop.core.gui.AreaOwner;
import org.apache.hop.core.gui.DPoint;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.execution.Execution;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.execution.DragViewZoomBase;
import org.apache.hop.ui.hopgui.perspective.execution.ExecutionPerspective;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;

public abstract class BaseExecutionViewer
extends DragViewZoomBase
implements MouseListener,
MouseMoveListener {
    public static final String STRING_STATE_STALE = "Stale";
    protected final HopGui hopGui;
    protected final ExecutionPerspective perspective;
    protected final PropsUi props;
    protected final int iconSize;
    protected final List<AreaOwner> areaOwners;
    protected final String locationName;
    protected final Execution execution;
    protected ExecutionState executionState;
    protected ToolBar toolBar;
    protected GuiToolbarWidgets toolBarWidgets;
    protected SashForm sash;
    protected CTabFolder tabFolder;
    protected Point lastClick;

    public BaseExecutionViewer(Composite parent, HopGui hopGui, ExecutionPerspective perspective, String locationName, Execution execution, ExecutionState executionState) {
        super(parent, 262144);
        this.perspective = perspective;
        this.locationName = locationName;
        this.execution = execution;
        this.executionState = executionState;
        this.hopGui = hopGui;
        this.props = PropsUi.getInstance();
        this.iconSize = hopGui.getProps().getIconSize();
        this.areaOwners = new ArrayList<AreaOwner>();
        this.offset = new DPoint(0.0, 0.0);
    }

    protected Display hopDisplay() {
        return this.hopGui.getDisplay();
    }

    public boolean setFocus() {
        if (this.canvas.isDisposed()) {
            return false;
        }
        return this.canvas.setFocus();
    }

    @Override
    public void redraw() {
        this.canvas.redraw();
        this.canvas.setFocus();
    }

    @Override
    protected float calculateCorrectedMagnification() {
        return (float)((double)this.magnification * PropsUi.getInstance().getZoomFactor());
    }

    public synchronized AreaOwner getVisibleAreaOwner(int x, int y) {
        for (int i = this.areaOwners.size() - 1; i >= 0; --i) {
            AreaOwner areaOwner = this.areaOwners.get(i);
            if (!areaOwner.contains(x, y)) continue;
            return areaOwner;
        }
        return null;
    }

    protected String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(date);
    }

    public abstract void drillDownOnLocation(Point var1);

    public void mouseDoubleClick(MouseEvent mouseEvent) {
        this.drillDownOnLocation(this.screen2real(mouseEvent.x, mouseEvent.y));
    }

    public void mouseMove(MouseEvent e) {
        if (this.viewPortNavigation) {
            this.dragViewPort(new Point(e.x, e.y));
        }
        if (this.viewDrag && this.lastClick != null) {
            this.dragView(this.viewDragStart, new Point(e.x, e.y));
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this.viewPortNavigation || this.viewDrag) {
            this.viewDrag = false;
            this.viewPortNavigation = false;
            this.viewPortStart = null;
        }
    }

    public void mouseHover(MouseEvent e) {
    }

    public GuiToolbarWidgets getToolBarWidgets() {
        return this.toolBarWidgets;
    }

    protected void viewMetadata(Execution execution) {
        try {
            String metadataJson = execution.getMetadataJson();
            SerializableMetadataProvider metadataProvider = new SerializableMetadataProvider(metadataJson);
            IVariables variables = Variables.getADefaultVariableSpace();
            variables.setVariables(execution.getVariableValues());
            variables.setVariables(execution.getParameterValues());
            List metadataClasses = metadataProvider.getMetadataClasses();
            HashMap<String, IHopMetadataSerializer> serializerMap = new HashMap<String, IHopMetadataSerializer>();
            for (Class metadataClass : metadataClasses) {
                IHopMetadataSerializer serializer = metadataProvider.getSerializer(metadataClass);
                String description = serializer.getDescription();
                serializerMap.put(description, serializer);
            }
            ArrayList metadataTypes = new ArrayList(serializerMap.keySet());
            Collections.sort(metadataTypes);
            EnterSelectionDialog selectTypeDialog = new EnterSelectionDialog(this.hopGui.getShell(), metadataTypes.toArray(new String[0]), "View metadata", "Select the type of metadata to view");
            String description = selectTypeDialog.open();
            if (description == null) {
                return;
            }
            IHopMetadataSerializer serializer = (IHopMetadataSerializer)serializerMap.get(description);
            List objectNames = serializer.listObjectNames();
            EnterSelectionDialog selectElementDialog = new EnterSelectionDialog(this.hopGui.getShell(), objectNames.toArray(new String[0]), "Select element", "Select the metadata element of type " + description);
            String name = selectElementDialog.open();
            if (name == null) {
                return;
            }
            MetadataManager manager = new MetadataManager(variables, (IHopMetadataProvider)metadataProvider, serializer.getManagedClass(), this.hopGui.getShell());
            manager.editMetadata(name);
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), "Error", "Error viewing the metadata", e);
        }
    }

    public abstract String getActiveId();

    public ExecutionPerspective getPerspective() {
        return this.perspective;
    }

    public List<AreaOwner> getAreaOwners() {
        return this.areaOwners;
    }

    public String getLocationName() {
        return this.locationName;
    }

    public Execution getExecution() {
        return this.execution;
    }

    public ToolBar getToolBar() {
        return this.toolBar;
    }

    public void setToolBar(ToolBar toolBar) {
        this.toolBar = toolBar;
    }

    public void setToolBarWidgets(GuiToolbarWidgets toolBarWidgets) {
        this.toolBarWidgets = toolBarWidgets;
    }

    public SashForm getSash() {
        return this.sash;
    }

    public void setSash(SashForm sash) {
        this.sash = sash;
    }

    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    public void setTabFolder(CTabFolder tabFolder) {
        this.tabFolder = tabFolder;
    }

    public Point getLastClick() {
        return this.lastClick;
    }

    public void setLastClick(Point lastClick) {
        this.lastClick = lastClick;
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    public void setExecutionState(ExecutionState executionState) {
        this.executionState = executionState;
    }
}

