/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.dialog;

import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.metadata.util.HopMetadataUtil;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.bus.HopGuiEvents;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.TreeMemory;
import org.apache.hop.ui.core.widget.TreeUtil;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin
public class MetadataExplorerDialog {
    private static final Class<?> PKG = MetadataExplorerDialog.class;
    private static final String METADATA_EXPLORER_DIALOG_TREE = "Metadata explorer dialog tree";
    public static final String GUI_PLUGIN_TOOLBAR_PARENT_ID = "MetadataExplorerDialog-Toolbar";
    public static final String TOOLBAR_ITEM_NEW = "MetadataExplorerDialog-Toolbar-10000-New";
    public static final String TOOLBAR_ITEM_EDIT = "MetadataExplorerDialog-Toolbar-10010-Edit";
    public static final String TOOLBAR_ITEM_DUPLICATE = "MetadataExplorerDialog-Toolbar-10030-Duplicate";
    public static final String TOOLBAR_ITEM_DELETE = "MetadataExplorerDialog-Toolbar-10040-Delete";
    public static final String TOOLBAR_ITEM_REFRESH = "MetadataExplorerDialog-Toolbar-10100-Refresh";
    private static ILogChannel log = LogChannel.GENERAL;
    private Shell parent;
    private Shell shell;
    private GuiToolbarWidgets toolBarWidgets;
    private Tree tree;
    private PropsUi props;
    private static MetadataExplorerDialog activeInstance;
    private String activeObjectKey = null;
    private String activeObjectName = null;

    public MetadataExplorerDialog(Shell parent) {
        this.parent = parent;
        this.props = PropsUi.getInstance();
    }

    public void open() {
        Display display = this.parent.getDisplay();
        this.shell = new Shell(this.parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageHopUi());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MetadataExplorerDialog.Dialog.Title", (String[])new String[0]));
        MetadataExplorerDialog metadataExplorerDialog = this;
        int margin = metadataExplorerDialog.props.getMargin();
        ToolBar toolBar = new ToolBar((Composite)this.shell, 16704);
        this.toolBarWidgets = new GuiToolbarWidgets();
        this.toolBarWidgets.registerGuiPluginObject(this);
        this.toolBarWidgets.createToolbarWidgets((Composite)toolBar, GUI_PLUGIN_TOOLBAR_PARENT_ID);
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 0);
        layoutData.top = new FormAttachment(0, 0);
        layoutData.right = new FormAttachment(100, 0);
        toolBar.setLayoutData((Object)layoutData);
        toolBar.pack();
        Button closeButton = new Button((Composite)this.shell, 8);
        closeButton.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, new Button[]{closeButton}, margin, null);
        closeButton.addListener(13, e -> this.close());
        this.tree = new Tree((Composite)this.shell, 2820);
        PropsUi.setLook((Widget)this.tree);
        this.tree.setHeaderVisible(true);
        FormData treeFormData = new FormData();
        treeFormData.left = new FormAttachment(0, 0);
        treeFormData.top = new FormAttachment((Control)toolBar, 0);
        treeFormData.right = new FormAttachment(100, 0);
        treeFormData.bottom = new FormAttachment((Control)closeButton, -margin * 2);
        this.tree.setLayoutData((Object)treeFormData);
        TreeColumn keyColumn = new TreeColumn(this.tree, 16384);
        keyColumn.setText("Object type key (folder)");
        keyColumn.setWidth(400);
        TreeColumn valueColumn = new TreeColumn(this.tree, 16384);
        valueColumn.setText("Description or value");
        valueColumn.setWidth(500);
        this.tree.addListener(13, e -> this.getSelectedState());
        this.tree.addListener(14, e -> this.doubleClickAction());
        this.tree.addListener(35, e -> this.showMenu());
        HopGui.getInstance().getEventsHandler().addEventListener(this.getClass().getName(), e -> this.refreshTree(), HopGuiEvents.MetadataChanged.name());
        TreeMemory.addTreeListener(this.tree, METADATA_EXPLORER_DIALOG_TREE);
        try {
            this.refreshTree();
            for (TreeItem item : this.tree.getItems()) {
                TreeMemory.getInstance().storeExpanded(METADATA_EXPLORER_DIALOG_TREE, item, true);
            }
            TreeMemory.setExpandedFromMemory(this.tree, METADATA_EXPLORER_DIALOG_TREE);
        }
        catch (Exception e2) {
            new ErrorDialog(this.shell, "Error", "Unexpected error displaying metadata information", e2);
        }
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                MetadataExplorerDialog.this.close();
            }
        });
        BaseTransformDialog.setSize(this.shell);
        this.getSelectedState();
        this.tree.setFocus();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void showMenu() {
        try {
            this.getSelectedState();
            if (this.activeObjectKey == null) {
                return;
            }
            Menu menu = new Menu((Control)this.tree);
            MenuItem newItem = new MenuItem(menu, 8);
            newItem.setText("New");
            newItem.addListener(13, e -> this.newMetadata());
            if (StringUtils.isNotEmpty((String)this.activeObjectName)) {
                MenuItem editItem = new MenuItem(menu, 8);
                editItem.setText("Edit");
                editItem.addListener(13, e -> this.editMetadata());
                MenuItem duplicateItem = new MenuItem(menu, 8);
                duplicateItem.setText("Duplicate");
                duplicateItem.addListener(13, e -> this.duplicateMetadata());
                new MenuItem(menu, 2);
                MenuItem deleteItem = new MenuItem(menu, 8);
                deleteItem.setText("Delete");
                deleteItem.addListener(13, e -> this.deleteMetadata());
            }
            this.tree.setMenu(menu);
            menu.setVisible(true);
        }
        catch (Exception e2) {
            new ErrorDialog(this.shell, "Error", "Error handling metadata object", e2);
        }
    }

    private void doubleClickAction() {
        this.getSelectedState();
        if (StringUtils.isEmpty((String)this.activeObjectKey)) {
            return;
        }
        try {
            if (StringUtils.isEmpty((String)this.activeObjectName)) {
                this.newMetadata();
            } else {
                this.editMetadata();
            }
        }
        catch (Exception ex) {
            new ErrorDialog(this.shell, "Error", "Error handling double-click selection event", ex);
        }
    }

    private void getSelectedState() {
        TreeItem selectedItem;
        this.activeObjectKey = null;
        this.activeObjectName = null;
        if (this.tree.getSelectionCount() > 0 && (selectedItem = this.tree.getSelection()[0]) != null) {
            if (selectedItem.getParentItem() == null) {
                this.activeObjectKey = selectedItem.getText();
                this.activeObjectName = null;
            } else {
                this.activeObjectKey = selectedItem.getParentItem().getText();
                this.activeObjectName = selectedItem.getText(1);
            }
        }
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_NEW, StringUtils.isNotEmpty((String)this.activeObjectKey));
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_EDIT, StringUtils.isNotEmpty((String)this.activeObjectName));
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_DUPLICATE, StringUtils.isNotEmpty((String)this.activeObjectName));
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_DELETE, StringUtils.isNotEmpty((String)this.activeObjectName));
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_REFRESH, true);
    }

    private MetadataManager<IHopMetadata> getActiveMetadataManger() {
        try {
            MultiMetadataProvider metadataProvider = HopGui.getInstance().getMetadataProvider();
            Class metadataClass = metadataProvider.getMetadataClassForKey(this.activeObjectKey);
            return new MetadataManager<IHopMetadata>(HopGui.getInstance().getVariables(), (IHopMetadataProvider)metadataProvider, metadataClass, this.shell);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Unexpected error getting the metadata class for key '" + this.activeObjectKey + "'", e);
            return null;
        }
    }

    @GuiToolbarElement(root="MetadataExplorerDialog-Toolbar", id="MetadataExplorerDialog-Toolbar-10000-New", toolTip="New", image="ui/images/new.svg")
    public void newMetadata() {
        MetadataManager<IHopMetadata> manager = this.getActiveMetadataManger();
        if (manager != null && manager.newMetadata() != null) {
            this.refreshTree();
        }
    }

    @GuiToolbarElement(root="MetadataExplorerDialog-Toolbar", id="MetadataExplorerDialog-Toolbar-10010-Edit", toolTip="Edit", image="ui/images/edit.svg")
    public void editMetadata() {
        MetadataManager<IHopMetadata> manager = this.getActiveMetadataManger();
        if (manager != null && manager.editMetadata(this.activeObjectName)) {
            this.refreshTree();
        }
    }

    @GuiToolbarElement(root="MetadataExplorerDialog-Toolbar", id="MetadataExplorerDialog-Toolbar-10040-Delete", toolTip="Delete", image="ui/images/delete.svg")
    public void deleteMetadata() {
        MetadataManager<IHopMetadata> manager = this.getActiveMetadataManger();
        if (manager != null && manager.deleteMetadata(this.activeObjectName)) {
            this.refreshTree();
        }
    }

    @GuiToolbarElement(root="MetadataExplorerDialog-Toolbar", id="MetadataExplorerDialog-Toolbar-10030-Duplicate", toolTip="Create a copy", image="ui/images/copy.svg")
    public void duplicateMetadata() {
        MetadataManager<IHopMetadata> manager = this.getActiveMetadataManger();
        if (manager != null && this.activeObjectName != null) {
            try {
                String newName;
                IHopMetadata metadata = manager.loadElement(this.activeObjectName);
                int copyNr = 2;
                while (true) {
                    newName = this.activeObjectName + " " + copyNr;
                    if (!manager.getSerializer().exists(newName)) break;
                    ++copyNr;
                }
                metadata.setName(newName);
                manager.getSerializer().save(metadata);
                this.refreshTree();
                manager.editMetadata(newName);
                this.refreshTree();
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, "Error", "Error duplicating metadata", e);
            }
        }
    }

    public static MetadataExplorerDialog getInstance() {
        return activeInstance;
    }

    private void close() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
        HopGui.getInstance().getEventsHandler().removeEventListeners(this.getClass().getName());
    }

    @GuiToolbarElement(root="MetadataExplorerDialog-Toolbar", id="MetadataExplorerDialog-Toolbar-10100-Refresh", toolTip="Refresh", image="ui/images/refresh.svg")
    public void refreshTree() {
        try {
            this.tree.removeAll();
            MultiMetadataProvider metadataProvider = HopGui.getInstance().getMetadataProvider();
            List metadataClasses = metadataProvider.getMetadataClasses();
            for (Class metadataClass : metadataClasses) {
                HopMetadata hopMetadata = HopMetadataUtil.getHopMetadataAnnotation((Class)metadataClass);
                Image image = SwtSvgImageUtil.getImage(this.shell.getDisplay(), metadataClass.getClassLoader(), hopMetadata.image(), 32, 32);
                TreeItem elementTypeItem = new TreeItem(this.tree, 0);
                elementTypeItem.setImage(image);
                elementTypeItem.setText(0, Const.NVL((String)hopMetadata.key(), (String)""));
                elementTypeItem.setText(1, Const.NVL((String)hopMetadata.name(), (String)""));
                IHopMetadataSerializer serializer = metadataProvider.getSerializer(metadataClass);
                List names = serializer.listObjectNames();
                Collections.sort(names);
                for (String name : names) {
                    TreeItem elementItem = new TreeItem(elementTypeItem, 0);
                    elementItem.setText(1, Const.NVL((String)name, (String)""));
                    elementItem.addListener(13, event -> log.logBasic("Selected : " + name));
                    elementItem.setFont(GuiResource.getInstance().getFontBold());
                }
            }
            TreeUtil.setOptimalWidthOnColumns(this.tree);
            TreeMemory.setExpandedFromMemory(this.tree, METADATA_EXPLORER_DIALOG_TREE);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error refreshing metadata tree", e);
        }
    }
}

