/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.widget;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ControlSpaceKeyAdapter;
import org.apache.hop.ui.core.widget.IGetCaretPosition;
import org.apache.hop.ui.core.widget.IInsertText;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class ComboVar
extends Composite {
    private static final Class<?> PKG = ComboVar.class;
    private String toolTipText;
    private IGetCaretPosition getCaretPositionInterface;
    private IInsertText insertTextInterface;
    private ControlSpaceKeyAdapter controlSpaceKeyAdapter;
    private IVariables variables;
    private CCombo wCombo;
    private ModifyListener modifyListenerTooltipText;

    public ComboVar(IVariables variables, Composite composite, int flags) {
        this(variables, composite, flags, null, null, null);
    }

    public ComboVar(IVariables variables, Composite composite, int flags, String toolTipText) {
        this(variables, composite, flags, toolTipText, null, null);
    }

    public ComboVar(IVariables variables, Composite composite, int flags, IGetCaretPosition getCaretPositionInterface, IInsertText insertTextInterface) {
        this(variables, composite, flags, null, getCaretPositionInterface, insertTextInterface);
    }

    public ComboVar(IVariables variables, Composite composite, int flags, String toolTipText, IGetCaretPosition getCaretPositionInterface, IInsertText insertTextInterface) {
        super(composite, 0);
        this.toolTipText = toolTipText;
        this.getCaretPositionInterface = getCaretPositionInterface;
        this.insertTextInterface = insertTextInterface;
        this.variables = variables;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 0;
        formLayout.marginHeight = 0;
        formLayout.marginTop = 0;
        formLayout.marginBottom = 0;
        this.setLayout((Layout)formLayout);
        Label wlImage = new Label((Composite)this, 0);
        wlImage.setImage(GuiResource.getInstance().getImageVariable());
        wlImage.setToolTipText(BaseMessages.getString(PKG, (String)"TextVar.tooltip.InsertVariable", (String[])new String[0]));
        FormData fdlImage = new FormData();
        fdlImage.top = new FormAttachment(0, 0);
        fdlImage.right = new FormAttachment(100, 0);
        wlImage.setLayoutData((Object)fdlImage);
        this.wCombo = new CCombo((Composite)this, flags);
        PropsUi.setLook((Widget)this.wCombo);
        this.modifyListenerTooltipText = this.getModifyListenerTooltipText(this.wCombo);
        this.wCombo.addModifyListener(this.modifyListenerTooltipText);
        FormData fdCombo = new FormData();
        fdCombo.top = new FormAttachment(0, 0);
        fdCombo.left = new FormAttachment(0, 0);
        fdCombo.right = new FormAttachment((Control)wlImage, 0);
        this.wCombo.setLayoutData((Object)fdCombo);
        this.controlSpaceKeyAdapter = new ControlSpaceKeyAdapter(variables, (Control)this.wCombo, getCaretPositionInterface, insertTextInterface);
        this.wCombo.addKeyListener((KeyListener)this.controlSpaceKeyAdapter);
    }

    public IGetCaretPosition getGetCaretPositionInterface() {
        return this.getCaretPositionInterface;
    }

    public void setGetCaretPositionInterface(IGetCaretPosition getCaretPositionInterface) {
        this.getCaretPositionInterface = getCaretPositionInterface;
    }

    public IInsertText getInsertTextInterface() {
        return this.insertTextInterface;
    }

    public void setInsertTextInterface(IInsertText insertTextInterface) {
        this.insertTextInterface = insertTextInterface;
    }

    private ModifyListener getModifyListenerTooltipText(CCombo comboField) {
        return e -> {
            Object tip = comboField.getText();
            if (!Utils.isEmpty((CharSequence)tip) && !Utils.isEmpty((CharSequence)this.toolTipText)) {
                tip = (String)tip + Const.CR + Const.CR + this.toolTipText;
            }
            if (Utils.isEmpty((CharSequence)tip)) {
                tip = this.toolTipText;
            }
            comboField.setToolTipText(this.variables.resolve((String)tip));
        };
    }

    public String getText() {
        return this.wCombo.getText();
    }

    public void setText(String text) {
        this.wCombo.setText(text);
        this.modifyListenerTooltipText.modifyText(null);
    }

    public CCombo getCComboWidget() {
        return this.wCombo;
    }

    public void addListener(int eventType, Listener listener) {
        this.wCombo.addListener(eventType, listener);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.wCombo.addModifyListener(modifyListener);
    }

    public void addSelectionListener(SelectionListener lsDef) {
        this.wCombo.addSelectionListener(lsDef);
    }

    public void addKeyListener(KeyListener lsKey) {
        this.wCombo.addKeyListener(lsKey);
    }

    public void addFocusListener(FocusListener lsFocus) {
        this.wCombo.addFocusListener(lsFocus);
    }

    public void setEnabled(boolean flag) {
        this.wCombo.setEnabled(flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean setFocus() {
        if (this.wCombo != null && !this.wCombo.isDisposed()) {
            CCombo cCombo = this.wCombo;
            synchronized (cCombo) {
                if (!(this.wCombo.isEnabled() && this.wCombo.getVisible() && this.wCombo.isVisible() && this.wCombo.isFocusControl())) {
                    return false;
                }
                return this.wCombo.setFocus();
            }
        }
        return false;
    }

    public void dispose() {
        if (this.wCombo != null && this.wCombo != null) {
            this.wCombo.dispose();
        }
    }

    public void addTraverseListener(TraverseListener tl) {
        this.wCombo.addTraverseListener(tl);
    }

    public void setToolTipText(String toolTipText) {
        this.toolTipText = toolTipText;
        this.wCombo.setToolTipText(toolTipText);
        this.modifyListenerTooltipText.modifyText(null);
    }

    public void setEditable(boolean editable) {
        this.wCombo.setEditable(editable);
    }

    public void setVariables(IVariables vars) {
        this.variables = vars;
        this.controlSpaceKeyAdapter.setVariables(this.variables);
        this.modifyListenerTooltipText.modifyText(null);
    }

    public void setItems(String[] items) {
        this.wCombo.setItems(items);
    }

    public String[] getItems() {
        return this.wCombo.getItems();
    }

    public void add(String item) {
        this.wCombo.add(item);
    }

    public int getItemCount() {
        return this.wCombo.getItemCount();
    }

    public int getSelectionIndex() {
        return this.wCombo.getSelectionIndex();
    }

    public void removeAll() {
        this.wCombo.removeAll();
    }

    public void remove(int index) {
        this.wCombo.remove(index);
    }

    public void select(int index) {
        this.wCombo.select(index);
        this.modifyListenerTooltipText.modifyText(null);
    }
}

