/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.async;

import com.sforce.async.AsyncApiException;
import com.sforce.async.AsyncExceptionCode;
import com.sforce.async.BulkConnection;
import com.sforce.async.ContentType;
import com.sforce.ws.transport.Transport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TransformationSpecRequest {
    private static final String SALESFORCE_FIELD = "Salesforce Field";
    private static final String CSV_HEADER = "Csv Header";
    private static final String VALUE = "Value";
    private static final String HINT = "Hint";
    private final OutputStream csvStream;
    private final Transport transport;
    private final String UTF8 = "UTF-8";

    public TransformationSpecRequest(Transport transport, OutputStream out) throws IOException, AsyncApiException {
        this.transport = transport;
        this.csvStream = out;
        this.addRow(new String[]{SALESFORCE_FIELD, CSV_HEADER, VALUE, HINT});
    }

    public void addSpecRow(String sfdcField, String csvHeader, String value, String hint) throws AsyncApiException {
        this.addRow(new String[]{sfdcField, csvHeader, value, hint});
    }

    public void completeRequest() throws AsyncApiException {
        try {
            this.csvStream.close();
            InputStream result = this.transport.getContent();
            if (!this.transport.isSuccessful()) {
                BulkConnection.parseAndThrowException(result, ContentType.CSV);
            }
        }
        catch (IOException e) {
            throw new AsyncApiException("Failed to complete request", AsyncExceptionCode.ClientInputError, e);
        }
    }

    private void addRow(String[] columns) throws AsyncApiException {
        try {
            for (int i = 0; i < columns.length; ++i) {
                if (i == 0) {
                    this.addFirstColumn(columns[i]);
                    continue;
                }
                this.addColumn(columns[i]);
            }
            this.nextLine();
        }
        catch (IOException e) {
            throw new AsyncApiException("Failed to add row", AsyncExceptionCode.ClientInputError, e);
        }
    }

    private void nextLine() throws IOException {
        this.csvStream.write("\n".getBytes("UTF-8"));
    }

    private void addColumn(String value) throws IOException {
        this.csvStream.write(",".getBytes("UTF-8"));
        this.addFirstColumn(value);
    }

    private void addFirstColumn(String value) throws IOException {
        if (value != null && !value.trim().isEmpty()) {
            this.csvStream.write("\"".getBytes("UTF-8"));
            this.csvStream.write(value.replace("\"", "\"\"").getBytes("UTF-8"));
            this.csvStream.write("\"".getBytes("UTF-8"));
        }
    }
}

