/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.ftpput;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.actions.util.FtpClientUtil;
import org.apache.hop.workflow.actions.util.IFtpConnection;
import org.w3c.dom.Node;

@Action(id="FTP_PUT", name="i18n::ActionFTPPut.Name", description="i18n::ActionFTPPut.Description", image="FTPPut.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileTransfer", keywords={"i18n::ActionFtpPut.keyword"}, documentationUrl="/workflow/actions/ftpput.html")
public class ActionFtpPut
extends ActionBase
implements Cloneable,
IAction,
IFtpConnection {
    private static final Class<?> PKG = ActionFtpPut.class;
    public static final int FTP_DEFAULT_PORT = 21;
    private String serverName = null;
    private String serverPort = "21";
    private String userName;
    private String password;
    private String remoteDirectory = null;
    private String localDirectory = null;
    private String wildcard;
    private boolean binaryMode;
    private int timeout;
    private boolean remove;
    private boolean onlyPuttingNewFiles;
    private boolean activeConnection;
    private String controlEncoding;
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private String socksProxyHost;
    private String socksProxyPort = "1080";
    private String socksProxyUsername;
    private String socksProxyPassword;
    private static final String LEGACY_CONTROL_ENCODING = "US-ASCII";
    private static final String DEFAULT_CONTROL_ENCODING = "ISO-8859-1";

    public ActionFtpPut(String n) {
        super(n, "");
        this.setControlEncoding(DEFAULT_CONTROL_ENCODING);
    }

    public ActionFtpPut() {
        this("");
    }

    public Object clone() {
        ActionFtpPut je = (ActionFtpPut)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder(450);
        xml.append(super.getXml());
        xml.append("      ").append(XmlHandler.addTagValue((String)"servername", (String)this.serverName));
        xml.append("      ").append(XmlHandler.addTagValue((String)"serverport", (String)this.serverPort));
        xml.append("      ").append(XmlHandler.addTagValue((String)"username", (String)this.userName));
        xml.append("      ").append(XmlHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword())));
        xml.append("      ").append(XmlHandler.addTagValue((String)"remoteDirectory", (String)this.remoteDirectory));
        xml.append("      ").append(XmlHandler.addTagValue((String)"localDirectory", (String)this.localDirectory));
        xml.append("      ").append(XmlHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        xml.append("      ").append(XmlHandler.addTagValue((String)"binary", (boolean)this.binaryMode));
        xml.append("      ").append(XmlHandler.addTagValue((String)"timeout", (int)this.timeout));
        xml.append("      ").append(XmlHandler.addTagValue((String)"remove", (boolean)this.remove));
        xml.append("      ").append(XmlHandler.addTagValue((String)"only_new", (boolean)this.onlyPuttingNewFiles));
        xml.append("      ").append(XmlHandler.addTagValue((String)"active", (boolean)this.activeConnection));
        xml.append("      ").append(XmlHandler.addTagValue((String)"control_encoding", (String)this.controlEncoding));
        xml.append("      ").append(XmlHandler.addTagValue((String)"proxy_host", (String)this.proxyHost));
        xml.append("      ").append(XmlHandler.addTagValue((String)"proxy_port", (String)this.proxyPort));
        xml.append("      ").append(XmlHandler.addTagValue((String)"proxy_username", (String)this.proxyUsername));
        xml.append("      ").append(XmlHandler.addTagValue((String)"proxy_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword)));
        xml.append("      ").append(XmlHandler.addTagValue((String)"socksproxy_host", (String)this.socksProxyHost));
        xml.append("      ").append(XmlHandler.addTagValue((String)"socksproxy_port", (String)this.socksProxyPort));
        xml.append("      ").append(XmlHandler.addTagValue((String)"socksproxy_username", (String)this.socksProxyUsername));
        xml.append("      ").append(XmlHandler.addTagValue((String)"socksproxy_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.socksProxyPassword)));
        return xml.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.serverName = XmlHandler.getTagValue((Node)entrynode, (String)"servername");
            this.serverPort = XmlHandler.getTagValue((Node)entrynode, (String)"serverport");
            this.userName = XmlHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)entrynode, (String)"password"));
            this.remoteDirectory = XmlHandler.getTagValue((Node)entrynode, (String)"remoteDirectory");
            this.localDirectory = XmlHandler.getTagValue((Node)entrynode, (String)"localDirectory");
            this.wildcard = XmlHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.binaryMode = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"binary"));
            this.timeout = Const.toInt((String)XmlHandler.getTagValue((Node)entrynode, (String)"timeout"), (int)10000);
            this.remove = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"remove"));
            this.onlyPuttingNewFiles = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"only_new"));
            this.activeConnection = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"active"));
            this.controlEncoding = XmlHandler.getTagValue((Node)entrynode, (String)"control_encoding");
            this.proxyHost = XmlHandler.getTagValue((Node)entrynode, (String)"proxy_host");
            this.proxyPort = XmlHandler.getTagValue((Node)entrynode, (String)"proxy_port");
            this.proxyUsername = XmlHandler.getTagValue((Node)entrynode, (String)"proxy_username");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)entrynode, (String)"proxy_password"));
            this.socksProxyHost = XmlHandler.getTagValue((Node)entrynode, (String)"socksproxy_host");
            this.socksProxyPort = XmlHandler.getTagValue((Node)entrynode, (String)"socksproxy_port");
            this.socksProxyUsername = XmlHandler.getTagValue((Node)entrynode, (String)"socksproxy_username");
            this.socksProxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XmlHandler.getTagValue((Node)entrynode, (String)"socksproxy_password"));
            if (this.controlEncoding == null) {
                this.controlEncoding = LEGACY_CONTROL_ENCODING;
            }
        }
        catch (HopXmlException xe) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionFtpPut.Log.UnableToLoadFromXml", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public boolean isBinaryMode() {
        return this.binaryMode;
    }

    public void setBinaryMode(boolean binaryMode) {
        this.binaryMode = binaryMode;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    @Override
    public int getTimeout() {
        return this.timeout;
    }

    public boolean isOnlyPuttingNewFiles() {
        return this.onlyPuttingNewFiles;
    }

    public void setOnlyPuttingNewFiles(boolean onlyPuttingNewFiles) {
        this.onlyPuttingNewFiles = onlyPuttingNewFiles;
    }

    @Override
    public String getControlEncoding() {
        return this.controlEncoding;
    }

    public void setControlEncoding(String encoding) {
        this.controlEncoding = encoding;
    }

    public String getRemoteDirectory() {
        return this.remoteDirectory;
    }

    public void setRemoteDirectory(String directory) {
        this.remoteDirectory = directory;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public String getLocalDirectory() {
        return this.localDirectory;
    }

    public void setLocalDirectory(String directory) {
        this.localDirectory = directory;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public boolean getRemove() {
        return this.remove;
    }

    @Override
    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    @Override
    public boolean isActiveConnection() {
        return this.activeConnection;
    }

    public void setActiveConnection(boolean activeConnection) {
        this.activeConnection = activeConnection;
    }

    @Override
    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    @Override
    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    @Override
    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Override
    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setSocksProxyHost(String socksProxyHost) {
        this.socksProxyHost = socksProxyHost;
    }

    public void setSocksProxyPort(String socksProxyPort) {
        this.socksProxyPort = socksProxyPort;
    }

    public void setSocksProxyUsername(String socksProxyUsername) {
        this.socksProxyUsername = socksProxyUsername;
    }

    public void setSocksProxyPassword(String socksProxyPassword) {
        this.socksProxyPassword = socksProxyPassword;
    }

    @Override
    public String getSocksProxyHost() {
        return this.socksProxyHost;
    }

    @Override
    public String getSocksProxyPort() {
        return this.socksProxyPort;
    }

    @Override
    public String getSocksProxyUsername() {
        return this.socksProxyUsername;
    }

    @Override
    public String getSocksProxyPassword() {
        return this.socksProxyPassword;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) {
        FTPClient ftpclient;
        Result result;
        block40: {
            result = previousResult;
            result.setResult(false);
            long filesPut = 0L;
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFtpPut.Log.Starting", (String[])new String[0]));
            }
            ftpclient = null;
            try {
                String realWildcard;
                List<String> files;
                File localFiles;
                File[] children;
                String realLocalDirectory;
                ftpclient = this.createAndSetUpFtpClient();
                String realRemoteDirectory = this.resolve(this.remoteDirectory);
                if (!Utils.isEmpty((CharSequence)realRemoteDirectory)) {
                    ftpclient.changeWorkingDirectory(realRemoteDirectory);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFtpPut.Log.ChangedDirectory", (String[])new String[]{realRemoteDirectory}));
                    }
                }
                if ((realLocalDirectory = this.resolve(this.localDirectory)) == null) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"ActionFtpPut.LocalDir.NotSpecified", (String[])new String[0]));
                }
                if (realLocalDirectory.startsWith("file:")) {
                    realLocalDirectory = new URI(realLocalDirectory).getPath();
                }
                if ((children = (localFiles = new File(realLocalDirectory)).listFiles()) == null) {
                    files = Collections.emptyList();
                } else {
                    files = new ArrayList<String>(children.length);
                    for (File child : children) {
                        if (child.isDirectory()) continue;
                        files.add(child.getName());
                    }
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFtpPut.Log.FoundFileLocalDirectory", (String[])new String[]{"" + files.size(), realLocalDirectory}));
                }
                Pattern pattern = !Utils.isEmpty((CharSequence)(realWildcard = this.resolve(this.wildcard))) ? Pattern.compile(realWildcard) : null;
                for (String file : files) {
                    if (this.parentWorkflow.isStopped()) break;
                    boolean toBeProcessed = true;
                    if (pattern != null) {
                        Matcher matcher = pattern.matcher(file);
                        toBeProcessed = matcher.matches();
                    }
                    if (!toBeProcessed) continue;
                    boolean fileExist = false;
                    try {
                        fileExist = FtpClientUtil.fileExists(ftpclient, file);
                    }
                    catch (Exception e) {
                        this.logError("Error checking for file existence on FTP server for file: " + file, e);
                    }
                    if (this.log.isDebug()) {
                        if (fileExist) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionFtpPut.Log.FileExists", (String[])new String[]{file}));
                        } else {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionFtpPut.Log.FileDoesNotExists", (String[])new String[]{file}));
                        }
                    }
                    if (fileExist && this.onlyPuttingNewFiles) continue;
                    if (this.log.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"ActionFtpPut.Log.PuttingFileToRemoteDirectory", (String[])new String[]{file, realRemoteDirectory}));
                    }
                    String localFilename = realLocalDirectory + Const.FILE_SEPARATOR + file;
                    try (InputStream inputStream = HopVfs.getInputStream((String)localFilename);){
                        boolean success;
                        boolean deleted;
                        if (fileExist && !(deleted = ftpclient.deleteFile(file))) {
                            this.log.logError("Deletion of (existing) file '" + file + "' on the FTP server was not successful with reply string: " + ftpclient.getReplyString());
                        }
                        if (success = ftpclient.storeFile(file, inputStream)) {
                            ++filesPut;
                        } else {
                            this.log.logError("Transfer of file '" + localFilename + "' to the FTP server was not successful with reply string: " + ftpclient.getReplyString());
                        }
                    }
                    if (!this.remove) continue;
                    new File(localFilename).delete();
                    if (!this.log.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionFtpPut.Log.DeletedFile", (String[])new String[]{localFilename}));
                }
                result.setResult(true);
                if (!this.log.isBasic()) break block40;
                this.logBasic(BaseMessages.getString(PKG, (String)"ActionFtpPut.Log.WeHavePut", (String[])new String[]{"" + filesPut}));
            }
            catch (Exception e) {
                try {
                    result.setNrErrors(1L);
                    this.logError(BaseMessages.getString(PKG, (String)"ActionFtpPut.Log.ErrorPuttingFiles", (String[])new String[]{e.getMessage()}));
                    this.logError(Const.getStackTracker((Throwable)e));
                }
                catch (Throwable throwable) {
                    if (ftpclient != null && ftpclient.isConnected()) {
                        try {
                            ftpclient.quit();
                        }
                        catch (Exception e2) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionFtpPut.Log.ErrorQuitingFTP", (String[])new String[]{e2.getMessage()}));
                        }
                    }
                    FtpClientUtil.clearSocksJvmSettings();
                    throw throwable;
                }
                if (ftpclient != null && ftpclient.isConnected()) {
                    try {
                        ftpclient.quit();
                    }
                    catch (Exception e3) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionFtpPut.Log.ErrorQuitingFTP", (String[])new String[]{e3.getMessage()}));
                    }
                }
                FtpClientUtil.clearSocksJvmSettings();
            }
        }
        if (ftpclient != null && ftpclient.isConnected()) {
            try {
                ftpclient.quit();
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionFtpPut.Log.ErrorQuitingFTP", (String[])new String[]{e.getMessage()}));
            }
        }
        FtpClientUtil.clearSocksJvmSettings();
        return result;
    }

    FTPClient createAndSetUpFtpClient() throws IOException, HopException {
        FTPClient ftpClient = FtpClientUtil.connectAndLogin(this.log, (IVariables)this, this, this.getName());
        return ftpClient;
    }

    public boolean isEvaluation() {
        return true;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies((IVariables)this, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.serverName)) {
            String realServerName = this.resolve(this.serverName);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realServerName, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "serverName", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "localDirectory", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileExistsValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "userName", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "password", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "serverPort", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.integerValidator()}));
    }
}

