/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.CharConverter;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class ErrorCodeParameter
extends ProgramParameter
implements Serializable {
    static final long serialVersionUID = 4L;
    private static final boolean DEBUG = false;
    private static final boolean FORMAT_ERRC0100 = true;
    private static final boolean FORMAT_ERRC0200 = false;
    private static final int CCSID_EBCDIC = 37;
    private CharConverter charConverter_;
    private boolean format_;
    private boolean returnSubstitutionData_;
    private boolean usedMinimalConstructor_;

    public ErrorCodeParameter() {
        super(BinaryConverter.intToByteArray(0), 8);
        this.format_ = true;
        this.returnSubstitutionData_ = false;
        this.usedMinimalConstructor_ = true;
    }

    public ErrorCodeParameter(boolean returnSubstitutionData, boolean useCCHAR) {
        this.returnSubstitutionData_ = returnSubstitutionData;
        this.usedMinimalConstructor_ = false;
        this.format_ = !useCCHAR;
        try {
            byte[] inputData;
            int offsetOfBytesProvidedField;
            int outputDataLength;
            if (this.format_) {
                outputDataLength = 16;
                offsetOfBytesProvidedField = 0;
                inputData = new byte[4];
            } else {
                outputDataLength = 32;
                offsetOfBytesProvidedField = 4;
                inputData = new byte[8];
                BinaryConverter.intToByteArray(-1, inputData, 0);
            }
            if (returnSubstitutionData) {
                outputDataLength += 100;
            }
            BinaryConverter.intToByteArray(outputDataLength, inputData, offsetOfBytesProvidedField);
            this.setInputData(inputData);
            this.setOutputDataLength(outputDataLength);
        }
        catch (PropertyVetoException e) {
            Trace.log(2, e);
            throw new InternalErrorException(10, (Throwable)e);
        }
    }

    int getDataCCSID() {
        if (this.format_) {
            return 0;
        }
        byte[] outputData = this.getOutputData();
        if (outputData == null) {
            return 0;
        }
        int offsetToCCSID = 20;
        if (outputData.length < 24) {
            Trace.log(2, "Output data buffer is too short: " + outputData.length + " bytes. Minimum size required: " + 24);
            throw new InternalErrorException(6, "Output buffer too short.", null);
        }
        return BinaryConverter.byteArrayToInt(outputData, 20);
    }

    public String getMessageID() {
        int offsetToID;
        if (this.usedMinimalConstructor_) {
            return null;
        }
        byte[] outputData = this.getOutputData();
        if (outputData == null) {
            return null;
        }
        int n = offsetToID = this.format_ ? 8 : 12;
        if (outputData.length < offsetToID + 7) {
            Trace.log(2, "Output data buffer is too short: " + outputData.length + " bytes. Minimum size required: " + (offsetToID + 7));
            throw new InternalErrorException(6, "Output buffer too short.", null);
        }
        String exceptionID = this.getCharConverter().byteArrayToString(outputData, offsetToID, 7).trim();
        if (exceptionID.length() == 0) {
            if (Trace.traceOn_) {
                Trace.log(1, "Blank message ID returned.");
            }
            return null;
        }
        return exceptionID;
    }

    public String getSubstitutionData() {
        String exceptionData;
        int offsetToData;
        if (!this.returnSubstitutionData_) {
            return null;
        }
        byte[] outputData = this.getOutputData();
        if (outputData == null) {
            return null;
        }
        int offsetToBytesAvail = this.format_ ? 4 : 8;
        int n = offsetToData = this.format_ ? 16 : 32;
        if (outputData.length < offsetToData + 1) {
            Trace.log(2, "Output data buffer is too short: " + outputData.length + " bytes. Minimum size required: " + (offsetToData + 1));
            throw new InternalErrorException(6, "Output buffer too short.", null);
        }
        int bytesAvailable = BinaryConverter.byteArrayToInt(outputData, offsetToBytesAvail);
        int lengthOfExceptionData = this.format_ ? bytesAvailable - 16 : BinaryConverter.byteArrayToInt(outputData, 28);
        int ccsid = this.getDataCCSID();
        if (ccsid == 0 || ccsid == 65535) {
            exceptionData = this.getCharConverter().byteArrayToString(outputData, offsetToData, lengthOfExceptionData);
        } else {
            try {
                CharConverter conv = new CharConverter(ccsid);
                exceptionData = conv.byteArrayToString(outputData, offsetToData, lengthOfExceptionData);
            }
            catch (UnsupportedEncodingException e) {
                Trace.log(2, "Received UnsupportedEncodingException for CCSID " + ccsid, (Throwable)e);
                throw new InternalErrorException(10, (Throwable)e);
            }
        }
        return exceptionData;
    }

    private CharConverter getCharConverter() {
        try {
            if (this.charConverter_ == null) {
                this.charConverter_ = new CharConverter(37);
            }
            return this.charConverter_;
        }
        catch (UnsupportedEncodingException e) {
            Trace.log(2, "Received UnsupportedEncodingException for CCSID 37", (Throwable)e);
            throw new InternalErrorException(10, (Throwable)e);
        }
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        if (Trace.isTraceOn()) {
            Trace.log(1, "De-serializing ErrorCodeParameter object.");
        }
        in.defaultReadObject();
    }
}

