/*
 * Decompiled with CFR 0.152.
 */
package org.monetdb.mcl.net;

import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collections;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.monetdb.mcl.net.Target;

public final class SecureSocket {
    private static final String[] ENABLED_PROTOCOLS = new String[]{"TLSv1.3"};
    private static final String[] APPLICATION_PROTOCOLS = new String[]{"mapi/9"};
    private static SSLSocketFactory vanillaFactory = null;

    private static synchronized SSLSocketFactory getDefaultSocketFactory() {
        if (vanillaFactory == null) {
            vanillaFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        return vanillaFactory;
    }

    public static Socket wrap(Target.Validated validated, Socket socket) throws IOException {
        Target.Verify verify = validated.connectVerify();
        boolean bl = true;
        try {
            SSLSocketFactory sSLSocketFactory;
            switch (verify) {
                case System: {
                    sSLSocketFactory = SecureSocket.getDefaultSocketFactory();
                    break;
                }
                case Cert: {
                    KeyStore keyStore = SecureSocket.keyStoreForCert(validated.getCert());
                    sSLSocketFactory = SecureSocket.certBasedSocketFactory(keyStore);
                    break;
                }
                case Hash: {
                    sSLSocketFactory = SecureSocket.hashBasedSocketFactory(validated.connectCertHashDigits());
                    bl = false;
                    break;
                }
                default: {
                    throw new RuntimeException("unreachable: unexpected verification strategy " + verify.name());
                }
            }
            return SecureSocket.wrapSocket(socket, validated, sSLSocketFactory, bl);
        }
        catch (CertificateException certificateException) {
            throw new SSLException("TLS certificate rejected", certificateException);
        }
    }

    private static SSLSocket wrapSocket(Socket socket, Target.Validated validated, SSLSocketFactory sSLSocketFactory, boolean bl) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, validated.connectTcp(), validated.connectPort(), true);
        sSLSocket.setUseClientMode(true);
        SSLParameters sSLParameters = sSLSocket.getSSLParameters();
        sSLParameters.setProtocols(ENABLED_PROTOCOLS);
        sSLParameters.setServerNames(Collections.singletonList(new SNIHostName(validated.connectTcp())));
        if (bl) {
            sSLParameters.setEndpointIdentificationAlgorithm("HTTPS");
        }
        try {
            Method method = SSLParameters.class.getMethod("setApplicationProtocols", String[].class);
            method.invoke((Object)sSLParameters, new Object[]{APPLICATION_PROTOCOLS});
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        sSLSocket.setSSLParameters(sSLParameters);
        sSLSocket.startHandshake();
        return sSLSocket;
    }

    private static X509Certificate loadCertificate(String string) throws CertificateException, IOException {
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(fileInputStream);
            return x509Certificate;
        }
    }

    private static SSLSocketFactory certBasedSocketFactory(KeyStore keyStore) throws IOException, CertificateException {
        SSLContext sSLContext;
        TrustManagerFactory trustManagerFactory;
        try {
            trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore);
        }
        catch (KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
            throw new RuntimeException("Could not create TrustManagerFactory", generalSecurityException);
        }
        try {
            sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, trustManagerFactory.getTrustManagers(), null);
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            throw new RuntimeException("Could not create SSLContext", generalSecurityException);
        }
        return sSLContext.getSocketFactory();
    }

    private static KeyStore keyStoreForCert(String string) throws IOException, CertificateException {
        try {
            X509Certificate x509Certificate = SecureSocket.loadCertificate(string);
            KeyStore keyStore = SecureSocket.emptyKeyStore();
            keyStore.setCertificateEntry("root", x509Certificate);
            return keyStore;
        }
        catch (KeyStoreException keyStoreException) {
            throw new RuntimeException("Could not create KeyStore for certificate", keyStoreException);
        }
    }

    private static KeyStore emptyKeyStore() throws IOException, CertificateException {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            keyStore.load(null, null);
            return keyStore;
        }
        catch (KeyStoreException | NoSuchAlgorithmException generalSecurityException) {
            throw new RuntimeException("Could not create KeyStore for certificate", generalSecurityException);
        }
    }

    private static SSLSocketFactory hashBasedSocketFactory(String string) {
        HashBasedTrustManager hashBasedTrustManager = new HashBasedTrustManager(string);
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, new TrustManager[]{hashBasedTrustManager}, null);
            return sSLContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            throw new RuntimeException("Could not create SSLContext", generalSecurityException);
        }
    }

    private static class HashBasedTrustManager
    implements X509TrustManager {
        private static final char[] HEXDIGITS = "0123456789abcdef".toCharArray();
        private final String hashDigits;

        public HashBasedTrustManager(String string) {
            this.hashDigits = string;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            throw new RuntimeException("this TrustManager is only suitable for client side connections");
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            byte[] byArray;
            Object object;
            X509Certificate x509Certificate = x509CertificateArray[0];
            byte[] byArray2 = x509Certificate.getEncoded();
            try {
                object = MessageDigest.getInstance("SHA-256");
                ((MessageDigest)object).update(byArray2);
                byArray = ((MessageDigest)object).digest();
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("failed to instantiate hash digest");
            }
            object = new StringBuilder(2 * byArray.length);
            for (byte by : byArray) {
                int n = (by & 0xF0) >> 4;
                int n2 = by & 0xF;
                ((StringBuilder)object).append(HEXDIGITS[n]);
                ((StringBuilder)object).append(HEXDIGITS[n2]);
            }
            Object object2 = ((StringBuilder)object).toString();
            if (!((String)object2).startsWith(this.hashDigits)) {
                throw new CertificateException("Certificate hash does not start with '" + this.hashDigits + "': " + (String)object2);
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

