/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.CharStreams;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GceMetadataUtil {
    private static final @UnknownKeyFor @NonNull @Initialized String BASE_METADATA_URL = "http://metadata/computeMetadata/v1/";
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(GceMetadataUtil.class);

    static @UnknownKeyFor @NonNull @Initialized String fetchMetadata(@UnknownKeyFor @NonNull @Initialized String key) {
        String ret;
        String requestUrl;
        block7: {
            requestUrl = BASE_METADATA_URL + key;
            int timeoutMillis = 5000;
            BasicHttpParams httpParams = new BasicHttpParams();
            HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)timeoutMillis);
            HttpConnectionParams.setSoTimeout((HttpParams)httpParams, (int)timeoutMillis);
            ret = "";
            try {
                DefaultHttpClient client = new DefaultHttpClient((HttpParams)httpParams);
                HttpGet request = new HttpGet(requestUrl);
                request.setHeader("Metadata-Flavor", "Google");
                HttpResponse response = client.execute((HttpUriRequest)request);
                if (response.getStatusLine().getStatusCode() != 200) break block7;
                InputStream in = response.getEntity().getContent();
                try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
                    ret = CharStreams.toString((Readable)reader);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        LOG.debug("Fetched GCE Metadata at '{}' and got '{}'", (Object)requestUrl, (Object)ret);
        return ret;
    }

    private static @UnknownKeyFor @NonNull @Initialized String fetchVmInstanceMetadata(@UnknownKeyFor @NonNull @Initialized String instanceMetadataKey) {
        return GceMetadataUtil.fetchMetadata("instance/" + instanceMetadataKey);
    }

    private static @UnknownKeyFor @NonNull @Initialized String fetchCustomGceMetadata(@UnknownKeyFor @NonNull @Initialized String customMetadataKey) {
        return GceMetadataUtil.fetchVmInstanceMetadata("attributes/" + customMetadataKey);
    }

    public static @UnknownKeyFor @NonNull @Initialized String fetchDataflowJobId() {
        return GceMetadataUtil.fetchCustomGceMetadata("job_id");
    }

    public static @UnknownKeyFor @NonNull @Initialized String fetchDataflowJobName() {
        return GceMetadataUtil.fetchCustomGceMetadata("job_name");
    }

    public static @UnknownKeyFor @NonNull @Initialized String fetchDataflowWorkerId() {
        return GceMetadataUtil.fetchVmInstanceMetadata("id");
    }
}

