/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.internal.org.antlr.v4.runtime.BaseErrorListener;
import com.clickhouse.client.internal.org.antlr.v4.runtime.CharStreams;
import com.clickhouse.client.internal.org.antlr.v4.runtime.CodePointCharStream;
import com.clickhouse.client.internal.org.antlr.v4.runtime.CommonTokenStream;
import com.clickhouse.client.internal.org.antlr.v4.runtime.RecognitionException;
import com.clickhouse.client.internal.org.antlr.v4.runtime.Recognizer;
import com.clickhouse.client.internal.org.antlr.v4.runtime.tree.IterativeParseTreeWalker;
import com.clickhouse.jdbc.internal.ClickHouseLexer;
import com.clickhouse.jdbc.internal.ClickHouseParser;
import com.clickhouse.jdbc.internal.ClickHouseParserBaseListener;
import com.clickhouse.jdbc.internal.ParsedPreparedStatement;
import com.clickhouse.jdbc.internal.ParsedStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlParser {
    private static final Logger LOG = LoggerFactory.getLogger(SqlParser.class);

    public ParsedStatement parsedStatement(String sql) {
        ParsedStatement parserListener = new ParsedStatement();
        this.walkSql(sql, parserListener);
        return parserListener;
    }

    public ParsedPreparedStatement parsePreparedStatement(String sql) {
        ParsedPreparedStatement parserListener = new ParsedPreparedStatement();
        this.walkSql(sql, parserListener);
        return parserListener;
    }

    private ClickHouseParser walkSql(String sql, ClickHouseParserBaseListener listener) {
        CodePointCharStream charStream = CharStreams.fromString(sql);
        ClickHouseLexer lexer = new ClickHouseLexer(charStream);
        ClickHouseParser parser = new ClickHouseParser(new CommonTokenStream(lexer));
        parser.removeErrorListeners();
        parser.addErrorListener(new ParserErrorListener());
        ClickHouseParser.QueryStmtContext parseTree = parser.queryStmt();
        IterativeParseTreeWalker.DEFAULT.walk(listener, parseTree);
        return parser;
    }

    private static class ParserErrorListener
    extends BaseErrorListener {
        private ParserErrorListener() {
        }

        @Override
        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            LOG.warn("SQL syntax error at line: " + line + ", pos: " + charPositionInLine + ", " + msg);
        }
    }
}

