/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hop.core.Const;
import org.apache.hop.core.HopClientEnvironment;
import org.apache.hop.core.action.GuiContextAction;
import org.apache.hop.core.action.GuiContextActionFilter;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPluginType;
import org.apache.hop.core.gui.plugin.GuiRegistry;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.gui.plugin.callback.GuiCallback;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.core.gui.plugin.menu.GuiMenuElement;
import org.apache.hop.core.gui.plugin.tab.GuiTab;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElementFilter;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.IPluginType;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.search.SearchableAnalyserPluginType;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.ui.hopgui.file.HopFileTypePluginType;
import org.apache.hop.ui.hopgui.file.HopFileTypeRegistry;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.perspective.HopPerspectivePluginType;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.w3c.dom.Node;

public class HopGuiEnvironment
extends HopClientEnvironment {
    public static void init() throws HopException {
        HopGuiEnvironment.init(List.of(GuiPluginType.getInstance(), HopPerspectivePluginType.getInstance(), HopFileTypePluginType.getInstance(), SearchableAnalyserPluginType.getInstance()));
    }

    public static void init(List<IPluginType> pluginTypes) throws HopException {
        pluginTypes.forEach(PluginRegistry::addPluginType);
        for (IPluginType pluginType : pluginTypes) {
            pluginType.searchPlugins();
        }
        HopGuiEnvironment.initGuiPlugins();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initGuiPlugins() throws HopException {
        ArrayList<String> excludedGuiElements = new ArrayList<String>();
        try {
            List exclusionNodes;
            Node exclusionsNode;
            Object document;
            String path;
            FileObject applicationFolderFile = HopVfs.getFileObject((String)"./disabledGuiElements.xml");
            FileObject configFolderFile = HopVfs.getFileObject((String)(Const.HOP_CONFIG_FOLDER + File.separator + "disabledGuiElements.xml"));
            if (applicationFolderFile.exists()) {
                path = applicationFolderFile.getPath().toAbsolutePath().toString();
                document = XmlHandler.loadXmlFile((String)path);
                exclusionsNode = XmlHandler.getSubNode((Node)document, (String)"exclusions");
                exclusionNodes = XmlHandler.getNodes((Node)exclusionsNode, (String)"exclusion");
                for (Node exclusionNode : exclusionNodes) {
                    excludedGuiElements.add(exclusionNode.getTextContent());
                }
            }
            if (configFolderFile.exists()) {
                path = configFolderFile.getPath().toAbsolutePath().toString();
                document = XmlHandler.loadXmlFile((String)path);
                exclusionsNode = XmlHandler.getSubNode((Node)document, (String)"exclusions");
                exclusionNodes = XmlHandler.getNodes((Node)exclusionsNode, (String)"exclusion");
                for (Node exclusionNode : exclusionNodes) {
                    excludedGuiElements.add(exclusionNode.getTextContent());
                }
            }
        }
        catch (FileSystemException | HopXmlException applicationFolderFile) {
            // empty catch block
        }
        try {
            GuiRegistry guiRegistry = GuiRegistry.getInstance();
            PluginRegistry pluginRegistry = PluginRegistry.getInstance();
            List guiPlugins = pluginRegistry.getPlugins(GuiPluginType.class);
            for (IPlugin guiPlugin : guiPlugins) {
                ClassLoader classLoader = pluginRegistry.getClassLoader(guiPlugin);
                Class[] typeClasses = guiPlugin.getClassMap().keySet().toArray(new Class[0]);
                String guiPluginClassName = (String)guiPlugin.getClassMap().get(typeClasses[0]);
                Class<?> guiPluginClass = classLoader.loadClass(guiPluginClassName);
                List fields = HopGuiEnvironment.findDeclaredFields(guiPluginClass);
                for (Field field : fields) {
                    GuiWidgetElement guiElement = field.getAnnotation(GuiWidgetElement.class);
                    if (guiElement == null || excludedGuiElements.contains(guiElement.id())) continue;
                    guiRegistry.addGuiWidgetElement(guiPluginClassName, guiElement, field);
                }
                List methods = HopGuiEnvironment.findDeclaredMethods(guiPluginClass);
                for (Method method : methods) {
                    GuiTab guiTab;
                    GuiWidgetElement guiWidgetElement;
                    GuiCallback guiCallback;
                    GuiContextActionFilter actionFilter;
                    GuiContextAction contextAction;
                    GuiOsxKeyboardShortcut osxShortcut;
                    GuiKeyboardShortcut shortcut;
                    GuiToolbarElementFilter toolbarElementFilter;
                    GuiToolbarElement toolbarElement;
                    GuiMenuElement menuElement = method.getAnnotation(GuiMenuElement.class);
                    if (menuElement != null) {
                        guiRegistry.addGuiMenuElement(guiPluginClassName, menuElement, method, classLoader);
                    }
                    if ((toolbarElement = method.getAnnotation(GuiToolbarElement.class)) != null && !excludedGuiElements.contains(toolbarElement.id())) {
                        guiRegistry.addGuiToolbarElement(guiPluginClassName, toolbarElement, method, classLoader);
                    }
                    if ((toolbarElementFilter = method.getAnnotation(GuiToolbarElementFilter.class)) != null) {
                        guiRegistry.addGuiToolbarItemFilter(guiPluginClassName, method, toolbarElementFilter, classLoader);
                    }
                    if ((shortcut = method.getAnnotation(GuiKeyboardShortcut.class)) != null) {
                        if (EnvironmentUtils.getInstance().isWeb() && shortcut.key() == 27) continue;
                        guiRegistry.addKeyboardShortcut(guiPluginClassName, method, shortcut);
                    }
                    if ((osxShortcut = method.getAnnotation(GuiOsxKeyboardShortcut.class)) != null) {
                        if (EnvironmentUtils.getInstance().isWeb() && osxShortcut.key() == 27) continue;
                        guiRegistry.addKeyboardShortcut(guiPluginClassName, method, osxShortcut);
                    }
                    if ((contextAction = method.getAnnotation(GuiContextAction.class)) != null && !excludedGuiElements.contains(contextAction.id())) {
                        guiRegistry.addGuiContextAction(guiPluginClassName, method, contextAction, classLoader);
                    }
                    if ((actionFilter = method.getAnnotation(GuiContextActionFilter.class)) != null) {
                        guiRegistry.addGuiActionFilter(guiPluginClassName, method, actionFilter, classLoader);
                    }
                    if ((guiCallback = method.getAnnotation(GuiCallback.class)) != null) {
                        guiRegistry.registerGuiCallback(guiPluginClass, method, guiCallback);
                    }
                    if ((guiWidgetElement = method.getAnnotation(GuiWidgetElement.class)) != null && !excludedGuiElements.contains(guiWidgetElement.id())) {
                        if (guiWidgetElement.type() == GuiElementType.COMPOSITE) {
                            guiRegistry.addCompositeGuiWidgetElement(guiWidgetElement, method, classLoader);
                        } else {
                            guiRegistry.addGuiWidgetElement(guiWidgetElement, method, guiPluginClassName, classLoader);
                        }
                    }
                    if ((guiTab = method.getAnnotation(GuiTab.class)) == null || excludedGuiElements.contains(guiTab.id())) continue;
                    guiRegistry.addGuiTab(guiPluginClassName, method, guiTab, classLoader);
                }
            }
            guiRegistry.sortAllElements();
            PluginRegistry registry = PluginRegistry.getInstance();
            List plugins = registry.getPlugins(HopFileTypePluginType.class);
            for (IPlugin plugin : plugins) {
                try {
                    IHopFileType hopFileTypeInterface = (IHopFileType)registry.loadClass(plugin, IHopFileType.class);
                    HopFileTypeRegistry.getInstance().registerHopFile(hopFileTypeInterface);
                }
                catch (HopPluginException e) {
                    throw new HopException("Unable to load plugin with ID '" + plugin.getIds()[0] + "' and type : " + plugin.getPluginType().getName(), (Throwable)e);
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new HopException("Error looking for Elements in GUI Plugins ", (Throwable)e);
        }
    }
}

