/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.database.dialog;

import java.lang.reflect.InvocationTargetException;
import org.apache.hop.core.IProgressMonitor;
import org.apache.hop.core.IRunnableWithProgress;
import org.apache.hop.core.ProgressMonitorAdapter;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaInformation;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.ProgressMonitorDialog;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Shell;

public class GetDatabaseInfoProgressDialog {
    private static final Class<?> PKG = GetDatabaseInfoProgressDialog.class;
    private Shell shell;
    private final IVariables variables;
    private DatabaseMeta databaseMeta;

    public GetDatabaseInfoProgressDialog(Shell shell, IVariables variables, DatabaseMeta databaseMeta) {
        this.shell = shell;
        this.variables = variables;
        this.databaseMeta = databaseMeta;
    }

    public DatabaseMetaInformation open() {
        DatabaseMetaInformation dmi;
        block6: {
            dmi = new DatabaseMetaInformation(this.variables, this.databaseMeta);
            if (!EnvironmentUtils.getInstance().isWeb()) {
                IRunnableWithProgress op = monitor -> {
                    try {
                        dmi.getData(HopGui.getInstance().getLoggingObject(), (IProgressMonitor)new ProgressMonitorAdapter(monitor));
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e, BaseMessages.getString(PKG, (String)"GetDatabaseInfoProgressDialog.Error.GettingInfoTable", (String[])new String[]{e.toString()}));
                    }
                };
                try {
                    ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
                    pmd.run(true, op);
                    if (pmd.getProgressMonitor().isCanceled()) {
                        return null;
                    }
                    break block6;
                }
                catch (InterruptedException | InvocationTargetException e) {
                    this.showErrorDialog(e);
                    return null;
                }
            }
            try {
                Cursor cursor = new Cursor((Device)this.shell.getDisplay(), 1);
                this.shell.setCursor(cursor);
                dmi.getData(HopGui.getInstance().getLoggingObject(), null);
            }
            catch (HopDatabaseException e) {
                this.showErrorDialog((Exception)((Object)e));
                return null;
            }
        }
        return dmi;
    }

    private void showErrorDialog(Exception e) {
        new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetDatabaseInfoProgressDialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetDatabaseInfoProgressDialog.Error.Message", (String[])new String[0]), e);
    }
}

