/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.deletefiles;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.actions.deletefiles.FileItem;
import org.apache.hop.workflow.engine.IWorkflowEngine;

@Action(id="DELETE_FILES", name="i18n::ActionDeleteFiles.Name", description="i18n::ActionDeleteFiles.Description", image="DeleteFiles.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionDeleteFiles.keyword"}, documentationUrl="/workflow/actions/deletefiles.html")
public class ActionDeleteFiles
extends ActionBase {
    private static final Class<?> PKG = ActionDeleteFiles.class;
    @HopMetadataProperty(key="arg_from_previous")
    private boolean argFromPrevious;
    @HopMetadataProperty(key="include_subfolders")
    private boolean includeSubfolders;
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<FileItem> fileItems;

    public ActionDeleteFiles(String workflowName) {
        super(workflowName, "");
        this.argFromPrevious = false;
        this.includeSubfolders = false;
        this.fileItems = List.of();
    }

    public ActionDeleteFiles() {
        this("");
    }

    public ActionDeleteFiles(ActionDeleteFiles other) {
        super(other.getName(), other.getDescription(), other.getPluginId());
        this.argFromPrevious = other.argFromPrevious;
        this.includeSubfolders = other.includeSubfolders;
        this.fileItems = new ArrayList<FileItem>(other.fileItems);
    }

    public Object clone() {
        return new ActionDeleteFiles(this);
    }

    public Result execute(Result result, int nr) throws HopException {
        List resultRows = result.getRows();
        int numberOfErrFiles = 0;
        result.setResult(false);
        result.setNrErrors(1L);
        if (this.argFromPrevious && this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.FoundPreviousRows", (String[])new String[]{String.valueOf(resultRows != null ? resultRows.size() : 0)}));
        }
        Multimap<String, String> pathToMaskMap = this.populateDataForWorkflowExecution(resultRows);
        for (Map.Entry pathToMask : pathToMaskMap.entries()) {
            String filePath = this.resolve((String)pathToMask.getKey());
            if (filePath.trim().isEmpty()) {
                if (!this.isDetailed()) continue;
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.NoPathProvided", (String[])new String[0]));
                continue;
            }
            String fileMask = this.resolve((String)pathToMask.getValue());
            if (this.parentWorkflow.isStopped()) break;
            if (this.processFile(filePath, fileMask, (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow)) continue;
            ++numberOfErrFiles;
        }
        if (numberOfErrFiles == 0) {
            result.setResult(true);
            result.setNrErrors(0L);
        } else {
            result.setNrErrors((long)numberOfErrFiles);
            result.setResult(false);
        }
        return result;
    }

    private Multimap<String, String> populateDataForWorkflowExecution(List<RowMetaAndData> rowsFromPreviousMeta) throws HopValueException {
        ArrayListMultimap pathToMaskMap;
        block6: {
            block5: {
                pathToMaskMap = ArrayListMultimap.create();
                if (!this.argFromPrevious || rowsFromPreviousMeta == null) break block5;
                for (RowMetaAndData resultRow : rowsFromPreviousMeta) {
                    if (resultRow.size() < 2) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.Error.InvalidNumberOfRowsFromPrevMeta", (Object[])new Object[]{resultRow.size()}));
                        return pathToMaskMap;
                    }
                    String pathToFile = resultRow.getString(0, null);
                    String fileMask = resultRow.getString(1, null);
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.ProcessingRow", (String[])new String[]{pathToFile, fileMask}));
                    }
                    pathToMaskMap.put((Object)pathToFile, (Object)fileMask);
                }
                break block6;
            }
            if (Utils.isEmpty(this.fileItems)) break block6;
            for (FileItem item : this.fileItems) {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.ProcessingArg", (String[])new String[]{item.getFileName(), item.getFileMask()}));
                }
                pathToMaskMap.put((Object)item.getFileName(), (Object)item.getFileMask());
            }
        }
        return pathToMaskMap;
    }

    boolean processFile(String path, String wildcard, IWorkflowEngine<WorkflowMeta> parentWorkflow) {
        boolean isDeleted = false;
        try (FileObject fileFolder = HopVfs.getFileObject((String)path, (IVariables)this.getVariables());){
            if (fileFolder.exists()) {
                if (fileFolder.getType() == FileType.FOLDER) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.ProcessingFolder", (String[])new String[]{path}));
                    }
                    int totalDeleted = fileFolder.delete((FileSelector)new TextFileSelector(fileFolder.toString(), wildcard, parentWorkflow));
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.TotalDeleted", (String[])new String[]{String.valueOf(totalDeleted)}));
                    }
                    isDeleted = true;
                } else {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.ProcessingFile", (String[])new String[]{path}));
                    }
                    if (!(isDeleted = fileFolder.delete())) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.CouldNotDeleteFile", (String[])new String[]{path}));
                    } else if (this.isBasic()) {
                        this.logBasic(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.FileDeleted", (String[])new String[]{path}));
                    }
                }
            } else {
                if (this.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.FileAlreadyDeleted", (String[])new String[]{path}));
                }
                isDeleted = true;
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.CouldNotProcess", (String[])new String[]{path, e.getMessage()}), e);
        }
        return isDeleted;
    }

    private boolean getFileWildcard(String selectedfile, String wildcard) {
        boolean getIt = true;
        if (!Utils.isEmpty((CharSequence)wildcard)) {
            Pattern pattern = Pattern.compile(wildcard);
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public boolean isEvaluation() {
        return true;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileExistsValidator()});
        for (FileItem item : this.fileItems) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, item.getFileName(), remarks, ctx);
        }
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        ResourceReference reference = null;
        for (FileItem item : this.fileItems) {
            String filename = this.resolve(item.getFileName());
            if (reference == null) {
                reference = new ResourceReference((IResourceHolder)this);
                references.add(reference);
            }
            reference.getEntries().add(new ResourceEntry(filename, ResourceEntry.ResourceType.FILE));
        }
        return references;
    }

    @Generated
    public void setArgFromPrevious(boolean argFromPrevious) {
        this.argFromPrevious = argFromPrevious;
    }

    @Generated
    public void setIncludeSubfolders(boolean includeSubfolders) {
        this.includeSubfolders = includeSubfolders;
    }

    @Generated
    public void setFileItems(List<FileItem> fileItems) {
        this.fileItems = fileItems;
    }

    @Generated
    public boolean isArgFromPrevious() {
        return this.argFromPrevious;
    }

    @Generated
    public boolean isIncludeSubfolders() {
        return this.includeSubfolders;
    }

    @Generated
    public List<FileItem> getFileItems() {
        return this.fileItems;
    }

    private class TextFileSelector
    implements FileSelector {
        String fileWildcard = null;
        String sourceFolder = null;
        IWorkflowEngine<WorkflowMeta> workflow;

        public TextFileSelector(String sourceFolder, String fileWildcard, IWorkflowEngine<WorkflowMeta> workflow) {
            if (!Utils.isEmpty((CharSequence)sourceFolder)) {
                this.sourceFolder = sourceFolder;
            }
            if (!Utils.isEmpty((CharSequence)fileWildcard)) {
                this.fileWildcard = fileWildcard;
            }
            this.workflow = workflow;
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean doReturnCode = false;
            try {
                if (!info.getFile().toString().equals(this.sourceFolder) && !this.workflow.isStopped()) {
                    String shortFilename = info.getFile().getName().getBaseName();
                    if (!info.getFile().getParent().equals(info.getBaseFolder())) {
                        if (ActionDeleteFiles.this.includeSubfolders && info.getFile().getType() == FileType.FILE && ActionDeleteFiles.this.getFileWildcard(shortFilename, this.fileWildcard)) {
                            if (ActionDeleteFiles.this.isDetailed()) {
                                ActionDeleteFiles.this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.DeletingFile", (String[])new String[]{info.getFile().toString()}));
                            }
                            doReturnCode = true;
                        }
                    } else if (info.getFile().getType() == FileType.FILE && ActionDeleteFiles.this.getFileWildcard(shortFilename, this.fileWildcard)) {
                        if (ActionDeleteFiles.this.isDetailed()) {
                            ActionDeleteFiles.this.logDetailed(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.DeletingFile", (String[])new String[]{info.getFile().toString()}));
                        }
                        doReturnCode = true;
                    }
                }
            }
            catch (Exception e) {
                ActionDeleteFiles.this.logError(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.Error.Exception.DeleteProcessError", (String[])new String[]{info.getFile().toString(), e.getMessage()}));
                doReturnCode = false;
            }
            return doReturnCode;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return true;
        }
    }
}

