/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding.filter.comparison;

import dev.langchain4j.data.document.Metadata;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.store.embedding.filter.Filter;
import dev.langchain4j.store.embedding.filter.comparison.NumberComparator;
import dev.langchain4j.store.embedding.filter.comparison.TypeChecker;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class IsIn
implements Filter {
    private final String key;
    private final Collection<?> comparisonValues;

    public IsIn(String key, Collection<?> comparisonValues) {
        this.key = ValidationUtils.ensureNotBlank(key, "key");
        HashSet copy = new HashSet(ValidationUtils.ensureNotEmpty(comparisonValues, "comparisonValues with key '" + key + "'"));
        comparisonValues.forEach(value -> ValidationUtils.ensureNotNull(value, "comparisonValue with key '" + key + "'"));
        this.comparisonValues = Collections.unmodifiableSet(copy);
    }

    public String key() {
        return this.key;
    }

    public Collection<?> comparisonValues() {
        return this.comparisonValues;
    }

    @Override
    public boolean test(Object object) {
        if (!(object instanceof Metadata)) {
            return false;
        }
        Metadata metadata = (Metadata)object;
        if (!metadata.containsKey(this.key)) {
            return false;
        }
        Object actualValue = metadata.toMap().get(this.key);
        TypeChecker.ensureTypesAreCompatible(actualValue, this.comparisonValues.iterator().next(), this.key);
        if (this.comparisonValues.iterator().next() instanceof Number) {
            return NumberComparator.containsAsBigDecimals(actualValue, this.comparisonValues);
        }
        return this.comparisonValues.contains(actualValue);
    }

    public String toString() {
        return "IsIn(key=" + this.key + ", comparisonValues=" + this.comparisonValues + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IsIn)) {
            return false;
        }
        IsIn other = (IsIn)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.key;
        String other$key = other.key;
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        Collection<?> this$comparisonValues = this.comparisonValues;
        Collection<?> other$comparisonValues = other.comparisonValues;
        return !(this$comparisonValues == null ? other$comparisonValues != null : !((Object)this$comparisonValues).equals(other$comparisonValues));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IsIn;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.key;
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        Collection<?> $comparisonValues = this.comparisonValues;
        result = result * 59 + ($comparisonValues == null ? 43 : ((Object)$comparisonValues).hashCode());
        return result;
    }
}

