/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.TableReference;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.Objects;

public final class TableId
implements Serializable {
    static final Function<TableReference, TableId> FROM_PB_FUNCTION = new Function<TableReference, TableId>(){

        public TableId apply(TableReference pb) {
            return TableId.fromPb(pb);
        }
    };
    static final Function<TableId, TableReference> TO_PB_FUNCTION = new Function<TableId, TableReference>(){

        public TableReference apply(TableId tableId) {
            return tableId.toPb();
        }
    };
    private static final long serialVersionUID = -6186254820908152300L;
    private final String project;
    private final String dataset;
    private final String table;

    public String getProject() {
        return this.project;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getTable() {
        return this.table;
    }

    public String getIAMResourceName() {
        return String.format("projects/%s/datasets/%s/tables/%s", this.getProject(), this.getDataset(), this.getTable());
    }

    private TableId(String project, String dataset, String table) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)dataset) ? 1 : 0) != 0, (Object)"Provided dataset is null or empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)table) ? 1 : 0) != 0, (Object)"Provided table is null or empty");
        this.project = project;
        this.dataset = dataset;
        this.table = table;
    }

    public static TableId of(String project, String dataset, String table) {
        return new TableId((String)Preconditions.checkNotNull((Object)project), dataset, table);
    }

    public static TableId of(String dataset, String table) {
        return new TableId(null, dataset, table);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof TableId && Objects.equals(this.toPb(), ((TableId)obj).toPb());
    }

    public int hashCode() {
        return Objects.hash(this.project, this.dataset, this.table);
    }

    public String toString() {
        return this.toPb().toString();
    }

    TableId setProjectId(String projectId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"Provided projectId is null or empty");
        return TableId.of(projectId, this.getDataset(), this.getTable());
    }

    TableReference toPb() {
        return new TableReference().setProjectId(this.project).setDatasetId(this.dataset).setTableId(this.table);
    }

    static TableId fromPb(TableReference tableRef) {
        return new TableId(tableRef.getProjectId(), tableRef.getDatasetId(), tableRef.getTableId());
    }
}

