/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.flink.core.fs.CloseableRegistry;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.util.Disposable;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.FunctionWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackendRestorerProcedure<T extends Closeable & Disposable, S extends StateObject> {
    private static final Logger LOG = LoggerFactory.getLogger(BackendRestorerProcedure.class);
    private final FunctionWithException<Collection<S>, T, Exception> instanceSupplier;
    private final CloseableRegistry backendCloseableRegistry;
    private final String logDescription;

    public BackendRestorerProcedure(@Nonnull FunctionWithException<Collection<S>, T, Exception> instanceSupplier, @Nonnull CloseableRegistry backendCloseableRegistry, @Nonnull String logDescription) {
        this.instanceSupplier = (FunctionWithException)Preconditions.checkNotNull(instanceSupplier);
        this.backendCloseableRegistry = (CloseableRegistry)Preconditions.checkNotNull((Object)backendCloseableRegistry);
        this.logDescription = logDescription;
    }

    @Nonnull
    public T createAndRestore(@Nonnull List<? extends Collection<S>> restoreOptions, @Nonnull StateObject.StateObjectSizeStatsCollector stats) throws Exception {
        if (restoreOptions.isEmpty()) {
            restoreOptions = Collections.singletonList(Collections.emptyList());
        }
        int alternativeIdx = 0;
        Exception collectedException = null;
        while (alternativeIdx < restoreOptions.size()) {
            Collection<Object> restoreState = restoreOptions.get(alternativeIdx);
            ++alternativeIdx;
            if (restoreState.isEmpty()) {
                LOG.debug("Creating {} with empty state.", (Object)this.logDescription);
            } else if (LOG.isTraceEnabled()) {
                LOG.trace("Creating {} and restoring with state {} from alternative ({}/{}).", new Object[]{this.logDescription, restoreState, alternativeIdx, restoreOptions.size()});
            } else {
                LOG.debug("Creating {} and restoring with state from alternative ({}/{}).", new Object[]{this.logDescription, alternativeIdx, restoreOptions.size()});
            }
            try {
                T successfullyRestored = this.attemptCreateAndRestore(restoreState);
                restoreState.forEach(handle -> handle.collectSizeStats(stats));
                return successfullyRestored;
            }
            catch (Exception ex) {
                collectedException = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)ex, collectedException);
                if (this.backendCloseableRegistry.isClosed()) {
                    throw new FlinkException("Stopping restore attempts for already cancelled task.", (Throwable)collectedException);
                }
                LOG.warn("Exception while restoring {} from alternative ({}/{}), will retry while more alternatives are available.", new Object[]{this.logDescription, alternativeIdx, restoreOptions.size(), ex});
            }
        }
        throw new FlinkException("Could not restore " + this.logDescription + " from any of the " + restoreOptions.size() + " provided restore options.", collectedException);
    }

    private T attemptCreateAndRestore(Collection<S> restoreState) throws Exception {
        Closeable backendInstance = (Closeable)this.instanceSupplier.apply(restoreState);
        try {
            this.backendCloseableRegistry.registerCloseable((AutoCloseable)backendInstance);
            return (T)backendInstance;
        }
        catch (Exception ex) {
            try {
                ((Disposable)backendInstance).dispose();
            }
            catch (Exception disposeEx) {
                ex = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)disposeEx, (Throwable)ex);
            }
            throw ex;
        }
    }
}

