/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.flink.core.fs.DuplicatingFileSystem;
import org.apache.flink.core.fs.EntropyInjector;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointStateToolset;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.filesystem.FileStateHandle;
import org.apache.flink.runtime.state.filesystem.RelativeFileStateHandle;

public class FsCheckpointStateToolset
implements CheckpointStateToolset {
    private final Path basePath;
    private final DuplicatingFileSystem fs;

    public FsCheckpointStateToolset(Path basePath, DuplicatingFileSystem fs) {
        this.basePath = basePath;
        this.fs = fs;
    }

    @Override
    public boolean canFastDuplicate(StreamStateHandle stateHandle) throws IOException {
        if (!(stateHandle instanceof FileStateHandle)) {
            return false;
        }
        Path srcPath = ((FileStateHandle)stateHandle).getFilePath();
        Path dst = this.getNewDstPath(srcPath.getName());
        return this.fs.canFastDuplicate(srcPath, dst);
    }

    @Override
    public List<StreamStateHandle> duplicate(List<StreamStateHandle> stateHandles) throws IOException {
        ArrayList<DuplicatingFileSystem.CopyRequest> requests = new ArrayList<DuplicatingFileSystem.CopyRequest>();
        for (StreamStateHandle handle : stateHandles) {
            if (!(handle instanceof FileStateHandle)) {
                throw new IllegalArgumentException("We can duplicate only FileStateHandles.");
            }
            Path srcPath = ((FileStateHandle)handle).getFilePath();
            requests.add(DuplicatingFileSystem.CopyRequest.of((Path)srcPath, (Path)this.getNewDstPath(srcPath.getName())));
        }
        this.fs.duplicate(requests);
        return IntStream.range(0, stateHandles.size()).mapToObj(idx -> {
            StreamStateHandle originalHandle = (StreamStateHandle)stateHandles.get(idx);
            Path dst = ((DuplicatingFileSystem.CopyRequest)requests.get(idx)).getDestination();
            if (originalHandle instanceof RelativeFileStateHandle) {
                return new RelativeFileStateHandle(dst, dst.getName(), originalHandle.getStateSize());
            }
            return new FileStateHandle(dst, originalHandle.getStateSize());
        }).collect(Collectors.toList());
    }

    private Path getNewDstPath(String fileName) throws IOException {
        Path dst = new Path(this.basePath, fileName);
        return EntropyInjector.addEntropy((FileSystem)dst.getFileSystem(), (Path)dst);
    }
}

