/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import com.google.common.annotations.VisibleForTesting;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Configuration;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.Const;
import org.apache.hop.core.HopClientEnvironment;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.HopVersionProvider;
import org.apache.hop.core.Result;
import org.apache.hop.core.config.plugin.IConfigOptions;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.plugins.JarCache;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.hop.Hop;
import org.apache.hop.hop.plugin.HopCommand;
import org.apache.hop.hop.plugin.IHopCommand;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.json.JsonMetadataProvider;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.metadata.util.HopMetadataInstance;
import org.apache.hop.metadata.util.HopMetadataUtil;
import org.apache.hop.pipeline.transform.TransformStatus;
import org.apache.hop.server.HopServerMeta;
import org.apache.hop.www.HopServerConfig;
import org.apache.hop.www.HopServerPipelineStatus;
import org.apache.hop.www.HopServerSingleton;
import org.apache.hop.www.HopServerStatus;
import org.apache.hop.www.HopServerWorkflowStatus;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.WebServer;
import org.apache.hop.www.WorkflowMap;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import picocli.CommandLine;

@CommandLine.Command(versionProvider=HopVersionProvider.class, mixinStandardHelpOptions=true, description={"Run a Hop server"})
@HopCommand(id="server", description="Run a Hop server")
public class HopServer
implements Runnable,
IHasHopMetadataProvider,
IHopCommand {
    private static final Class<?> PKG = HopServer.class;
    private static final String CONST_FOUND = " found.";
    private static final String CONST_SPACE = "        ";
    private static final String CONST_USAGE_EXAMPLE = "HopServer.Usage.Example";
    @CommandLine.Parameters(description={"One XML configuration file or a hostname and port"}, arity="0..3")
    private List<String> parameters;
    @CommandLine.Option(names={"-p", "--password"}, description={"The server password.  Required for administrative operations only, not for starting the server."})
    private String password;
    @CommandLine.Option(names={"-u", "--userName"}, description={"The server user name.  Required for administrative operations only, not for starting the server."})
    private String username;
    @CommandLine.Option(names={"-l", "--level"}, description={"The debug level, one of NOTHING, ERROR, MINIMAL, BASIC, DETAILED, DEBUG, ROWLEVEL"})
    private String level;
    @CommandLine.Option(names={"-s", "--system-properties"}, description={"A comma separated list of KEY=VALUE pairs"}, split=",")
    private String[] systemProperties = null;
    @CommandLine.Option(names={"-gs", "--general-status"}, description={"List the general status of the server"})
    private boolean generalStatus;
    @CommandLine.Option(names={"-ps", "--pipeline-status"}, description={"List the status of the pipeline with this name (also specify the -id option)"})
    private String pipelineName;
    @CommandLine.Option(names={"-ws", "--workflow-status"}, description={"List the status of the workflow with this name (also specify the -id option)"})
    private String workflowName;
    @CommandLine.Option(names={"-id"}, description={"Specify the ID of the pipeline or workflow to query"})
    private String id;
    @CommandLine.Option(names={"-n", "--server-name"}, description={"The name of the server to start as defined in the metadata."})
    private String serverName;
    private WebServer webServer;
    private HopServerConfig config = new HopServerConfig();
    private boolean allOK;
    private IVariables variables;
    private CommandLine cmd;
    private ILogChannel log;
    private MultiMetadataProvider metadataProvider;
    private Boolean joinOverride = null;
    private String realFilename;

    public HopServer() {
        HopServerMeta defaultServer = new HopServerMeta("local8080", "localhost", "8080", "8079", "cluster", "cluster");
        this.config.setHopServer(defaultServer);
        this.config.setJoining(true);
    }

    @Override
    public void initialize(CommandLine cmd, IVariables variables, MultiMetadataProvider metadataProvider) throws HopException {
        this.cmd = cmd;
        this.variables = variables;
        this.metadataProvider = metadataProvider;
        HopClientEnvironment.getInstance().setClient(HopClientEnvironment.ClientType.SERVER);
        Hop.addMixinPlugins(cmd, "server");
        this.addMetadataFolderProvider();
    }

    public void runHopServer() throws Exception {
        this.allOK = true;
        HopServerSingleton.setHopServerConfig(this.config);
        this.log = HopServerSingleton.getInstance().getLog();
        PipelineMap pipelineMap = HopServerSingleton.getInstance().getPipelineMap();
        pipelineMap.setHopServerConfig(this.config);
        WorkflowMap workflowMap = HopServerSingleton.getInstance().getWorkflowMap();
        workflowMap.setHopServerConfig(this.config);
        HopServerMeta hopServer = this.config.getHopServer();
        String hostname = hopServer.getHostname();
        int port = 80;
        int shutdownPort = 8079;
        if (!Utils.isEmpty((CharSequence)hopServer.getPort())) {
            port = this.parsePort(hopServer);
        }
        if (!Utils.isEmpty((CharSequence)hopServer.getShutdownPort())) {
            shutdownPort = this.parseShutdownPort(hopServer);
        }
        if (this.allOK) {
            boolean shouldJoin = this.config.isJoining();
            if (this.joinOverride != null) {
                shouldJoin = this.joinOverride;
            }
            this.webServer = new WebServer(this.log, pipelineMap, workflowMap, hostname, port, shutdownPort, shouldJoin, this.config.getPasswordFile(), hopServer.getSslConfig());
        }
        ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.HopServerShutdown.id, (Object)this);
    }

    private int parsePort(HopServerMeta hopServer) {
        try {
            return Integer.parseInt(hopServer.getPort());
        }
        catch (Exception e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"HopServer.Error.CanNotPartPort", (String[])new String[]{hopServer.getHostname(), hopServer.getPort()}), (Throwable)e);
            this.allOK = false;
            return -1;
        }
    }

    private int parseShutdownPort(HopServerMeta hopServer) {
        try {
            return Integer.parseInt(hopServer.getShutdownPort());
        }
        catch (Exception e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"HopServer.Error.CanNotPartShutdownPort", (String[])new String[]{hopServer.getShutdownPort()}), (Throwable)e);
            this.allOK = false;
            return -1;
        }
    }

    @Override
    public void run() {
        try {
            this.log = new LogChannel((Object)"HopServer");
            this.log.setLogLevel(this.determineLogLevel());
            this.log.logDetailed("Start of Hop Server");
            ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.HopServerInit.id, (Object)this);
            Map mixins = this.cmd.getMixins();
            for (String key : mixins.keySet()) {
                Object mixin = mixins.get(key);
                if (!(mixin instanceof IConfigOptions)) continue;
                IConfigOptions configOptions = (IConfigOptions)mixin;
                configOptions.handleOption(this.log, (IHasHopMetadataProvider)this, this.variables);
            }
            if (CollectionUtils.isEmpty(this.parameters) && StringUtils.isNotEmpty((String)this.serverName)) {
                this.setupByServerName();
            }
            if (CollectionUtils.size(this.parameters) == 1) {
                this.setupByFileName();
            }
            if ((CollectionUtils.size(this.parameters) == 2 || CollectionUtils.size(this.parameters) == 3) && StringUtils.isNotEmpty((String)this.parameters.get(0)) && StringUtils.isNotEmpty((String)this.parameters.get(1))) {
                String hostname = this.parameters.get(0);
                String port = this.parameters.get(1);
                String shutdownPort = CollectionUtils.size(this.parameters) == 3 ? this.parameters.get(2) : Integer.toString(8079);
                this.setupByHostNameAndPort(hostname, port, shutdownPort);
            }
            this.config.setVariables(this.variables);
            this.config.setMetadataProvider(this.metadataProvider);
            this.addMetadataFolderProvider();
            if (this.handleQueryOptions()) {
                System.exit(0);
            }
            this.runHopServer();
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(this.cmd, "There was an error during the startup of the Hop server", (Throwable)e);
        }
    }

    private void setupByHostNameAndPort(String hostname, String port, String shutdownPort) {
        HopServerMeta hopServer = new HopServerMeta(hostname + ":" + port, hostname, port, shutdownPort, null, null);
        this.config = new HopServerConfig();
        this.config.setHopServer(hopServer);
        this.config.setJoining(true);
    }

    private void setupByFileName() throws HopException {
        this.calculateRealFilename();
        FileObject file = HopVfs.getFileObject((String)this.realFilename);
        Document document = XmlHandler.loadXmlFile((FileObject)file);
        Node configNode = XmlHandler.getSubNode((Node)document, (String)"hop-server-config");
        this.config = new HopServerConfig((ILogChannel)new LogChannel((Object)"Hop server config"), configNode);
        this.config.setFilename(this.parameters.get(0));
    }

    private void setupByServerName() throws HopException {
        String name;
        IHopMetadataSerializer serializer = this.metadataProvider.getSerializer(HopServerMeta.class);
        HopServerMeta hopServer = (HopServerMeta)serializer.load(name = this.variables.resolve(this.serverName));
        if (hopServer == null) {
            throw new HopException("Unable to find Hop Server '" + name + "' couldn't be found in the server metadata");
        }
        String hostname = this.variables.resolve(hopServer.getHostname());
        String port = this.variables.resolve(hopServer.getPort());
        String shutDownPort = this.variables.resolve(hopServer.getShutdownPort());
        this.parameters = List.of(Const.NVL((String)hostname, (String)""), Const.NVL((String)port, (String)""), Const.NVL((String)shutDownPort, (String)""));
    }

    private boolean handleQueryOptions() {
        boolean queried = false;
        try {
            if (this.generalStatus || StringUtils.isNotEmpty((String)this.pipelineName) || StringUtils.isNotEmpty((String)this.workflowName)) {
                if (StringUtils.isEmpty((String)this.username) || StringUtils.isEmpty((String)this.password)) {
                    throw new HopException("Please specify the username and password to query the server status");
                }
                this.config.getHopServer().setUsername(this.variables.resolve(this.username));
                this.config.getHopServer().setPassword(this.variables.resolve(this.password));
            }
            if (this.generalStatus) {
                queried = true;
                HopServerStatus status = this.config.getHopServer().getStatus(this.variables);
                System.out.println("Pipelines: " + status.getPipelineStatusList().size() + CONST_FOUND);
                for (HopServerPipelineStatus pipelineStatus : status.getPipelineStatusList()) {
                    this.printPipelineStatus(pipelineStatus, false);
                }
                System.out.println();
                System.out.println("Workflows: " + status.getWorkflowStatusList().size() + CONST_FOUND);
                for (HopServerWorkflowStatus workflowStatus : status.getWorkflowStatusList()) {
                    this.printWorkflowStatus(workflowStatus, false);
                }
            } else if (StringUtils.isNotEmpty((String)this.pipelineName)) {
                queried = true;
                if (StringUtils.isEmpty((String)this.id)) {
                    throw new HopException("Please specify the ID of the pipeline execution to see its status.");
                }
                HopServerPipelineStatus pipelineStatus = this.config.getHopServer().getPipelineStatus(this.variables, this.pipelineName, this.id, 0);
                this.printPipelineStatus(pipelineStatus, true);
            } else if (StringUtils.isNotEmpty((String)this.workflowName)) {
                queried = true;
                if (StringUtils.isEmpty((String)this.id)) {
                    throw new HopException("Please specify the ID of the workflow execution to see its status.");
                }
                HopServerWorkflowStatus workflowStatus = this.config.getHopServer().getWorkflowStatus(this.variables, this.workflowName, this.id, 0);
                this.printWorkflowStatus(workflowStatus, true);
            }
        }
        catch (Exception e) {
            this.log.logError("Error querying server", (Throwable)e);
            System.exit(8);
        }
        return queried;
    }

    private void printPipelineStatus(HopServerPipelineStatus pipelineStatus, boolean printDetails) {
        Result result = pipelineStatus.getResult();
        System.out.println("  ID: " + pipelineStatus.getId());
        System.out.println("      Name:     " + pipelineStatus.getPipelineName());
        System.out.println("      Status:   " + pipelineStatus.getStatusDescription());
        System.out.println("      Start:    " + this.formatDate(pipelineStatus.getExecutionStartDate()));
        System.out.println("      End:      " + this.formatDate(pipelineStatus.getExecutionEndDate()));
        System.out.println("      Log date: " + this.formatDate(pipelineStatus.getLogDate()));
        if (result != null) {
            System.out.println("      Errors:   " + result.getNrErrors());
        }
        if (printDetails) {
            System.out.println("      Transforms: " + pipelineStatus.getTransformStatusList().size() + CONST_FOUND);
            int nr = 1;
            for (TransformStatus transformStatus : pipelineStatus.getTransformStatusList()) {
                System.out.println(CONST_SPACE + nr++);
                System.out.println("          Name:      " + transformStatus.getTransformName());
                System.out.println("          Copy:      " + transformStatus.getCopy());
                System.out.println("          Status:    " + transformStatus.getStatusDescription());
                System.out.println("          Input:     " + transformStatus.getLinesInput());
                System.out.println("          Output:    " + transformStatus.getLinesOutput());
                System.out.println("          Read:      " + transformStatus.getLinesRead());
                System.out.println("          Written:   " + transformStatus.getLinesWritten());
                System.out.println("          Rejected:  " + transformStatus.getLinesRejected());
                System.out.println("          Updated:   " + transformStatus.getLinesUpdated());
                System.out.println("          Errors:    " + transformStatus.getErrors());
            }
            this.printLoggingString(pipelineStatus.getLoggingString());
        }
    }

    private void printLoggingString(String loggingString) {
        String[] lines;
        if (StringUtils.isEmpty((String)loggingString)) {
            return;
        }
        System.out.println("      Logging: ");
        for (String line : lines = loggingString.split("\n")) {
            System.out.println("          " + line);
        }
    }

    private void printWorkflowStatus(HopServerWorkflowStatus workflowStatus, boolean printDetails) {
        Result result = workflowStatus.getResult();
        System.out.println("  ID: " + workflowStatus.getId());
        System.out.println("      Name:     " + workflowStatus.getWorkflowName());
        System.out.println("      Status:   " + workflowStatus.getStatusDescription());
        System.out.println("      Log date: " + this.formatDate(workflowStatus.getLogDate()));
        if (result != null) {
            System.out.println("      Result:   " + result.isResult());
            System.out.println("      Errors:   " + result.getNrErrors());
        }
        if (printDetails) {
            this.printLoggingString(workflowStatus.getLoggingString());
        }
    }

    private String formatDate(Date date) {
        if (date == null) {
            return "-";
        }
        return XmlHandler.date2string((Date)date);
    }

    private void calculateRealFilename() throws HopException {
        this.realFilename = this.variables.resolve(this.parameters.get(0));
        ExtensionPointHandler.callExtensionPoint((ILogChannel)this.log, (IVariables)this.variables, (String)HopExtensionPoint.HopServerCalculateFilename.id, (Object)this);
    }

    private LogLevel determineLogLevel() {
        return LogLevel.lookupCode((String)this.variables.resolve(this.level));
    }

    public void applySystemProperties() {
        if (this.systemProperties != null) {
            for (String parameter : this.systemProperties) {
                String value;
                String[] split = parameter.split("=");
                String key = split.length > 0 ? split[0] : null;
                String string = value = split.length > 1 ? split[1] : null;
                if (!StringUtils.isNotEmpty((String)key) || !StringUtils.isNotEmpty((String)value)) continue;
                System.setProperty(key, value);
            }
        }
    }

    private void buildVariableSpace() {
        this.variables = Variables.getADefaultVariableSpace();
    }

    public static void main(String[] args) {
        String[] arguments = (String[])Stream.of(args).flatMap(a -> Stream.of(a.split("(?=--)"))).filter(a -> !a.isEmpty()).toArray(String[]::new);
        HopServer hopServer = new HopServer();
        try {
            CommandLine cmd = new CommandLine((Object)hopServer);
            hopServer.applySystemProperties();
            HopClientEnvironment.getInstance().setClient(HopClientEnvironment.ClientType.SERVER);
            HopEnvironment.init();
            hopServer.buildVariableSpace();
            JarCache.getInstance().clear();
            hopServer.metadataProvider = HopMetadataUtil.getStandardHopMetadataProvider((IVariables)hopServer.variables);
            HopMetadataInstance.setMetadataProvider((MultiMetadataProvider)hopServer.metadataProvider);
            Hop.addMixinPlugins(cmd, "server");
            hopServer.setCmd(cmd);
            hopServer.addMetadataFolderProvider();
            CommandLine.ParseResult parseResult = cmd.parseArgs(arguments);
            if (CommandLine.printHelpIfRequested((CommandLine.ParseResult)parseResult)) {
                HopServer.printExtraUsageExamples();
                System.exit(1);
            } else {
                hopServer.run();
                System.exit(0);
            }
        }
        catch (CommandLine.ParameterException e) {
            System.err.println(e.getMessage());
            hopServer.cmd.usage(System.err);
            HopServer.printExtraUsageExamples();
            System.exit(9);
        }
        catch (CommandLine.ExecutionException e) {
            System.err.println("Error found during execution!");
            System.err.println(Const.getStackTracker((Throwable)e));
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("General error found, something went horribly wrong!");
            System.err.println(Const.getStackTracker((Throwable)e));
            System.exit(2);
        }
    }

    private void addMetadataFolderProvider() {
        String metadataFolder = this.config.getMetadataFolder();
        if (StringUtils.isNotEmpty((String)metadataFolder)) {
            this.metadataProvider.getProviders().add(new JsonMetadataProvider(Encr.getEncoder(), metadataFolder, this.variables));
        }
    }

    private static void printExtraUsageExamples() {
        System.err.println();
        System.err.println(BaseMessages.getString(PKG, (String)CONST_USAGE_EXAMPLE, (String[])new String[0]) + ": hop-server.sh 0.0.0.0 8080");
        System.err.println(BaseMessages.getString(PKG, (String)CONST_USAGE_EXAMPLE, (String[])new String[0]) + ": hop-server.sh 192.168.1.221 8081 8082");
        System.err.println();
        System.err.println(BaseMessages.getString(PKG, (String)CONST_USAGE_EXAMPLE, (String[])new String[0]) + ": hop-server.sh -e aura-gcp gs://apachehop/hop-server-config.xml");
        System.err.println(BaseMessages.getString(PKG, (String)CONST_USAGE_EXAMPLE, (String[])new String[0]) + ": hop-server.sh 127.0.0.1 8080 --kill --userName cluster --password cluster");
    }

    private static void shutdown(String hostname, String port, String shutdownPort, String username, String password) {
        try {
            HopServer.callStopHopServerRestService(hostname, port, shutdownPort, username, password);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @VisibleForTesting
    static void callStopHopServerRestService(String hostname, String port, String shutdownPort, String username, String password) throws HopServerCommandException {
        try {
            HopClientEnvironment.init();
            HttpAuthenticationFeature authFeature = HttpAuthenticationFeature.basicBuilder().credentials(username, Encr.decryptPasswordOptionallyEncrypted((String)password)).build();
            ClientConfig clientConfig = new ClientConfig();
            Client client = ClientBuilder.newClient((Configuration)clientConfig);
            client.register((Object)authFeature);
            String contextURL = "http://" + hostname + ":" + port + "/hop";
            WebTarget target = client.target(contextURL + "/status/?xml=Y");
            String response = (String)target.request().get(String.class);
            if (response == null || !response.contains("<serverstatus>")) {
                throw new HopServerCommandException(BaseMessages.getString(PKG, (String)"HopServer.Error.NoServerFound", (String[])new String[]{hostname, port}));
            }
            Socket s = new Socket(InetAddress.getByName(hostname), Integer.parseInt(shutdownPort));
            OutputStream out = s.getOutputStream();
            out.write("\r\n".getBytes());
            out.flush();
            s.close();
        }
        catch (Exception e) {
            throw new HopServerCommandException(BaseMessages.getString(PKG, (String)"HopServer.Error.NoServerFound", (String[])new String[]{hostname, port}), e);
        }
    }

    @Generated
    public List<String> getParameters() {
        return this.parameters;
    }

    @Generated
    public String getPassword() {
        return this.password;
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getLevel() {
        return this.level;
    }

    @Generated
    public String[] getSystemProperties() {
        return this.systemProperties;
    }

    @Generated
    public boolean isGeneralStatus() {
        return this.generalStatus;
    }

    @Generated
    public String getPipelineName() {
        return this.pipelineName;
    }

    @Generated
    public String getWorkflowName() {
        return this.workflowName;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getServerName() {
        return this.serverName;
    }

    @Generated
    public WebServer getWebServer() {
        return this.webServer;
    }

    @Generated
    public HopServerConfig getConfig() {
        return this.config;
    }

    @Generated
    public boolean isAllOK() {
        return this.allOK;
    }

    @Generated
    public IVariables getVariables() {
        return this.variables;
    }

    @Generated
    public CommandLine getCmd() {
        return this.cmd;
    }

    @Generated
    public ILogChannel getLog() {
        return this.log;
    }

    @Generated
    public MultiMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @Generated
    public Boolean getJoinOverride() {
        return this.joinOverride;
    }

    @Generated
    public String getRealFilename() {
        return this.realFilename;
    }

    @Generated
    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    @Generated
    public void setPassword(String password) {
        this.password = password;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setLevel(String level) {
        this.level = level;
    }

    @Generated
    public void setSystemProperties(String[] systemProperties) {
        this.systemProperties = systemProperties;
    }

    @Generated
    public void setGeneralStatus(boolean generalStatus) {
        this.generalStatus = generalStatus;
    }

    @Generated
    public void setPipelineName(String pipelineName) {
        this.pipelineName = pipelineName;
    }

    @Generated
    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    @Generated
    public void setWebServer(WebServer webServer) {
        this.webServer = webServer;
    }

    @Generated
    public void setConfig(HopServerConfig config) {
        this.config = config;
    }

    @Generated
    public void setAllOK(boolean allOK) {
        this.allOK = allOK;
    }

    @Generated
    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    @Generated
    public void setCmd(CommandLine cmd) {
        this.cmd = cmd;
    }

    @Generated
    public void setLog(ILogChannel log) {
        this.log = log;
    }

    @Generated
    public void setMetadataProvider(MultiMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    @Generated
    public void setJoinOverride(Boolean joinOverride) {
        this.joinOverride = joinOverride;
    }

    @Generated
    public void setRealFilename(String realFilename) {
        this.realFilename = realFilename;
    }

    public static class HopServerCommandException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public HopServerCommandException(String message) {
            super(message);
        }

        public HopServerCommandException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

