/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.auth.kerberos;

import com.sun.security.auth.module.Krb5LoginModule;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class KerberosUtil {
    private static final String CONST_PRINCIPAL = "principal";
    public static final String KERBEROS_APP_NAME = "Apache Hop";
    public static final String PENTAHO_JAAS_DEBUG = "PENTAHO_JAAS_DEBUG";
    public static final Map<String, String> LOGIN_CONFIG_BASE = KerberosUtil.createLoginConfigBaseMap();
    private static final Map<String, String> LOGIN_CONFIG_OPTS_KERBEROS_USER = KerberosUtil.getLoginConfigOptsKerberosUser();
    private static final Map<String, String> LOGIN_CONFIG_OPTS_KERBEROS_USER_NOPASS = KerberosUtil.getLoginConfigOptsKerberosNoPassword();
    public static final Map<String, String> LOGIN_CONFIG_OPTS_KERBEROS_KEYTAB = KerberosUtil.createLoginConfigOptsKerberosKeytabMap();

    private static Map<String, String> createLoginConfigBaseMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (Boolean.parseBoolean(System.getenv(PENTAHO_JAAS_DEBUG))) {
            result.put("debug", Boolean.TRUE.toString());
        }
        return Collections.unmodifiableMap(result);
    }

    private static Map<String, String> getLoginConfigOptsKerberosUser() {
        HashMap<String, String> result = new HashMap<String, String>(LOGIN_CONFIG_BASE);
        result.put("useTicketCache", Boolean.FALSE.toString());
        result.put("renewTGT", Boolean.FALSE.toString());
        return Collections.unmodifiableMap(result);
    }

    private static Map<String, String> getLoginConfigOptsKerberosNoPassword() {
        HashMap<String, String> result = new HashMap<String, String>(LOGIN_CONFIG_OPTS_KERBEROS_USER);
        result.put("useTicketCache", Boolean.TRUE.toString());
        result.put("renewTGT", Boolean.TRUE.toString());
        result.put("doNotPrompt", Boolean.TRUE.toString());
        return result;
    }

    private static Map<String, String> createLoginConfigOptsKerberosKeytabMap() {
        HashMap<String, String> result = new HashMap<String, String>(LOGIN_CONFIG_BASE);
        result.put("doNotPrompt", Boolean.TRUE.toString());
        result.put("useKeyTab", Boolean.TRUE.toString());
        result.put("storeKey", Boolean.TRUE.toString());
        result.put("refreshKrb5Config", Boolean.TRUE.toString());
        return Collections.unmodifiableMap(result);
    }

    public LoginContext getLoginContextFromKeytab(String principal, String keytab) throws LoginException {
        HashMap<String, String> keytabConfig = new HashMap<String, String>(LOGIN_CONFIG_OPTS_KERBEROS_KEYTAB);
        keytabConfig.put("keyTab", keytab);
        keytabConfig.put(CONST_PRINCIPAL, principal);
        AppConfigurationEntry config = new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, keytabConfig);
        AppConfigurationEntry[] configEntries = new AppConfigurationEntry[]{config};
        Subject subject = new Subject();
        return new LoginContext(KERBEROS_APP_NAME, subject, null, new HopLoginConfiguration(configEntries));
    }

    public LoginContext getLoginContextFromUsernamePassword(final String principal, final String password) throws LoginException {
        HashMap<String, String> opts = new HashMap<String, String>(LOGIN_CONFIG_OPTS_KERBEROS_USER);
        opts.put(CONST_PRINCIPAL, principal);
        AppConfigurationEntry[] appConfigurationEntries = new AppConfigurationEntry[]{new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, opts)};
        return new LoginContext(KERBEROS_APP_NAME, new Subject(), new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback callback : callbacks) {
                    if (callback instanceof NameCallback) {
                        NameCallback nameCallback = (NameCallback)callback;
                        nameCallback.setName(principal);
                        continue;
                    }
                    if (callback instanceof PasswordCallback) {
                        PasswordCallback passwordCallback = (PasswordCallback)callback;
                        passwordCallback.setPassword(password.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callback);
                }
            }
        }, new HopLoginConfiguration(appConfigurationEntries));
    }

    public LoginContext getLoginContextFromKerberosCache(String principal) throws LoginException {
        HashMap<String, String> opts = new HashMap<String, String>(LOGIN_CONFIG_OPTS_KERBEROS_USER_NOPASS);
        opts.put(CONST_PRINCIPAL, principal);
        AppConfigurationEntry[] appConfigurationEntries = new AppConfigurationEntry[]{new AppConfigurationEntry(Krb5LoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, opts)};
        return new LoginContext(KERBEROS_APP_NAME, new Subject(), null, new HopLoginConfiguration(appConfigurationEntries));
    }

    public static class HopLoginConfiguration
    extends Configuration {
        private final AppConfigurationEntry[] entries;

        public HopLoginConfiguration(AppConfigurationEntry[] entries) {
            if (entries == null) {
                throw new NullPointerException("AppConfigurationEntry[] is required");
            }
            this.entries = entries;
        }

        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String ignored) {
            return this.entries;
        }
    }
}

