/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.config;

import org.apache.hop.config.HopConfigBase;
import org.apache.hop.core.Const;
import org.apache.hop.core.HopEnvironment;
import org.apache.hop.core.HopVersionProvider;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.hop.Hop;
import org.apache.hop.metadata.api.IHasHopMetadataProvider;
import picocli.CommandLine;

@CommandLine.Command(versionProvider=HopVersionProvider.class)
public class HopConfig
extends HopConfigBase
implements Runnable,
IHasHopMetadataProvider {
    public static void main(String[] args) {
        HopConfig hopConfig = new HopConfig();
        try {
            HopEnvironment.init();
            hopConfig.cmd = new CommandLine((Object)hopConfig);
            Hop.addMixinPlugins(hopConfig.cmd, "config");
            hopConfig.variables = Variables.getADefaultVariableSpace();
            hopConfig.buildLogChannel();
            hopConfig.buildMetadataProvider();
            CommandLine.ParseResult parseResult = hopConfig.cmd.parseArgs(args);
            if (CommandLine.printHelpIfRequested((CommandLine.ParseResult)parseResult)) {
                System.exit(1);
            } else {
                hopConfig.run();
                System.exit(0);
            }
        }
        catch (CommandLine.ParameterException e) {
            System.err.println(e.getMessage());
            hopConfig.cmd.usage(System.err);
            e.getCommandLine().usage(System.err);
            System.exit(9);
        }
        catch (CommandLine.ExecutionException e) {
            System.err.println("Error found during execution!");
            System.err.println(Const.getStackTracker((Throwable)e));
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("General error found, something went horribly wrong!");
            System.err.println(Const.getStackTracker((Throwable)e));
            System.exit(2);
        }
    }
}

