/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.grpc.ChannelPoolSettings;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountJwtAccessCredentials;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.CredentialOptions;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.stub.BigtableBatchingCallSettings;
import io.grpc.internal.GrpcUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.beam.sdk.extensions.gcp.auth.CredentialFactory;
import org.apache.beam.sdk.extensions.gcp.auth.NoopCredentialFactory;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableConfig;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableReadOptions;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableWriteOptions;
import org.apache.beam.sdk.io.gcp.bigtable.FixedCredentialFactory;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.threeten.bp.Duration;

class BigtableConfigTranslator {
    @VisibleForTesting
    static final @UnknownKeyFor @NonNull @Initialized String BIGTABLE_SETTINGS_OVERRIDE = "bigtable_settings_override";

    BigtableConfigTranslator() {
    }

    static @UnknownKeyFor @NonNull @Initialized BigtableDataSettings translateReadToVeneerSettings(@NonNull @UnknownKeyFor @Initialized BigtableConfig config, @NonNull @UnknownKeyFor @Initialized BigtableReadOptions options, @Nullable @UnknownKeyFor @Initialized BigtableReadOptions optionsFromBigtableOptions, @NonNull @UnknownKeyFor @Initialized PipelineOptions pipelineOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        BigtableDataSettings.Builder settings = BigtableConfigTranslator.buildBigtableDataSettings(config, pipelineOptions);
        return BigtableConfigTranslator.configureReadSettings(settings, options, optionsFromBigtableOptions);
    }

    static @UnknownKeyFor @NonNull @Initialized BigtableDataSettings translateWriteToVeneerSettings(@NonNull @UnknownKeyFor @Initialized BigtableConfig config, @NonNull @UnknownKeyFor @Initialized BigtableWriteOptions options, @Nullable @UnknownKeyFor @Initialized BigtableWriteOptions optionsFromBigtableOptions, @NonNull @UnknownKeyFor @Initialized PipelineOptions pipelineOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        BigtableDataSettings.Builder settings = BigtableConfigTranslator.buildBigtableDataSettings(config, pipelineOptions);
        return BigtableConfigTranslator.configureWriteSettings(settings, options, optionsFromBigtableOptions);
    }

    static @UnknownKeyFor @NonNull @Initialized BigtableDataSettings translateToVeneerSettings(@NonNull @UnknownKeyFor @Initialized BigtableConfig config, @NonNull @UnknownKeyFor @Initialized PipelineOptions pipelineOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return BigtableConfigTranslator.buildBigtableDataSettings(config, pipelineOptions).build();
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigtableDataSettings.Builder buildBigtableDataSettings(@UnknownKeyFor @NonNull @Initialized BigtableConfig config, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) throws @UnknownKeyFor @NonNull @Initialized IOException {
        BigtableDataSettings.Builder dataBuilder;
        boolean emulator = false;
        if (!Strings.isNullOrEmpty((String)config.getEmulatorHost())) {
            emulator = true;
            String hostAndPort = config.getEmulatorHost();
            try {
                int lastIndexOfCol = hostAndPort.lastIndexOf(":");
                int port = Integer.parseInt(hostAndPort.substring(lastIndexOfCol + 1));
                dataBuilder = BigtableDataSettings.newBuilderForEmulator((String)hostAndPort.substring(0, lastIndexOfCol), (int)port);
            }
            catch (IndexOutOfBoundsException | NumberFormatException ex) {
                throw new RuntimeException("Invalid host/port in BigtableConfig " + hostAndPort);
            }
        } else {
            dataBuilder = BigtableDataSettings.newBuilder();
        }
        dataBuilder.setProjectId(Objects.requireNonNull((String)config.getProjectId().get())).setInstanceId(Objects.requireNonNull((String)config.getInstanceId().get()));
        if (config.getAppProfileId() != null && !Strings.isNullOrEmpty((String)((String)config.getAppProfileId().get()))) {
            dataBuilder.setAppProfileId(Objects.requireNonNull((String)config.getAppProfileId().get()));
        }
        if (!emulator) {
            if (((GcpOptions)pipelineOptions.as(GcpOptions.class)).getGcpCredential() != null) {
                dataBuilder.stubSettings().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)((GcpOptions)pipelineOptions.as(GcpOptions.class)).getGcpCredential()));
            }
            if (config.getCredentialFactory() != null) {
                CredentialFactory credentialFactory = config.getCredentialFactory();
                try {
                    dataBuilder.stubSettings().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)credentialFactory.getCredential()));
                }
                catch (GeneralSecurityException e) {
                    throw new RuntimeException("Exception getting credentials ", e);
                }
            }
        }
        BigtableConfigTranslator.configureChannelPool(dataBuilder.stubSettings(), config);
        BigtableConfigTranslator.configureHeaderProvider(dataBuilder.stubSettings(), pipelineOptions);
        String overrideClassName = ExperimentalOptions.getExperimentValue((PipelineOptions)pipelineOptions, (String)BIGTABLE_SETTINGS_OVERRIDE);
        return BigtableConfigTranslator.configureSettingsOverride(overrideClassName, dataBuilder, pipelineOptions);
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigtableDataSettings.Builder configureSettingsOverride(@Nullable @UnknownKeyFor @Initialized String override, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigtableDataSettings.Builder dataBuilder, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
        BiFunction overrideFunction;
        if (override == null) {
            return dataBuilder;
        }
        try {
            overrideFunction = (BiFunction)InstanceBuilder.ofType((TypeDescriptor)new TypeDescriptor<BiFunction<BigtableDataSettings.Builder, PipelineOptions, BigtableDataSettings.Builder>>(){}).fromClassName(override).build();
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Failed to load class override " + override, e);
        }
        try {
            return (BigtableDataSettings.Builder)overrideFunction.apply(dataBuilder, pipelineOptions);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to apply override function for class " + override, e);
        }
    }

    private static void configureHeaderProvider(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized StubSettings.Builder<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> stubSettings, @UnknownKeyFor @NonNull @Initialized PipelineOptions pipelineOptions) {
        ImmutableMap.Builder headersBuilder = ImmutableMap.builder().put((Object)GrpcUtil.USER_AGENT_KEY.name(), (Object)Objects.requireNonNull(pipelineOptions.getUserAgent()));
        stubSettings.setHeaderProvider((HeaderProvider)FixedHeaderProvider.create((Map)headersBuilder.build()));
    }

    private static void configureChannelPool(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized StubSettings.Builder<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> stubSettings, @UnknownKeyFor @NonNull @Initialized BigtableConfig config) {
        if (config.getChannelCount() != null) {
            InstantiatingGrpcChannelProvider grpcChannelProvider = (InstantiatingGrpcChannelProvider)stubSettings.getTransportChannelProvider();
            stubSettings.setTransportChannelProvider((TransportChannelProvider)grpcChannelProvider.toBuilder().setChannelPoolSettings(ChannelPoolSettings.staticallySized((int)config.getChannelCount())).build());
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized BigtableDataSettings configureWriteSettings(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigtableDataSettings.Builder settings, @UnknownKeyFor @NonNull @Initialized BigtableWriteOptions writeOptions, @UnknownKeyFor @NonNull @Initialized BigtableWriteOptions fromBigtableOptions) {
        long initialRpcTimeout;
        BigtableBatchingCallSettings.Builder callSettings = settings.stubSettings().bulkMutateRowsSettings();
        RetrySettings.Builder retrySettings = callSettings.getRetrySettings().toBuilder();
        BatchingSettings.Builder batchingSettings = callSettings.getBatchingSettings().toBuilder();
        FlowControlSettings.Builder flowControlSettings = callSettings.getBatchingSettings().getFlowControlSettings().toBuilder();
        long l = writeOptions.getAttemptTimeout() != null ? writeOptions.getAttemptTimeout().getMillis() : (initialRpcTimeout = fromBigtableOptions != null && fromBigtableOptions.getAttemptTimeout() != null ? fromBigtableOptions.getAttemptTimeout().getMillis() : Duration.ofMinutes((long)6L).toMillis());
        long totalTimeout = writeOptions.getOperationTimeout() != null ? writeOptions.getOperationTimeout().getMillis() : (fromBigtableOptions != null && fromBigtableOptions.getOperationTimeout() != null ? fromBigtableOptions.getOperationTimeout().getMillis() : retrySettings.getTotalTimeout().toMillis());
        retrySettings.setInitialRpcTimeout(Duration.ofMillis((long)initialRpcTimeout)).setMaxRpcTimeout(Duration.ofMillis((long)initialRpcTimeout)).setRpcTimeoutMultiplier(1.0).setTotalTimeout(Duration.ofMillis((long)Math.max(initialRpcTimeout, totalTimeout)));
        long maxElement = writeOptions.getMaxElementsPerBatch() != null ? writeOptions.getMaxElementsPerBatch() : (fromBigtableOptions != null && fromBigtableOptions.getMaxElementsPerBatch() != null ? fromBigtableOptions.getMaxElementsPerBatch() : callSettings.getBatchingSettings().getElementCountThreshold());
        long maxBytes = writeOptions.getMaxBytesPerBatch() != null ? writeOptions.getMaxBytesPerBatch() : (fromBigtableOptions != null && fromBigtableOptions.getMaxBytesPerBatch() != null ? fromBigtableOptions.getMaxBytesPerBatch() : callSettings.getBatchingSettings().getRequestByteThreshold());
        long outstandingElements = writeOptions.getMaxOutstandingElements() != null ? writeOptions.getMaxOutstandingElements() : (fromBigtableOptions != null && fromBigtableOptions.getMaxOutstandingElements() != null ? fromBigtableOptions.getMaxOutstandingElements() : callSettings.getBatchingSettings().getFlowControlSettings().getMaxOutstandingElementCount());
        long outstandingBytes = writeOptions.getMaxOutstandingBytes() != null ? writeOptions.getMaxOutstandingBytes() : (fromBigtableOptions != null && fromBigtableOptions.getMaxOutstandingBytes() != null ? fromBigtableOptions.getMaxOutstandingBytes() : callSettings.getBatchingSettings().getFlowControlSettings().getMaxOutstandingRequestBytes());
        retrySettings.setInitialRpcTimeout(Duration.ofMillis((long)initialRpcTimeout)).setMaxRpcTimeout(Duration.ofMillis((long)initialRpcTimeout)).setRpcTimeoutMultiplier(1.0).setTotalTimeout(Duration.ofMillis((long)Math.max(initialRpcTimeout, totalTimeout)));
        batchingSettings.setFlowControlSettings(flowControlSettings.setMaxOutstandingElementCount(Long.valueOf(outstandingElements)).setMaxOutstandingRequestBytes(Long.valueOf(outstandingBytes)).build()).setElementCountThreshold(Long.valueOf(maxElement)).setRequestByteThreshold(Long.valueOf(maxBytes));
        if (fromBigtableOptions != null && fromBigtableOptions.getThrottlingTargetMs() != null) {
            settings.enableBatchMutationLatencyBasedThrottling((long)fromBigtableOptions.getThrottlingTargetMs().intValue());
        }
        if (writeOptions.getThrottlingTargetMs() != null) {
            settings.enableBatchMutationLatencyBasedThrottling((long)writeOptions.getThrottlingTargetMs().intValue());
        }
        if (Boolean.TRUE.equals(writeOptions.getFlowControl())) {
            settings.setBulkMutationFlowControl(true);
        }
        settings.stubSettings().bulkMutateRowsSettings().setRetrySettings(retrySettings.build()).setBatchingSettings(batchingSettings.build());
        return settings.build();
    }

    private static @UnknownKeyFor @NonNull @Initialized BigtableDataSettings configureReadSettings(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized BigtableDataSettings.Builder settings, @UnknownKeyFor @NonNull @Initialized BigtableReadOptions readOptions, @UnknownKeyFor @NonNull @Initialized BigtableReadOptions optionsFromBigtableOptions) {
        long totalTimeout;
        long initialRpcTimeout;
        RetrySettings.Builder retrySettings = settings.stubSettings().readRowsSettings().getRetrySettings().toBuilder();
        long l = readOptions.getAttemptTimeout() != null ? readOptions.getAttemptTimeout().getMillis() : (initialRpcTimeout = optionsFromBigtableOptions != null && optionsFromBigtableOptions.getAttemptTimeout() != null ? optionsFromBigtableOptions.getAttemptTimeout().getMillis() : retrySettings.getInitialRpcTimeout().toMillis());
        long l2 = readOptions.getOperationTimeout() != null ? readOptions.getOperationTimeout().getMillis() : (totalTimeout = optionsFromBigtableOptions != null && optionsFromBigtableOptions.getOperationTimeout() != null ? optionsFromBigtableOptions.getOperationTimeout().getMillis() : retrySettings.getTotalTimeout().toMillis());
        long waitTimeout = readOptions.getWaitTimeout() != null ? readOptions.getWaitTimeout().getMillis() : (optionsFromBigtableOptions != null && optionsFromBigtableOptions.getWaitTimeout() != null ? optionsFromBigtableOptions.getWaitTimeout().getMillis() : settings.stubSettings().readRowsSettings().getWaitTimeout().toMillis());
        retrySettings.setInitialRpcTimeout(Duration.ofMillis((long)initialRpcTimeout)).setMaxRpcTimeout(Duration.ofMillis((long)initialRpcTimeout)).setRpcTimeoutMultiplier(1.0).setTotalTimeout(Duration.ofMillis((long)Math.max(initialRpcTimeout, totalTimeout)));
        settings.stubSettings().readRowsSettings().setWaitTimeout(Duration.ofMillis((long)waitTimeout)).setIdleTimeout(Duration.ofMinutes((long)10L));
        settings.stubSettings().readRowsSettings().setRetrySettings(retrySettings.build());
        return settings.build();
    }

    static @UnknownKeyFor @NonNull @Initialized BigtableConfig translateToBigtableConfig(@UnknownKeyFor @NonNull @Initialized BigtableConfig config, @UnknownKeyFor @NonNull @Initialized BigtableOptions options) {
        BigtableConfig.Builder builder;
        block21: {
            builder = config.toBuilder();
            if (options.getProjectId() != null && config.getProjectId() == null) {
                builder.setProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)options.getProjectId()));
            }
            if (options.getInstanceId() != null && config.getInstanceId() == null) {
                builder.setInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)options.getInstanceId()));
            }
            if (options.getAppProfileId() != null && config.getAppProfileId() == null) {
                builder.setAppProfileId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)options.getAppProfileId()));
            }
            if (options.getCredentialOptions().getCredentialType() == CredentialOptions.CredentialType.None && config.getEmulatorHost() == null) {
                builder.setEmulatorHost(String.format("%s:%s", options.getDataHost(), options.getPort()));
            }
            builder.setChannelCount(options.getChannelCount());
            if (options.getCredentialOptions() == null) break block21;
            try {
                CredentialOptions credOptions = options.getCredentialOptions();
                switch (credOptions.getCredentialType()) {
                    case DefaultCredentials: {
                        break;
                    }
                    case P12: {
                        String keyFile = ((CredentialOptions.P12CredentialOptions)credOptions).getKeyFile();
                        String serviceAccount = ((CredentialOptions.P12CredentialOptions)credOptions).getServiceAccount();
                        try {
                            KeyStore keyStore = KeyStore.getInstance("PKCS12");
                            try (FileInputStream fin = new FileInputStream(keyFile);){
                                keyStore.load(fin, "notasecret".toCharArray());
                            }
                            PrivateKey privateKey = (PrivateKey)keyStore.getKey("privatekey", "notasecret".toCharArray());
                            if (privateKey == null) {
                                throw new IllegalStateException("private key cannot be null");
                            }
                            ServiceAccountJwtAccessCredentials credentials = ServiceAccountJwtAccessCredentials.newBuilder().setClientEmail(serviceAccount).setPrivateKey(privateKey).build();
                            builder.setCredentialFactory(FixedCredentialFactory.create((Credentials)credentials));
                            break;
                        }
                        catch (GeneralSecurityException exception) {
                            throw new RuntimeException("exception while retrieving credentials", exception);
                        }
                    }
                    case SuppliedCredentials: {
                        Credentials credentials = ((CredentialOptions.UserSuppliedCredentialOptions)credOptions).getCredential();
                        builder.setCredentialFactory(FixedCredentialFactory.create(credentials));
                        break;
                    }
                    case SuppliedJson: {
                        CredentialOptions.JsonCredentialsOptions jsonCredentialsOptions = (CredentialOptions.JsonCredentialsOptions)credOptions;
                        builder.setCredentialFactory(FixedCredentialFactory.create((Credentials)GoogleCredentials.fromStream((InputStream)jsonCredentialsOptions.getInputStream())));
                        break;
                    }
                    case None: {
                        PipelineOptions pipelineOptions = PipelineOptionsFactory.create();
                        builder.setCredentialFactory((CredentialFactory)NoopCredentialFactory.fromOptions((PipelineOptions)pipelineOptions));
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to translate BigtableOptions to BigtableConfig", e);
            }
        }
        return builder.build();
    }

    static @UnknownKeyFor @NonNull @Initialized BigtableReadOptions translateToBigtableReadOptions(@UnknownKeyFor @NonNull @Initialized BigtableReadOptions readOptions, @UnknownKeyFor @NonNull @Initialized BigtableOptions options) {
        BigtableReadOptions.Builder builder = readOptions.toBuilder();
        builder.setWaitTimeout(org.joda.time.Duration.millis((long)options.getRetryOptions().getReadPartialRowTimeoutMillis()));
        if (options.getCallOptionsConfig().getReadStreamRpcAttemptTimeoutMs().isPresent()) {
            builder.setAttemptTimeout(org.joda.time.Duration.millis((long)((Integer)options.getCallOptionsConfig().getReadStreamRpcAttemptTimeoutMs().get()).intValue()));
        }
        builder.setOperationTimeout(org.joda.time.Duration.millis((long)options.getCallOptionsConfig().getReadStreamRpcTimeoutMs()));
        return builder.build();
    }

    static @UnknownKeyFor @NonNull @Initialized BigtableWriteOptions translateToBigtableWriteOptions(@UnknownKeyFor @NonNull @Initialized BigtableWriteOptions writeOptions, @UnknownKeyFor @NonNull @Initialized BigtableOptions options) {
        BigtableWriteOptions.Builder builder = writeOptions.toBuilder();
        if (options.getCallOptionsConfig().getMutateRpcAttemptTimeoutMs().isPresent()) {
            builder.setAttemptTimeout(org.joda.time.Duration.millis((long)((Integer)options.getCallOptionsConfig().getMutateRpcAttemptTimeoutMs().get()).intValue()));
        }
        if (options.getBulkOptions().isEnableBulkMutationThrottling()) {
            builder.setThrottlingTargetMs(options.getBulkOptions().getBulkMutationRpcTargetMs());
        }
        builder.setOperationTimeout(org.joda.time.Duration.millis((long)options.getCallOptionsConfig().getMutateRpcTimeoutMs()));
        builder.setMaxElementsPerBatch(options.getBulkOptions().getBulkMaxRowKeyCount());
        builder.setMaxBytesPerBatch(options.getBulkOptions().getBulkMaxRequestSize());
        builder.setMaxOutstandingElements((long)options.getBulkOptions().getMaxInflightRpcs() * (long)options.getBulkOptions().getBulkMaxRowKeyCount());
        builder.setMaxOutstandingBytes((long)options.getBulkOptions().getMaxInflightRpcs() * options.getBulkOptions().getBulkMaxRequestSize());
        return builder.build();
    }
}

