/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.BigEndianLongCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PCollectionViews;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class View {
    private View() {
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized AsSingleton<T> asSingleton() {
        return new AsSingleton();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized AsList<T> asList() {
        return new AsList(null, false);
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized AsIterable<T> asIterable() {
        return new AsIterable();
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized AsMap<K, V> asMap() {
        return new AsMap(false);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized AsMultimap<K, V> asMultimap() {
        return new AsMultimap(false);
    }

    @Internal
    public static class CreatePCollectionView<@UnknownKeyFor ElemT, @UnknownKeyFor ViewT>
    extends PTransform<PCollection<ElemT>, PCollection<ElemT>> {
        private @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> view;

        private CreatePCollectionView(@UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> view) {
            this.view = view;
        }

        public static <ElemT, ViewT> @UnknownKeyFor @NonNull @Initialized CreatePCollectionView<ElemT, ViewT> of(@UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> view) {
            return new CreatePCollectionView<ElemT, ViewT>(view);
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized PCollectionView<ViewT> getView() {
            return this.view;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollection<ElemT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<ElemT> input) {
            return PCollection.createPrimitiveOutputInternal(input.getPipeline(), input.getWindowingStrategy(), input.isBounded(), input.getCoder());
        }
    }

    @Internal
    public static class AsMap<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollectionView<Map<K, V>>> {
        private final @UnknownKeyFor @NonNull @Initialized boolean inMemory;

        private AsMap(@UnknownKeyFor @NonNull @Initialized boolean inMemory) {
            this.inMemory = inMemory;
        }

        public @UnknownKeyFor @NonNull @Initialized AsMap<K, V> inMemory() {
            return this.inMemory(true);
        }

        public @UnknownKeyFor @NonNull @Initialized AsMap<K, V> inMemory(@UnknownKeyFor @NonNull @Initialized boolean inMemory) {
            return new AsMap<K, V>(inMemory);
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized AsMap<K, V> withSingletonValues() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, V>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            PCollectionView view;
            try {
                GroupByKey.applicableTo(input);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Unable to create a side-input view from input", e);
            }
            KvCoder kvCoder = (KvCoder)input.getCoder();
            Coder keyCoder = kvCoder.getKeyCoder();
            Coder valueCoder = kvCoder.getValueCoder();
            PCollection materializationInput = (PCollection)input.apply(MapElements.via(new SimpleFunction<KV<K, V>, KV<K, V>>(x -> x){}));
            if (this.inMemory) {
                if (!(input.getWindowingStrategy().getWindowFn() instanceof GlobalWindows)) {
                    PCollection voidKeyMaterializationInput = (PCollection)input.apply(MapElements.via(new SimpleFunction<KV<K, V>, KV<Void, KV<K, V>>>(kv -> KV.of(null, kv)){}));
                    PCollectionView view2 = PCollectionViews.inMemoryMapViewUsingVoidKey((PCollection)materializationInput.apply(MapElements.via(new SimpleFunction<KV<K, V>, KV<Void, KV<K, V>>>(kv -> KV.of(null, kv)){})), keyCoder, valueCoder, voidKeyMaterializationInput.getWindowingStrategy());
                    voidKeyMaterializationInput.apply(CreatePCollectionView.of(view2));
                    return view2;
                }
                view = PCollectionViews.inMemoryMapView(materializationInput, keyCoder, valueCoder, materializationInput.getWindowingStrategy());
            } else {
                view = PCollectionViews.mapView(materializationInput, keyCoder::getEncodedTypeDescriptor, valueCoder::getEncodedTypeDescriptor, materializationInput.getWindowingStrategy());
            }
            input.apply(CreatePCollectionView.of(view));
            return view;
        }
    }

    @Internal
    public static class AsMultimap<@UnknownKeyFor K, @UnknownKeyFor V>
    extends PTransform<PCollection<KV<K, V>>, PCollectionView<Map<K, Iterable<V>>>> {
        private final @UnknownKeyFor @NonNull @Initialized boolean inMemory;

        private AsMultimap(@UnknownKeyFor @NonNull @Initialized boolean inMemory) {
            this.inMemory = inMemory;
        }

        public @UnknownKeyFor @NonNull @Initialized AsMultimap<K, V> inMemory() {
            return this.inMemory(true);
        }

        public @UnknownKeyFor @NonNull @Initialized AsMultimap<K, V> inMemory(@UnknownKeyFor @NonNull @Initialized boolean inMemory) {
            return new AsMultimap<K, V>(inMemory);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Map<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<K, V>> input) {
            PCollectionView view;
            try {
                GroupByKey.applicableTo(input);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Unable to create a side-input view from input", e);
            }
            KvCoder kvCoder = (KvCoder)input.getCoder();
            Coder keyCoder = kvCoder.getKeyCoder();
            Coder valueCoder = kvCoder.getValueCoder();
            PCollection materializationInput = (PCollection)input.apply(MapElements.via(new SimpleFunction<KV<K, V>, KV<K, V>>(x -> x){}));
            if (this.inMemory) {
                if (!(input.getWindowingStrategy().getWindowFn() instanceof GlobalWindows)) {
                    PCollection voidKeyMaterializationInput = (PCollection)input.apply(MapElements.via(new SimpleFunction<KV<K, V>, KV<Void, KV<K, V>>>(kv -> KV.of(null, kv)){}));
                    PCollectionView view2 = PCollectionViews.inMemoryMultimapViewUsingVoidKey(voidKeyMaterializationInput, keyCoder, valueCoder, voidKeyMaterializationInput.getWindowingStrategy());
                    voidKeyMaterializationInput.apply(CreatePCollectionView.of(view2));
                    return view2;
                }
                view = PCollectionViews.inMemoryMultimapView(materializationInput, keyCoder, valueCoder, materializationInput.getWindowingStrategy());
            } else {
                view = PCollectionViews.multimapView(materializationInput, keyCoder::getEncodedTypeDescriptor, valueCoder::getEncodedTypeDescriptor, materializationInput.getWindowingStrategy());
            }
            input.apply(CreatePCollectionView.of(view));
            return view;
        }
    }

    private static class SingletonCombineFn<@UnknownKeyFor T>
    extends Combine.BinaryCombineFn<T> {
        private final @UnknownKeyFor @NonNull @Initialized boolean hasDefault;
        private final @Nullable @UnknownKeyFor @Initialized Coder<T> valueCoder;
        private final @UnknownKeyFor @NonNull @Initialized byte @Nullable @UnknownKeyFor @Initialized [] defaultValue;

        private SingletonCombineFn(@UnknownKeyFor @NonNull @Initialized boolean hasDefault, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, T defaultValue) {
            this.hasDefault = hasDefault;
            if (hasDefault) {
                if (defaultValue == null) {
                    this.defaultValue = null;
                    this.valueCoder = coder;
                } else {
                    this.valueCoder = coder;
                    try {
                        this.defaultValue = CoderUtils.encodeToByteArray(coder, defaultValue);
                    }
                    catch (CoderException e) {
                        throw new IllegalArgumentException(String.format("Could not encode the default value %s with the provided coder %s", defaultValue, coder));
                    }
                }
            } else {
                this.valueCoder = null;
                this.defaultValue = null;
            }
        }

        @Override
        public T apply(T left, T right) {
            throw new IllegalArgumentException("PCollection with more than one element accessed as a singleton view. Consider using Combine.globally().asSingleton() to combine the PCollection into a single value");
        }

        @Override
        public T identity() {
            if (this.hasDefault) {
                if (this.defaultValue == null) {
                    return null;
                }
                try {
                    return CoderUtils.decodeFromByteArray(this.valueCoder, this.defaultValue);
                }
                catch (CoderException e) {
                    throw new IllegalArgumentException(String.format("Could not decode the default value with the provided coder %s", this.valueCoder));
                }
            }
            throw new IllegalArgumentException("Empty PCollection accessed as a singleton view. Consider setting withDefault to provide a default value");
        }
    }

    @Internal
    public static class AsSingleton<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollectionView<T>> {
        private final @Nullable T defaultValue;
        private final @UnknownKeyFor @NonNull @Initialized boolean hasDefault;

        private AsSingleton() {
            this.defaultValue = null;
            this.hasDefault = false;
        }

        private AsSingleton(T defaultValue) {
            this.defaultValue = defaultValue;
            this.hasDefault = true;
        }

        public @UnknownKeyFor @NonNull @Initialized boolean hasDefaultValue() {
            return this.hasDefault;
        }

        public T defaultValue() {
            return this.defaultValue;
        }

        public @UnknownKeyFor @NonNull @Initialized AsSingleton<T> withDefaultValue(T defaultValue) {
            return new AsSingleton<T>(defaultValue);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionView<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            try {
                GroupByKey.applicableTo(input);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Unable to create a side-input view from input", e);
            }
            Combine.Globally singletonCombine = Combine.globally(new SingletonCombineFn(this.hasDefault, input.getCoder(), this.defaultValue));
            if (!this.hasDefault) {
                singletonCombine = singletonCombine.withoutDefaults();
            }
            return (PCollectionView)input.apply(singletonCombine.asSingletonView());
        }
    }

    @Internal
    public static class AsIterable<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollectionView<Iterable<T>>> {
        private AsIterable() {
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Iterable<T>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            try {
                GroupByKey.applicableTo(input);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Unable to create a side-input view from input", e);
            }
            Coder<T> inputCoder = input.getCoder();
            PCollection materializationInput = (PCollection)input.apply(MapElements.via(new SimpleFunction<T, T>(x -> x){}));
            PCollectionView view = PCollectionViews.iterableView(materializationInput, inputCoder::getEncodedTypeDescriptor, materializationInput.getWindowingStrategy());
            input.apply(CreatePCollectionView.of(view));
            return view;
        }
    }

    @Internal
    public static class ToListViewDoFn<@UnknownKeyFor T>
    extends DoFn<T, KV<Long, PCollectionViews.ValueOrMetadata<T, OffsetRange>>> {
        private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized OffsetRange> windowsToOffsets = new HashMap<BoundedWindow, OffsetRange>();

        private @UnknownKeyFor @NonNull @Initialized OffsetRange generateRange(@UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            long offset = ThreadLocalRandom.current().nextLong(-9223372036854775807L, 9223372034707292160L);
            return new OffsetRange(offset, offset);
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow window) {
            OffsetRange range = this.windowsToOffsets.computeIfAbsent(window, this::generateRange);
            c.output(KV.of(range.getTo(), PCollectionViews.ValueOrMetadata.create(c.element())));
            this.windowsToOffsets.put(window, new OffsetRange(range.getFrom(), range.getTo() + 1L));
        }

        @DoFn.FinishBundle
        public void finishBundle(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) {
            for (Map.Entry<BoundedWindow, OffsetRange> entry : this.windowsToOffsets.entrySet()) {
                c.output(KV.of(Long.MIN_VALUE, PCollectionViews.ValueOrMetadata.createMetadata(entry.getValue())), entry.getKey().maxTimestamp(), entry.getKey());
            }
            this.windowsToOffsets.clear();
        }
    }

    @Internal
    public static class AsList<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PCollectionView<List<T>>> {
        private final @Nullable @UnknownKeyFor @Initialized Boolean withRandomAccess;
        private final @UnknownKeyFor @NonNull @Initialized boolean inMemory;

        private AsList(@Nullable @UnknownKeyFor @Initialized Boolean withRandomAccess, @UnknownKeyFor @NonNull @Initialized boolean inMemory) {
            this.withRandomAccess = withRandomAccess;
            this.inMemory = inMemory;
        }

        public @UnknownKeyFor @NonNull @Initialized AsList<T> withRandomAccess() {
            return this.withRandomAccess(true);
        }

        public @UnknownKeyFor @NonNull @Initialized AsList<T> withRandomAccess(@UnknownKeyFor @NonNull @Initialized boolean withRandomAccess) {
            return new AsList<T>(withRandomAccess, this.inMemory);
        }

        public @UnknownKeyFor @NonNull @Initialized AsList<T> inMemory() {
            return this.inMemory(true);
        }

        public @UnknownKeyFor @NonNull @Initialized AsList<T> inMemory(@UnknownKeyFor @NonNull @Initialized boolean inMemory) {
            return new AsList<T>(this.withRandomAccess, inMemory);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized List<T>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            boolean explicitWithRandomAccess;
            try {
                GroupByKey.applicableTo(input);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException("Unable to create a side-input view from input", e);
            }
            boolean bl = explicitWithRandomAccess = this.withRandomAccess != null ? this.withRandomAccess : StreamingOptions.updateCompatibilityVersionLessThan(input.getPipeline().getOptions(), "2.57.0");
            if (this.inMemory) {
                return this.expandInMemory(input);
            }
            if (explicitWithRandomAccess || !(input.getWindowingStrategy().getWindowFn() instanceof GlobalWindows)) {
                return this.expandWithRandomAccess(input);
            }
            return this.expandWithoutRandomAccess(input);
        }

        private @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized List<T>> expandInMemory(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            if (input.getWindowingStrategy().getWindowFn() instanceof GlobalWindows) {
                PCollection materializationInput = (PCollection)input.apply(MapElements.via(new SimpleFunction<T, T>(x -> x){}));
                PCollectionView view = PCollectionViews.inMemoryListView(materializationInput, input.getCoder()::getEncodedTypeDescriptor, materializationInput.getWindowingStrategy());
                materializationInput.apply(CreatePCollectionView.of(view));
                return view;
            }
            PCollection materializationInput = (PCollection)input.apply(MapElements.via(new SimpleFunction<T, KV<Void, T>>(x -> KV.of(null, x)){}));
            PCollectionView view = PCollectionViews.inMemoryListViewUsingVoidKey(materializationInput, input.getCoder()::getEncodedTypeDescriptor, materializationInput.getWindowingStrategy());
            materializationInput.apply(CreatePCollectionView.of(view));
            return view;
        }

        private @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized List<T>> expandWithoutRandomAccess(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            Coder<T> inputCoder = input.getCoder();
            PCollection materializationInput = (PCollection)input.apply(MapElements.via(new SimpleFunction<T, T>(x -> x){}));
            PCollectionView view = PCollectionViews.listView(materializationInput, inputCoder::getEncodedTypeDescriptor, materializationInput.getWindowingStrategy());
            materializationInput.apply(CreatePCollectionView.of(view));
            return view;
        }

        private @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized List<T>> expandWithRandomAccess(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            Coder<T> inputCoder = input.getCoder();
            PCollection materializationInput = ((PCollection)input.apply("IndexElements", ParDo.of(new ToListViewDoFn()))).setCoder(KvCoder.of(BigEndianLongCoder.of(), PCollectionViews.ValueOrMetadataCoder.create(inputCoder, OffsetRange.Coder.of())));
            PCollectionView view = PCollectionViews.listViewWithRandomAccess(materializationInput, inputCoder::getEncodedTypeDescriptor, materializationInput.getWindowingStrategy());
            materializationInput.apply(CreatePCollectionView.of(view));
            return view;
        }
    }
}

