/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.Hidden;
import org.apache.beam.sdk.options.MemoryMonitorOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Description(value="Options that are used to control configuration of the SDK harness.")
public interface SdkHarnessOptions
extends PipelineOptions,
MemoryMonitorOptions {
    @Description(value="Controls the default log level of all loggers without a log level override.")
    @Default.Enum(value="INFO")
    public @UnknownKeyFor @NonNull @Initialized LogLevel getDefaultSdkHarnessLogLevel();

    public void setDefaultSdkHarnessLogLevel(@UnknownKeyFor @NonNull @Initialized LogLevel var1);

    @Description(value="This option controls the log levels for specifically named loggers. The expected format is {\"Name\":\"LogLevel\",...}. The SDK harness supports a logging hierarchy based off of names that are '.' separated. For example, by specifying the value {\"a.b.c.Foo\":\"DEBUG\"}, the logger for the class 'a.b.c.Foo' will be configured to output logs at the DEBUG level. Similarly, by specifying the value {\"a.b.c\":\"WARN\"}, all loggers underneath the 'a.b.c' package will be configured to output logs at the WARN level. System.out and System.err levels are configured via loggers of the corresponding name. Also, note that when multiple overrides are specified, the exact name followed by the closest parent takes precedence.")
    public @UnknownKeyFor @NonNull @Initialized SdkHarnessLogLevelOverrides getSdkHarnessLogLevelOverrides();

    public void setSdkHarnessLogLevelOverrides(@UnknownKeyFor @NonNull @Initialized SdkHarnessLogLevelOverrides var1);

    @Description(value="This option controls whether SLF4J MDC keys and values will be appended to log entries. This used by Beam to add structured data to log entries, such as quota events and return statuses.")
    @Default.Boolean(value=true)
    public @UnknownKeyFor @NonNull @Initialized boolean getLogMdc();

    public void setLogMdc(@UnknownKeyFor @NonNull @Initialized boolean var1);

    @Description(value="The size (in MB) of the grouping tables used to pre-combine elements before shuffling. If unset, defaults to 100 MB. Larger values may reduce the amount of data shuffled. CAUTION: If set too large, workers may run into OOM conditions more easily, each worker may have many grouping tables in-memory concurrently. CAUTION: This option does not apply to portable runners such as Dataflow Prime. See --maxCacheMemoryUsageMb, --maxCacheMemoryUsagePercent, or --maxCacheMemoryUsageMbClass to configure memory thresholds that apply to the grouping table and other cached objects.")
    @Default.Integer(value=100)
    public @UnknownKeyFor @NonNull @Initialized int getGroupingTableMaxSizeMb();

    public void setGroupingTableMaxSizeMb(@UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="The size (in MB) for the process wide cache within the SDK harness. The cache is responsible for storing all values which are cached within a bundle and across bundles such as side inputs and user state. CAUTION: If set too large, SDK harness instances may run into OOM conditions more easily.")
    @Default.InstanceFactory(value=DefaultMaxCacheMemoryUsageMbFactory.class)
    public @NonNegative @UnknownKeyFor @NonNull @Initialized int getMaxCacheMemoryUsageMb();

    public void setMaxCacheMemoryUsageMb(@NonNegative @UnknownKeyFor @NonNull @Initialized int var1);

    @Description(value="The size (in % [0 - 100]) for the process wide cache within the SDK harness. The cache is responsible for storing all values which are cached within a bundle and across bundles such as side inputs and user state. CAUTION: If set too large, SDK harness instances may run into OOM conditions more easily.")
    @Default.Float(value=20.0f)
    public @NonNegative @UnknownKeyFor @NonNull @Initialized float getMaxCacheMemoryUsagePercent();

    public void setMaxCacheMemoryUsagePercent(@NonNegative @UnknownKeyFor @NonNull @Initialized float var1);

    @Description(value="An instance of this class will be used to specify the maximum amount of memory to allocate to a  process wide cache within an SDK harness instance. This parameter will only be used if an explicit value was not specified for --maxCacheMemoryUsageMb.")
    @Default.Class(value=DefaultMaxCacheMemoryUsageMb.class)
    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized MaxCacheMemoryUsageMb> getMaxCacheMemoryUsageMbClass();

    public void setMaxCacheMemoryUsageMbClass(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized MaxCacheMemoryUsageMb> var1);

    @Description(value="Open modules needed for reflection with Java 17+.")
    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getJdkAddOpenModules();

    public void setJdkAddOpenModules(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

    public static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Logger> getConfiguredLoggerFromOptions(@UnknownKeyFor @NonNull @Initialized SdkHarnessOptions loggingOptions) {
        ArrayList<Logger> configuredLoggers = new ArrayList<Logger>();
        LogManager logManager = LogManager.getLogManager();
        Logger rootLogger = logManager.getLogger("");
        if (loggingOptions.getDefaultSdkHarnessLogLevel() != null) {
            rootLogger.setLevel((Level)LogLevel.LEVEL_CONFIGURATION.get((Object)loggingOptions.getDefaultSdkHarnessLogLevel()));
        }
        if (loggingOptions.getSdkHarnessLogLevelOverrides() != null) {
            for (Map.Entry loggerOverride : loggingOptions.getSdkHarnessLogLevelOverrides().entrySet()) {
                Logger logger = logManager.getLogger((String)loggerOverride.getKey());
                if (logger == null) {
                    logger = Logger.getLogger((String)loggerOverride.getKey());
                }
                logger.setLevel((Level)LogLevel.LEVEL_CONFIGURATION.get(loggerOverride.getValue()));
                configuredLoggers.add(logger);
            }
        }
        return configuredLoggers;
    }

    @Hidden
    @Description(value="Timeout used for cache of bundle processors. Defaults to a minute for batch and an hour for streaming.")
    @Default.InstanceFactory(value=BundleProcessorCacheTimeoutFactory.class)
    public @UnknownKeyFor @NonNull @Initialized Duration getBundleProcessorCacheTimeout();

    public void setBundleProcessorCacheTimeout(@UnknownKeyFor @NonNull @Initialized Duration var1);

    public static class BundleProcessorCacheTimeoutFactory
    implements DefaultValueFactory<Duration> {
        @Override
        public @UnknownKeyFor @NonNull @Initialized Duration create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return options.as(StreamingOptions.class).isStreaming() ? Duration.ofHours(1L) : Duration.ofMinutes(1L);
        }
    }

    public static class SdkHarnessLogLevelOverrides
    extends HashMap<String, LogLevel> {
        public @UnknownKeyFor @NonNull @Initialized SdkHarnessLogLevelOverrides addOverrideForClass(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> klass, @UnknownKeyFor @NonNull @Initialized LogLevel logLevel) {
            Preconditions.checkNotNull(klass, (Object)"Expected class to be not null.");
            this.addOverrideForName(klass.getName(), logLevel);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized SdkHarnessLogLevelOverrides addOverrideForPackage(@UnknownKeyFor @NonNull @Initialized Package pkg, @UnknownKeyFor @NonNull @Initialized LogLevel logLevel) {
            Preconditions.checkNotNull((Object)pkg, (Object)"Expected package to be not null.");
            this.addOverrideForName(pkg.getName(), logLevel);
            return this;
        }

        public @UnknownKeyFor @NonNull @Initialized SdkHarnessLogLevelOverrides addOverrideForName(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized LogLevel logLevel) {
            Preconditions.checkNotNull((Object)name, (Object)"Expected name to be not null.");
            Preconditions.checkNotNull((Object)((Object)logLevel), (String)"Expected logLevel to be one of %s.", (Object)Arrays.toString((Object[])LogLevel.values()));
            this.put(name, logLevel);
            return this;
        }

        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        public static @UnknownKeyFor @NonNull @Initialized SdkHarnessLogLevelOverrides from(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> values) {
            Preconditions.checkNotNull(values, (Object)"Expected values to be not null.");
            SdkHarnessLogLevelOverrides overrides = new SdkHarnessLogLevelOverrides();
            for (Map.Entry<String, String> entry : values.entrySet()) {
                String module = entry.getKey();
                String level = entry.getValue();
                if (level.equals("WARNING")) {
                    level = "WARN";
                }
                try {
                    overrides.addOverrideForName(module, LogLevel.valueOf(level));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(String.format("Unsupported log level '%s' requested for %s. Must be one of %s.", level, module, Arrays.toString((Object[])LogLevel.values())));
                }
            }
            return overrides;
        }
    }

    public static class DefaultMaxCacheMemoryUsageMb
    implements MaxCacheMemoryUsageMb {
        @Override
        public @UnknownKeyFor @NonNull @Initialized int getMaxCacheMemoryUsage(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            return this.getMaxCacheMemoryUsage(options, Runtime.getRuntime().maxMemory());
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized int getMaxCacheMemoryUsage(@UnknownKeyFor @NonNull @Initialized PipelineOptions options, @UnknownKeyFor @NonNull @Initialized long maxMemory) {
            if (maxMemory == Long.MAX_VALUE) {
                return 100;
            }
            float maxPercent = options.as(SdkHarnessOptions.class).getMaxCacheMemoryUsagePercent();
            if (maxPercent < 0.0f || maxPercent > 100.0f) {
                throw new IllegalArgumentException("--maxCacheMemoryUsagePercent must be between 0 and 100.");
            }
            return (int)((double)maxMemory / 1048576.0 * (double)maxPercent / 100.0);
        }
    }

    public static interface MaxCacheMemoryUsageMb {
        public @NonNegative @UnknownKeyFor @NonNull @Initialized int getMaxCacheMemoryUsage(@UnknownKeyFor @NonNull @Initialized PipelineOptions var1);
    }

    public static class DefaultMaxCacheMemoryUsageMbFactory
    implements DefaultValueFactory<Integer> {
        @Override
        public @NonNegative @UnknownKeyFor @NonNull @Initialized Integer create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            SdkHarnessOptions sdkHarnessOptions = options.as(SdkHarnessOptions.class);
            return (Integer)Preconditions.checkNotNull((Object)InstanceBuilder.ofType(MaxCacheMemoryUsageMb.class).fromClass(sdkHarnessOptions.getMaxCacheMemoryUsageMbClass()).build().getMaxCacheMemoryUsage(options));
        }
    }

    public static enum LogLevel {
        OFF,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

        public static final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized LogLevel, @UnknownKeyFor @NonNull @Initialized Level> LEVEL_CONFIGURATION;

        static {
            LEVEL_CONFIGURATION = ImmutableMap.builder().put((Object)OFF, (Object)Level.OFF).put((Object)ERROR, (Object)Level.SEVERE).put((Object)WARN, (Object)Level.WARNING).put((Object)INFO, (Object)Level.INFO).put((Object)DEBUG, (Object)Level.FINE).put((Object)TRACE, (Object)Level.FINEST).build();
        }
    }
}

