/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.api.common.JobID;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManager;
import org.apache.flink.runtime.checkpoint.filemerging.FileMergingSnapshotManagerBuilder;
import org.apache.flink.util.ShutdownHookUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutorFileMergingManager {
    private static final Logger LOG = LoggerFactory.getLogger(TaskExecutorFileMergingManager.class);
    @GuardedBy(value="lock")
    private final Map<JobID, FileMergingSnapshotManager> fileMergingSnapshotManagerByJobId;
    @GuardedBy(value="lock")
    private boolean closed = false;
    private final Object lock = new Object();
    private final Thread shutdownHook;

    public TaskExecutorFileMergingManager() {
        this.fileMergingSnapshotManagerByJobId = new HashMap<JobID, FileMergingSnapshotManager>();
        this.shutdownHook = ShutdownHookUtil.addShutdownHook(this::shutdown, (String)this.getClass().getSimpleName(), (Logger)LOG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public FileMergingSnapshotManager fileMergingSnapshotManagerForJob(@Nonnull JobID jobId) {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("TaskExecutorFileMergingManager is already closed and cannot register a new FileMergingSnapshotManager.");
            }
            FileMergingSnapshotManager fileMergingSnapshotManager = this.fileMergingSnapshotManagerByJobId.get(jobId);
            if (fileMergingSnapshotManager == null) {
                fileMergingSnapshotManager = new FileMergingSnapshotManagerBuilder(jobId.toString()).build();
                this.fileMergingSnapshotManagerByJobId.put(jobId, fileMergingSnapshotManager);
                LOG.info("Registered new file merging snapshot manager for job {}.", (Object)jobId);
            }
            return fileMergingSnapshotManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseMergingSnapshotManagerForJob(@Nonnull JobID jobId) {
        LOG.debug("Releasing file merging snapshot manager under job id {}.", (Object)jobId);
        FileMergingSnapshotManager toRelease = null;
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            toRelease = this.fileMergingSnapshotManagerByJobId.remove(jobId);
        }
        if (toRelease != null) {
            try {
                toRelease.close();
            }
            catch (Exception e) {
                LOG.warn("Exception while closing TaskExecutorFileMergingManager for job {}.", (Object)jobId, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        HashMap<JobID, FileMergingSnapshotManager> toRelease = new HashMap<JobID, FileMergingSnapshotManager>(this.fileMergingSnapshotManagerByJobId);
        Iterator<Map.Entry<JobID, FileMergingSnapshotManager>> iterator = this.lock;
        synchronized (iterator) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.fileMergingSnapshotManagerByJobId.clear();
        }
        LOG.info("Shutting down TaskExecutorFileMergingManager.");
        ShutdownHookUtil.removeShutdownHook((Thread)this.shutdownHook, (String)this.getClass().getSimpleName(), (Logger)LOG);
        for (Map.Entry<JobID, FileMergingSnapshotManager> entry : toRelease.entrySet()) {
            if (entry.getValue() == null) continue;
            try {
                entry.getValue().close();
            }
            catch (Exception e) {
                LOG.warn("Exception while closing TaskExecutorFileMergingManager for job {}.", (Object)entry.getKey(), (Object)e);
            }
        }
    }
}

