/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.adaptivebatch;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.runtime.executiongraph.IndexRange;
import org.apache.flink.runtime.executiongraph.ResultPartitionBytes;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.scheduler.adaptivebatch.AbstractBlockingResultInfo;
import org.apache.flink.util.Preconditions;

public class AllToAllBlockingResultInfo
extends AbstractBlockingResultInfo {
    private final boolean isBroadcast;
    @Nullable
    private List<Long> aggregatedSubpartitionBytes;

    AllToAllBlockingResultInfo(IntermediateDataSetID resultId, int numOfPartitions, int numOfSubpartitions, boolean isBroadcast) {
        super(resultId, numOfPartitions, numOfSubpartitions);
        this.isBroadcast = isBroadcast;
    }

    @Override
    public boolean isBroadcast() {
        return this.isBroadcast;
    }

    @Override
    public boolean isPointwise() {
        return false;
    }

    @Override
    public int getNumPartitions() {
        return this.numOfPartitions;
    }

    @Override
    public int getNumSubpartitions(int partitionIndex) {
        return this.numOfSubpartitions;
    }

    @Override
    public long getNumBytesProduced() {
        Preconditions.checkState((this.aggregatedSubpartitionBytes != null ? 1 : 0) != 0, (Object)"Not all partition infos are ready");
        if (this.isBroadcast) {
            return this.aggregatedSubpartitionBytes.get(0);
        }
        return this.aggregatedSubpartitionBytes.stream().reduce(0L, Long::sum);
    }

    @Override
    public long getNumBytesProduced(IndexRange partitionIndexRange, IndexRange subpartitionIndexRange) {
        Preconditions.checkState((this.aggregatedSubpartitionBytes != null ? 1 : 0) != 0, (Object)"Not all partition infos are ready");
        Preconditions.checkState((partitionIndexRange.getStartIndex() == 0 && partitionIndexRange.getEndIndex() == this.numOfPartitions - 1 ? 1 : 0) != 0, (String)"For All-To-All edges, the partition range should always be [0, %s).", (Object[])new Object[]{this.numOfPartitions});
        Preconditions.checkState((subpartitionIndexRange.getEndIndex() < this.numOfSubpartitions ? 1 : 0) != 0, (String)"Subpartition index %s is out of range.", (Object[])new Object[]{subpartitionIndexRange.getEndIndex()});
        return this.aggregatedSubpartitionBytes.subList(subpartitionIndexRange.getStartIndex(), subpartitionIndexRange.getEndIndex() + 1).stream().reduce(0L, Long::sum);
    }

    @Override
    public void recordPartitionInfo(int partitionIndex, ResultPartitionBytes partitionBytes) {
        if (this.aggregatedSubpartitionBytes == null) {
            super.recordPartitionInfo(partitionIndex, partitionBytes);
            if (this.subpartitionBytesByPartitionIndex.size() == this.numOfPartitions) {
                long[] aggregatedBytes = new long[this.numOfSubpartitions];
                this.subpartitionBytesByPartitionIndex.values().forEach(subpartitionBytes -> {
                    Preconditions.checkState((((long[])subpartitionBytes).length == this.numOfSubpartitions ? 1 : 0) != 0);
                    for (int i = 0; i < ((long[])subpartitionBytes).length; ++i) {
                        int n = i;
                        aggregatedBytes[n] = aggregatedBytes[n] + subpartitionBytes[i];
                    }
                });
                this.aggregatedSubpartitionBytes = Arrays.stream(aggregatedBytes).boxed().collect(Collectors.toList());
                this.subpartitionBytesByPartitionIndex.clear();
            }
        }
    }

    @Override
    public void resetPartitionInfo(int partitionIndex) {
        if (this.aggregatedSubpartitionBytes == null) {
            super.resetPartitionInfo(partitionIndex);
        }
    }

    public List<Long> getAggregatedSubpartitionBytes() {
        Preconditions.checkState((this.aggregatedSubpartitionBytes != null ? 1 : 0) != 0, (Object)"Not all partition infos are ready");
        return Collections.unmodifiableList(this.aggregatedSubpartitionBytes);
    }
}

