/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.api.gax.retrying.RetrySettings;
import com.google.auth.Credentials;
import com.google.auto.value.AutoValue;
import com.google.cloud.ServiceFactory;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import java.io.Serializable;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerConfig;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

@AutoValue
public abstract class SpannerConfig
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_HOST = "https://batch-spanner.googleapis.com/";
    private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_COMMIT_DEADLINE = Duration.standardSeconds((long)15L);
    private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_MAX_CUMULATIVE_BACKOFF = Duration.standardMinutes((long)15L);
    static final // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Options.RpcPriority DEFAULT_RPC_PRIORITY = Options.RpcPriority.MEDIUM;

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getProjectId();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getInstanceId();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getDatabaseId();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getHost();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getEmulatorHost();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> getIsLocalChannelProvider();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> getCommitDeadline();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> getMaxCumulativeBackoff();

    public abstract @Nullable @UnknownKeyFor @Initialized RetrySettings getExecuteStreamingSqlRetrySettings();

    public abstract @Nullable @UnknownKeyFor @Initialized RetrySettings getCommitRetrySettings();

    public abstract @Nullable @UnknownKeyFor @Initialized ImmutableSet<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized StatusCode.Code> getRetryableCodes();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Options.RpcPriority> getRpcPriority();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> getMaxCommitDelay();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getDatabaseRole();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> getPartitionQueryTimeout();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> getPartitionReadTimeout();

    @VisibleForTesting
    abstract @Nullable @UnknownKeyFor @Initialized ServiceFactory<@UnknownKeyFor @NonNull @Initialized Spanner, @UnknownKeyFor @NonNull @Initialized SpannerOptions> getServiceFactory();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> getDataBoostEnabled();

    public abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Credentials> getCredentials();

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    public static @UnknownKeyFor @NonNull @Initialized SpannerConfig create() {
        return SpannerConfig.builder().setHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)DEFAULT_HOST)).setCommitDeadline((ValueProvider<Duration>)ValueProvider.StaticValueProvider.of((Object)DEFAULT_COMMIT_DEADLINE)).setMaxCumulativeBackoff((ValueProvider<Duration>)ValueProvider.StaticValueProvider.of((Object)DEFAULT_MAX_CUMULATIVE_BACKOFF)).setRpcPriority((ValueProvider<Options.RpcPriority>)ValueProvider.StaticValueProvider.of((Object)DEFAULT_RPC_PRIORITY)).build();
    }

    static @UnknownKeyFor @NonNull @Initialized Builder builder() {
        return new AutoValue_SpannerConfig.Builder();
    }

    public void validate() {
        Preconditions.checkNotNull(this.getInstanceId(), (Object)"SpannerIO.read() requires instance id to be set with withInstanceId method");
        Preconditions.checkNotNull(this.getDatabaseId(), (Object)"SpannerIO.read() requires database id to be set with withDatabaseId method");
    }

    public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
        builder.addIfNotNull(DisplayData.item((String)"projectId", this.getProjectId()).withLabel("Output Project")).addIfNotNull(DisplayData.item((String)"instanceId", this.getInstanceId()).withLabel("Output Instance")).addIfNotNull(DisplayData.item((String)"databaseId", this.getDatabaseId()).withLabel("Output Database"));
        if (this.getServiceFactory() != null) {
            builder.addIfNotNull(DisplayData.item((String)"serviceFactory", (String)this.getServiceFactory().getClass().getName()).withLabel("Service Factory"));
        }
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId) {
        return this.toBuilder().setProjectId(projectId).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
        return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withInstanceId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> instanceId) {
        Preconditions.checkNotNull(instanceId, (Object)"withInstanceId(instanceId) called with null input.");
        return this.toBuilder().setInstanceId(instanceId).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withInstanceId(@UnknownKeyFor @NonNull @Initialized String instanceId) {
        return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withDatabaseId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> databaseId) {
        Preconditions.checkNotNull(databaseId, (Object)"withDatabaseId(databaseId) called with null input.");
        return this.toBuilder().setDatabaseId(databaseId).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withDatabaseId(@UnknownKeyFor @NonNull @Initialized String databaseId) {
        return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withHost(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> host) {
        Preconditions.checkNotNull(host, (Object)"withHost(host) called with null input.");
        return this.toBuilder().setHost(host).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withEmulatorHost(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> emulatorHost) {
        return this.toBuilder().setEmulatorHost(emulatorHost).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withIsLocalChannelProvider(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> isLocalChannelProvider) {
        return this.toBuilder().setIsLocalChannelProvider(isLocalChannelProvider).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withCommitDeadline(@UnknownKeyFor @NonNull @Initialized Duration commitDeadline) {
        return this.withCommitDeadline((ValueProvider<Duration>)ValueProvider.StaticValueProvider.of((Object)commitDeadline));
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withCommitDeadline(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> commitDeadline) {
        return this.toBuilder().setCommitDeadline(commitDeadline).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withMaxCumulativeBackoff(@UnknownKeyFor @NonNull @Initialized Duration maxCumulativeBackoff) {
        return this.withMaxCumulativeBackoff((ValueProvider<Duration>)ValueProvider.StaticValueProvider.of((Object)maxCumulativeBackoff));
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withMaxCumulativeBackoff(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> maxCumulativeBackoff) {
        return this.toBuilder().setMaxCumulativeBackoff(maxCumulativeBackoff).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withExecuteStreamingSqlRetrySettings(@UnknownKeyFor @NonNull @Initialized RetrySettings executeStreamingSqlRetrySettings) {
        return this.toBuilder().setExecuteStreamingSqlRetrySettings(executeStreamingSqlRetrySettings).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withCommitRetrySettings(@UnknownKeyFor @NonNull @Initialized RetrySettings commitRetrySettings) {
        return this.toBuilder().setCommitRetrySettings(commitRetrySettings).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withRetryableCodes(@UnknownKeyFor @NonNull @Initialized ImmutableSet<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized StatusCode.Code> retryableCodes) {
        return this.toBuilder().setRetryableCodes(retryableCodes).build();
    }

    @VisibleForTesting
    @UnknownKeyFor @NonNull @Initialized SpannerConfig withServiceFactory(@UnknownKeyFor @NonNull @Initialized ServiceFactory<@UnknownKeyFor @NonNull @Initialized Spanner, @UnknownKeyFor @NonNull @Initialized SpannerOptions> serviceFactory) {
        return this.toBuilder().setServiceFactory(serviceFactory).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withRpcPriority(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Options.RpcPriority rpcPriority) {
        return this.withRpcPriority((ValueProvider<Options.RpcPriority>)ValueProvider.StaticValueProvider.of((Object)rpcPriority));
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withRpcPriority(@UnknownKeyFor @NonNull @Initialized ValueProvider<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Options.RpcPriority> rpcPriority) {
        Preconditions.checkNotNull(rpcPriority, (Object)"withRpcPriority(rpcPriority) called with null input.");
        return this.toBuilder().setRpcPriority(rpcPriority).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withMaxCommitDelay(@UnknownKeyFor @NonNull @Initialized long millis) {
        return this.withMaxCommitDelay(Duration.millis((long)millis));
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withMaxCommitDelay(@UnknownKeyFor @NonNull @Initialized Duration maxCommitDelay) {
        return this.withMaxCommitDelay((ValueProvider<Duration>)ValueProvider.StaticValueProvider.of((Object)maxCommitDelay));
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withMaxCommitDelay(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> maxCommitDelay) {
        Preconditions.checkNotNull(maxCommitDelay, (Object)"withMaxCommitTimeout(maxCommitDelay) called with null input.");
        return this.toBuilder().setMaxCommitDelay(maxCommitDelay).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withDatabaseRole(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> databaseRole) {
        return this.toBuilder().setDatabaseRole(databaseRole).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withDataBoostEnabled(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> dataBoostEnabled) {
        return this.toBuilder().setDataBoostEnabled(dataBoostEnabled).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withPartitionQueryTimeout(@UnknownKeyFor @NonNull @Initialized Duration partitionQueryTimeout) {
        return this.withPartitionQueryTimeout((ValueProvider<Duration>)ValueProvider.StaticValueProvider.of((Object)partitionQueryTimeout));
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withPartitionQueryTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> partitionQueryTimeout) {
        return this.toBuilder().setPartitionQueryTimeout(partitionQueryTimeout).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withPartitionReadTimeout(@UnknownKeyFor @NonNull @Initialized Duration partitionReadTimeout) {
        return this.withPartitionReadTimeout((ValueProvider<Duration>)ValueProvider.StaticValueProvider.of((Object)partitionReadTimeout));
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withPartitionReadTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> partitionReadTimeout) {
        return this.toBuilder().setPartitionReadTimeout(partitionReadTimeout).build();
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withCredentials(@UnknownKeyFor @NonNull @Initialized Credentials credentials) {
        return this.withCredentials((ValueProvider<Credentials>)ValueProvider.StaticValueProvider.of((Object)credentials));
    }

    public @UnknownKeyFor @NonNull @Initialized SpannerConfig withCredentials(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Credentials> credentials) {
        return this.toBuilder().setCredentials(credentials).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract @UnknownKeyFor @NonNull @Initialized Builder setProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setInstanceId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setDatabaseId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setHost(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setEmulatorHost(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setIsLocalChannelProvider(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setCommitDeadline(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxCumulativeBackoff(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setExecuteStreamingSqlRetrySettings(@UnknownKeyFor @NonNull @Initialized RetrySettings var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setCommitRetrySettings(@UnknownKeyFor @NonNull @Initialized RetrySettings var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setRetryableCodes(@UnknownKeyFor @NonNull @Initialized ImmutableSet<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized StatusCode.Code> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setServiceFactory(@UnknownKeyFor @NonNull @Initialized ServiceFactory<@UnknownKeyFor @NonNull @Initialized Spanner, @UnknownKeyFor @NonNull @Initialized SpannerOptions> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setRpcPriority(@UnknownKeyFor @NonNull @Initialized ValueProvider<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Options.RpcPriority> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxCommitDelay(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setDatabaseRole(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setDataBoostEnabled(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Boolean> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setPartitionQueryTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setPartitionReadTimeout(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Duration> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setCredentials(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized Credentials> var1);

        public abstract @UnknownKeyFor @NonNull @Initialized SpannerConfig build();
    }
}

