/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoObject;
import com.azure.core.models.GeoObjectType;
import com.azure.core.models.GeoPosition;
import java.util.Map;
import java.util.Objects;

public final class GeoPoint
extends GeoObject {
    private final GeoPosition coordinates;

    public GeoPoint(double longitude, double latitude) {
        this(longitude, latitude, null);
    }

    public GeoPoint(double longitude, double latitude, Double altitude) {
        this(new GeoPosition(longitude, latitude, altitude));
    }

    public GeoPoint(GeoPosition position) {
        this(position, null, null);
    }

    public GeoPoint(GeoPosition position, GeoBoundingBox boundingBox, Map<String, Object> customProperties) {
        super(boundingBox, customProperties);
        this.coordinates = Objects.requireNonNull(position, "'position' cannot be null.");
    }

    public GeoPosition getCoordinates() {
        return this.coordinates;
    }

    @Override
    public GeoObjectType getType() {
        return GeoObjectType.POINT;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.coordinates, super.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof GeoPoint)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoPoint other = (GeoPoint)obj;
        return super.equals(obj) && Objects.equals(this.coordinates, other.coordinates);
    }
}

