/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.LinkAudience;
import com.dropbox.core.v2.sharing.LinkAudienceDisallowedReason;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LinkAudienceOption {
    @Nonnull
    protected final LinkAudience audience;
    protected final boolean allowed;
    @Nullable
    protected final LinkAudienceDisallowedReason disallowedReason;

    public LinkAudienceOption(@Nonnull LinkAudience audience, boolean allowed, @Nullable LinkAudienceDisallowedReason disallowedReason) {
        if (audience == null) {
            throw new IllegalArgumentException("Required value for 'audience' is null");
        }
        this.audience = audience;
        this.allowed = allowed;
        this.disallowedReason = disallowedReason;
    }

    public LinkAudienceOption(@Nonnull LinkAudience audience, boolean allowed) {
        this(audience, allowed, null);
    }

    @Nonnull
    public LinkAudience getAudience() {
        return this.audience;
    }

    public boolean getAllowed() {
        return this.allowed;
    }

    @Nullable
    public LinkAudienceDisallowedReason getDisallowedReason() {
        return this.disallowedReason;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.audience, this.allowed, this.disallowedReason});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            LinkAudienceOption other = (LinkAudienceOption)obj;
            return (this.audience == other.audience || this.audience.equals((Object)other.audience)) && this.allowed == other.allowed && (this.disallowedReason == other.disallowedReason || this.disallowedReason != null && this.disallowedReason.equals((Object)other.disallowedReason));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<LinkAudienceOption> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(LinkAudienceOption value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("audience");
            LinkAudience.Serializer.INSTANCE.serialize(value.audience, g);
            g.writeFieldName("allowed");
            StoneSerializers.boolean_().serialize((Boolean)value.allowed, g);
            if (value.disallowedReason != null) {
                g.writeFieldName("disallowed_reason");
                StoneSerializers.nullable(LinkAudienceDisallowedReason.Serializer.INSTANCE).serialize(value.disallowedReason, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public LinkAudienceOption deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            LinkAudienceDisallowedReason f_disallowedReason;
            Boolean f_allowed;
            LinkAudience f_audience;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_audience = null;
                f_allowed = null;
                f_disallowedReason = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("audience".equals(field)) {
                        f_audience = LinkAudience.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("allowed".equals(field)) {
                        f_allowed = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("disallowed_reason".equals(field)) {
                        f_disallowedReason = StoneSerializers.nullable(LinkAudienceDisallowedReason.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_audience == null) {
                    throw new JsonParseException(p, "Required field \"audience\" missing.");
                }
                if (f_allowed == null) {
                    throw new JsonParseException(p, "Required field \"allowed\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            LinkAudienceOption value = new LinkAudienceOption(f_audience, f_allowed, f_disallowedReason);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

