/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.perspective.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;
import org.apache.hop.core.gui.plugin.toolbar.GuiToolbarElement;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.util.TranslateUtil;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadata;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.plugin.MetadataPluginType;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.metadata.util.HopMetadataUtil;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.bus.HopGuiEvents;
import org.apache.hop.ui.core.dialog.EnterStringDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.ShowMessageDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.GuiToolbarWidgets;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataFileType;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.core.widget.TabFolderReorder;
import org.apache.hop.ui.core.widget.TreeMemory;
import org.apache.hop.ui.core.widget.TreeUtil;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.HopGuiKeyHandler;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.file.empty.EmptyFileType;
import org.apache.hop.ui.hopgui.file.empty.EmptyHopFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.HopPerspectivePlugin;
import org.apache.hop.ui.hopgui.perspective.IHopPerspective;
import org.apache.hop.ui.hopgui.perspective.TabClosable;
import org.apache.hop.ui.hopgui.perspective.TabCloseHandler;
import org.apache.hop.ui.hopgui.perspective.TabItemHandler;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.util.HelpUtils;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

@HopPerspectivePlugin(id="200-HopMetadataPerspective", name="i18n::MetadataPerspective.Name", description="i18n::MetadataPerspective.Description", image="ui/images/metadata.svg", documentationUrl="/hop-gui/perspective-metadata.html")
@GuiPlugin(description="i18n::MetadataPerspective.GuiPlugin.Description")
public class MetadataPerspective
implements IHopPerspective,
TabClosable {
    public static final Class<?> PKG = MetadataPerspective.class;
    private static final String METADATA_PERSPECTIVE_TREE = "Metadata perspective tree";
    public static final String GUI_PLUGIN_TOOLBAR_PARENT_ID = "MetadataPerspective-Toolbar";
    public static final String TOOLBAR_ITEM_NEW = "MetadataPerspective-Toolbar-10000-New";
    public static final String TOOLBAR_ITEM_EDIT = "MetadataPerspective-Toolbar-10010-Edit";
    public static final String TOOLBAR_ITEM_DUPLICATE = "MetadataPerspective-Toolbar-10030-Duplicate";
    public static final String TOOLBAR_ITEM_DELETE = "MetadataPerspective-Toolbar-10040-Delete";
    public static final String TOOLBAR_ITEM_RENAME = "MetadataPerspective-Toolbar-10020-Rename";
    public static final String TOOLBAR_ITEM_REFRESH = "MetadataPerspective-Toolbar-10100-Refresh";
    private static final String KEY_HELP = "Help";
    private static final String KEY_TYPE = "type";
    public static final String FILE = "File";
    public static final String FOLDER = "Folder";
    public static final String VIRTUAL_PATH = "virtualPath";
    public static final String ERROR = "Error";
    private static MetadataPerspective instance;
    private HopGui hopGui;
    private SashForm sash;
    private Tree tree;
    private TreeEditor treeEditor;
    private CTabFolder tabFolder;
    private GuiToolbarWidgets toolBarWidgets;
    private final List<MetadataEditor<?>> editors = new ArrayList();
    private final MetadataFileType metadataFileType;

    public MetadataPerspective() {
        instance = this;
        this.metadataFileType = new MetadataFileType();
    }

    @Override
    public String getId() {
        return "metadata-perspective";
    }

    @Override
    @GuiKeyboardShortcut(control=true, shift=true, key=109)
    @GuiOsxKeyboardShortcut(command=true, shift=true, key=109)
    public void activate() {
        this.hopGui.setActivePerspective(this);
    }

    @Override
    public void perspectiveActivated() {
        this.updateSelection();
        this.updateGui();
    }

    @Override
    public boolean isActive() {
        return this.hopGui.isActivePerspective(this);
    }

    @Override
    public List<IHopFileType> getSupportedHopFileTypes() {
        return Arrays.asList(this.metadataFileType);
    }

    @Override
    public void initialize(HopGui hopGui, Composite parent) {
        this.hopGui = hopGui;
        this.sash = new SashForm(parent, 256);
        FormData fdSash = new FormData();
        fdSash.left = new FormAttachment(0, 0);
        fdSash.top = new FormAttachment(0, 0);
        fdSash.right = new FormAttachment(100, 0);
        fdSash.bottom = new FormAttachment(100, 0);
        this.sash.setLayoutData((Object)fdSash);
        this.createTree((Composite)this.sash);
        this.createTabFolder((Composite)this.sash);
        this.sash.setWeights(new int[]{20, 80});
        this.refresh();
        this.updateSelection();
        for (TreeItem item : this.tree.getItems()) {
            TreeMemory.getInstance().storeExpanded(METADATA_PERSPECTIVE_TREE, item, true);
        }
        hopGui.getEventsHandler().addEventListener(this.getClass().getName(), e -> this.refresh(), HopGuiEvents.MetadataChanged.name());
        HopGuiKeyHandler.getInstance().addParentObjectToHandle(this);
    }

    protected MetadataManager<IHopMetadata> getMetadataManager(String objectKey) throws HopException {
        MultiMetadataProvider metadataProvider = this.hopGui.getMetadataProvider();
        Class metadataClass = metadataProvider.getMetadataClassForKey(objectKey);
        return new MetadataManager<IHopMetadata>(HopGui.getInstance().getVariables(), (IHopMetadataProvider)metadataProvider, metadataClass, this.hopGui.getShell());
    }

    protected void createTree(Composite parent) {
        Composite composite = new Composite(parent, 2048);
        FormLayout layout = new FormLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        ToolBar toolBar = new ToolBar(composite, 16704);
        this.toolBarWidgets = new GuiToolbarWidgets();
        this.toolBarWidgets.registerGuiPluginObject(this);
        this.toolBarWidgets.createToolbarWidgets((Composite)toolBar, GUI_PLUGIN_TOOLBAR_PARENT_ID);
        FormData layoutData = new FormData();
        layoutData.left = new FormAttachment(0, 0);
        layoutData.top = new FormAttachment(0, 0);
        layoutData.right = new FormAttachment(100, 0);
        toolBar.setLayoutData((Object)layoutData);
        toolBar.pack();
        PropsUi.setLook((Widget)toolBar, 5);
        this.tree = new Tree(composite, 772);
        this.tree.setHeaderVisible(false);
        this.tree.addListener(13, event -> this.updateSelection());
        this.tree.addListener(14, event -> {
            TreeItem treeItem = this.tree.getSelection()[0];
            if (treeItem != null && treeItem.getData(KEY_TYPE).equals(FILE)) {
                if (treeItem.getParentItem() == null) {
                    this.onNewMetadata();
                } else {
                    this.onEditMetadata();
                }
            }
        });
        this.tree.addMenuDetectListener(event -> {
            if (this.tree.getSelectionCount() < 1) {
                return;
            }
            TreeItem treeItem = this.tree.getSelection()[0];
            if (treeItem != null) {
                MenuItem menuItem;
                Menu menu = new Menu((Control)this.tree);
                switch ((String)treeItem.getData(KEY_TYPE)) {
                    case "MetadataItem": 
                    case "Folder": {
                        menuItem = new MenuItem(menu, 8);
                        menuItem.setText(BaseMessages.getString(PKG, (String)"MetadataPerspective.Menu.New", (String[])new String[0]));
                        menuItem.addListener(13, e -> this.onNewMetadata());
                        menuItem = new MenuItem(menu, 8);
                        menuItem.setText(BaseMessages.getString(PKG, (String)"MetadataPerspective.Menu.NewFolder", (String[])new String[0]));
                        menuItem.addListener(13, e -> this.createNewFolder());
                        new MenuItem(menu, 2);
                        break;
                    }
                    case "File": {
                        menuItem = new MenuItem(menu, 8);
                        menuItem.setText(BaseMessages.getString(PKG, (String)"MetadataPerspective.Menu.Edit", (String[])new String[0]));
                        menuItem.setImage(GuiResource.getInstance().getImageEdit());
                        menuItem.addListener(13, e -> this.onEditMetadata());
                        menuItem = new MenuItem(menu, 8);
                        menuItem.setText(BaseMessages.getString(PKG, (String)"MetadataPerspective.Menu.Rename", (String[])new String[0]));
                        menuItem.setImage(GuiResource.getInstance().getImageRename());
                        menuItem.addListener(13, e -> this.onRenameMetadata());
                        menuItem = new MenuItem(menu, 8);
                        menuItem.setText(BaseMessages.getString(PKG, (String)"MetadataPerspective.Menu.Duplicate", (String[])new String[0]));
                        menuItem.setImage(GuiResource.getInstance().getImageDuplicate());
                        menuItem.addListener(13, e -> this.duplicateMetadata());
                        new MenuItem(menu, 2);
                        menuItem = new MenuItem(menu, 8);
                        menuItem.setText(BaseMessages.getString(PKG, (String)"MetadataPerspective.Menu.Delete", (String[])new String[0]));
                        menuItem.setImage(GuiResource.getInstance().getImageDelete());
                        menuItem.addListener(13, e -> this.onDeleteMetadata());
                        new MenuItem(menu, 2);
                        break;
                    }
                }
                menuItem = new MenuItem(menu, 8);
                menuItem.setText(BaseMessages.getString(PKG, (String)"MetadataPerspective.Menu.Help", (String[])new String[0]));
                menuItem.setImage(GuiResource.getInstance().getImageHelp());
                menuItem.addListener(13, e -> this.onHelpMetadata());
                this.tree.setMenu(menu);
                menu.setVisible(true);
            }
        });
        PropsUi.setLook((Widget)this.tree);
        FormData treeFormData = new FormData();
        treeFormData.left = new FormAttachment(0, 0);
        treeFormData.top = new FormAttachment((Control)toolBar, 0);
        treeFormData.right = new FormAttachment(100, 0);
        treeFormData.bottom = new FormAttachment(100, 0);
        this.tree.setLayoutData((Object)treeFormData);
        this.treeEditor = new TreeEditor(this.tree);
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
        TreeMemory.addTreeListener(this.tree, METADATA_PERSPECTIVE_TREE);
    }

    protected void createTabFolder(Composite parent) {
        this.tabFolder = new CTabFolder(parent, 2050);
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                MetadataPerspective.this.onTabClose(event);
            }
        });
        this.tabFolder.addListener(13, event -> this.updateGui());
        PropsUi.setLook((Widget)this.tabFolder, 4);
        ToolBar tabToolBar = new ToolBar((Composite)this.tabFolder, 0x800000);
        ToolItem item = new ToolItem(tabToolBar, 8);
        item.setImage(GuiResource.getInstance().getImageMinimizePanel());
        item.addListener(13, e -> {
            if (this.sash.getMaximizedControl() == null) {
                this.sash.setMaximizedControl((Control)this.tabFolder);
                item.setImage(GuiResource.getInstance().getImageMaximizePanel());
            } else {
                this.sash.setMaximizedControl(null);
                item.setImage(GuiResource.getInstance().getImageMinimizePanel());
            }
        });
        this.tabFolder.setTopRight((Control)tabToolBar, 131072);
        new TabCloseHandler(this);
        new TabFolderReorder(this.tabFolder);
    }

    public void addEditor(MetadataEditor<?> editor) {
        CTabItem tabItem = new CTabItem(this.tabFolder, 64);
        tabItem.setFont(GuiResource.getInstance().getFontDefault());
        tabItem.setText(editor.getTitle());
        tabItem.setImage(editor.getTitleImage());
        tabItem.setToolTipText(editor.getTitleToolTip());
        Composite composite = new Composite((Composite)this.tabFolder, 0);
        FormLayout layoutComposite = new FormLayout();
        layoutComposite.marginWidth = PropsUi.getFormMargin();
        layoutComposite.marginHeight = PropsUi.getFormMargin();
        composite.setLayout((Layout)layoutComposite);
        PropsUi.setLook((Widget)composite);
        Button[] buttons = editor.createButtonsForButtonBar(composite);
        if (buttons != null) {
            BaseTransformDialog.positionBottomButtons(composite, buttons, PropsUi.getMargin(), null);
        }
        Composite area = new Composite(composite, 0);
        FormLayout layoutArea = new FormLayout();
        layoutArea.marginWidth = 0;
        layoutArea.marginHeight = 0;
        area.setLayout((Layout)layoutArea);
        FormData fdArea = new FormData();
        fdArea.left = new FormAttachment(0, 0);
        fdArea.top = new FormAttachment(0, 0);
        fdArea.right = new FormAttachment(100, 0);
        fdArea.bottom = buttons != null ? new FormAttachment((Control)buttons[0], -PropsUi.getMargin()) : new FormAttachment(100, -PropsUi.getMargin());
        area.setLayoutData((Object)fdArea);
        PropsUi.setLook((Widget)area);
        editor.createControl(area);
        tabItem.setControl((Control)composite);
        tabItem.setData(editor);
        this.editors.add(editor);
        HopGuiKeyHandler keyHandler = HopGuiKeyHandler.getInstance();
        keyHandler.addParentObjectToHandle(this);
        HopGui.getInstance().replaceKeyboardShortcutListeners((Control)this.getShell(), keyHandler);
        this.activate();
        this.tabFolder.setSelection(tabItem);
        editor.setFocus();
    }

    public MetadataEditor<?> findEditor(String objectKey, String name) {
        if (objectKey == null || name == null) {
            return null;
        }
        for (MetadataEditor<?> editor : this.editors) {
            Object metadata = editor.getMetadata();
            HopMetadata annotation = HopMetadataUtil.getHopMetadataAnnotation(metadata.getClass());
            if (annotation == null || !annotation.key().equals(objectKey) || !name.equals(metadata.getName())) continue;
            return editor;
        }
        return null;
    }

    public void setActiveEditor(MetadataEditor<?> editor) {
        for (CTabItem item : this.tabFolder.getItems()) {
            if (!item.getData().equals(editor)) continue;
            this.tabFolder.setSelection(item);
            this.tabFolder.showItem(item);
            editor.setFocus();
            HopGui.getInstance().handleFileCapabilities(this.metadataFileType, editor.hasChanged(), false, false);
        }
    }

    public MetadataEditor<?> getActiveEditor() {
        if (this.tabFolder.getSelectionIndex() < 0) {
            return null;
        }
        return (MetadataEditor)this.tabFolder.getSelection().getData();
    }

    @Override
    public IHopFileTypeHandler getActiveFileTypeHandler() {
        MetadataEditor<?> editor = this.getActiveEditor();
        if (editor != null) {
            return editor;
        }
        return new EmptyHopFileTypeHandler();
    }

    @Override
    public void setActiveFileTypeHandler(IHopFileTypeHandler fileTypeHandler) {
        if (fileTypeHandler instanceof MetadataEditor) {
            this.setActiveEditor((MetadataEditor)fileTypeHandler);
        }
    }

    protected void onTabClose(CTabFolderEvent event) {
        CTabItem tabItem = (CTabItem)event.item;
        this.closeTab(event, tabItem);
    }

    @GuiToolbarElement(root="MetadataPerspective-Toolbar", id="MetadataPerspective-Toolbar-10000-New", toolTip="i18n::MetadataPerspective.ToolbarElement.New.Tooltip", image="ui/images/new.svg")
    public void onNewMetadata() {
        if (this.tree.getSelectionCount() != 1) {
            return;
        }
        TreeItem treeItem = this.tree.getSelection()[0];
        if (treeItem != null) {
            String objectKey = treeItem.getParentItem() == null ? (String)treeItem.getData() : (String)treeItem.getParentItem().getData();
            try {
                MultiMetadataProvider metadataProvider = this.hopGui.getMetadataProvider();
                Class metadataClass = metadataProvider.getMetadataClassForKey(objectKey);
                MetadataManager manager = new MetadataManager(HopGui.getInstance().getVariables(), (IHopMetadataProvider)metadataProvider, metadataClass, this.hopGui.getShell());
                manager.newMetadataWithEditor((String)treeItem.getData(VIRTUAL_PATH));
                this.hopGui.getEventsHandler().fire(HopGuiEvents.MetadataCreated.name());
            }
            catch (Exception e) {
                new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"MetadataPerspective.CreateMetadata.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetadataPerspective.CreateMetadata.Error.Message", (String[])new String[0]), e);
            }
        }
        this.refresh();
    }

    @GuiToolbarElement(root="MetadataPerspective-Toolbar", id="MetadataPerspective-Toolbar-10010-Edit", toolTip="i18n::MetadataPerspective.ToolbarElement.Edit.Tooltip", image="ui/images/edit.svg")
    @GuiKeyboardShortcut(key=0x100000C)
    @GuiOsxKeyboardShortcut(key=0x100000C)
    public void onEditMetadata() {
        if (this.tree.getSelectionCount() != 1) {
            return;
        }
        TreeItem treeItem = this.tree.getSelection()[0];
        if (treeItem.getData(KEY_TYPE).equals(FILE)) {
            String objectName;
            String objectKey = (String)treeItem.getParentItem().getData();
            MetadataEditor<?> editor = this.findEditor(objectKey, objectName = treeItem.getText(0));
            if (editor != null) {
                this.setActiveEditor(editor);
            } else {
                try {
                    MetadataManager<IHopMetadata> manager = this.getMetadataManager(objectKey);
                    manager.editWithEditor(objectName);
                    this.hopGui.getEventsHandler().fire(HopGuiEvents.MetadataChanged.name());
                }
                catch (Exception e) {
                    new ErrorDialog(this.getShell(), ERROR, "Error editing metadata", e);
                }
            }
            this.updateSelection();
        }
    }

    @GuiToolbarElement(root="MetadataPerspective-Toolbar", id="MetadataPerspective-Toolbar-10020-Rename", toolTip="i18n::MetadataPerspective.ToolbarElement.Rename.Tooltip", image="ui/images/rename.svg")
    @GuiKeyboardShortcut(key=0x100000B)
    @GuiOsxKeyboardShortcut(key=0x100000B)
    public void onRenameMetadata() {
        if (this.tree.getSelectionCount() < 1) {
            return;
        }
        TreeItem item = this.tree.getSelection()[0];
        if (item != null) {
            if (item.getParentItem() == null) {
                return;
            }
            String objectKey = (String)item.getParentItem().getData();
            String objectName = item.getText(0);
            Text text = new Text((Composite)this.tree, 2048);
            text.setText(item.getText());
            text.addListener(16, event -> text.dispose());
            text.addListener(2, event -> {
                switch (event.keyCode) {
                    case 13: 
                    case 0x1000050: {
                        if (objectName.equals(text.getText())) break;
                        try {
                            MetadataManager<IHopMetadata> manager = this.getMetadataManager(objectKey);
                            if (manager.rename(objectName, text.getText())) {
                                text.dispose();
                            }
                            this.hopGui.getEventsHandler().fire(HopGuiEvents.MetadataChanged.name());
                        }
                        catch (Exception e) {
                            new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"MetadataPerspective.EditMetadata.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetadataPerspective.EditMetadata.Error.Message", (String[])new String[0]), e);
                        }
                        break;
                    }
                    case 27: {
                        text.dispose();
                        break;
                    }
                }
            });
            text.selectAll();
            text.setFocus();
            PropsUi.setLook((Widget)text);
            this.treeEditor.setEditor((Control)text, item);
        }
    }

    @GuiToolbarElement(root="MetadataPerspective-Toolbar", id="MetadataPerspective-Toolbar-10040-Delete", toolTip="i18n::MetadataPerspective.ToolbarElement.Delete.Tooltip", image="ui/images/delete.svg")
    @GuiKeyboardShortcut(key=127)
    @GuiOsxKeyboardShortcut(key=127)
    public void onDeleteMetadata() {
        if (this.tree.getSelectionCount() != 1) {
            return;
        }
        TreeItem treeItem = this.tree.getSelection()[0];
        if (treeItem.getData(KEY_TYPE).equals(FILE)) {
            String objectKey = (String)treeItem.getParentItem().getData();
            String objectName = treeItem.getText(0);
            try {
                MetadataManager<IHopMetadata> manager = this.getMetadataManager(objectKey);
                manager.deleteMetadata(objectName);
                this.refresh();
                this.updateSelection();
                this.hopGui.getEventsHandler().fire(HopGuiEvents.MetadataDeleted.name());
            }
            catch (Exception e) {
                new ErrorDialog(this.getShell(), ERROR, "Error delete metadata", e);
            }
        }
    }

    @GuiToolbarElement(root="MetadataPerspective-Toolbar", id="MetadataPerspective-Toolbar-10030-Duplicate", toolTip="i18n::MetadataPerspective.ToolbarElement.CreateCopy.Tooltip", image="ui/images/duplicate.svg")
    public void duplicateMetadata() {
        if (this.tree.getSelectionCount() != 1) {
            return;
        }
        TreeItem treeItem = this.tree.getSelection()[0];
        if (treeItem.getData(KEY_TYPE).equals(FILE)) {
            String objectKey = (String)treeItem.getParentItem().getData();
            String objectName = treeItem.getText(0);
            try {
                String newName;
                MetadataManager<IHopMetadata> manager = this.getMetadataManager(objectKey);
                IHopMetadata metadata = manager.loadElement(objectName);
                int copyNr = 2;
                while (true) {
                    newName = objectName + " " + copyNr;
                    if (!manager.getSerializer().exists(newName)) break;
                    ++copyNr;
                }
                metadata.setName(newName);
                manager.getSerializer().save(metadata);
                this.refresh();
                this.hopGui.getEventsHandler().fire(HopGuiEvents.MetadataCreated.name());
            }
            catch (Exception e) {
                new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"MetadataPerspective.DuplicateMetadata.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetadataPerspective.DuplicateMetadata.Error.Message", (String[])new String[0]), e);
            }
        }
    }

    public void onHelpMetadata() {
        if (this.tree.getSelectionCount() != 1) {
            return;
        }
        String objectKey = null;
        TreeItem treeItem = this.tree.getSelection()[0];
        if (treeItem != null) {
            if (treeItem.getParentItem() != null) {
                treeItem = treeItem.getParentItem();
            }
            objectKey = (String)treeItem.getData();
        }
        if (objectKey != null) {
            try {
                MetadataManager<IHopMetadata> manager = this.getMetadataManager(objectKey);
                HopMetadata annotation = manager.getManagedClass().getAnnotation(HopMetadata.class);
                IPlugin plugin = PluginRegistry.getInstance().getPlugin(MetadataPluginType.class, annotation.key());
                HelpUtils.openHelp(this.getShell(), plugin);
            }
            catch (Exception ex) {
                new ErrorDialog(this.getShell(), ERROR, "Error opening URL", ex);
            }
        }
    }

    public void updateEditor(MetadataEditor<?> editor) {
        if (editor == null) {
            return;
        }
        for (CTabItem item : this.tabFolder.getItems()) {
            if (!editor.equals(item.getData())) continue;
            item.setText(editor.getTitle());
            if (editor.hasChanged()) {
                item.setFont(GuiResource.getInstance().getFontBold());
                break;
            }
            item.setFont(this.tabFolder.getFont());
            break;
        }
        this.refresh();
        this.updateGui();
    }

    public void updateGui() {
        IHopFileTypeHandler activeHandler = this.getActiveFileTypeHandler();
        activeHandler.updateGui();
    }

    @GuiToolbarElement(root="MetadataPerspective-Toolbar", id="MetadataPerspective-Toolbar-10100-Refresh", toolTip="i18n::MetadataPerspective.ToolbarElement.Refresh.Tooltip", image="ui/images/refresh.svg")
    @GuiKeyboardShortcut(key=0x100000E)
    @GuiOsxKeyboardShortcut(key=0x100000E)
    public void refresh() {
        try {
            this.tree.setRedraw(false);
            this.tree.removeAll();
            MultiMetadataProvider metadataProvider = this.hopGui.getMetadataProvider();
            List metadataClasses = metadataProvider.getMetadataClasses();
            Collections.sort(metadataClasses, (cl1, cl2) -> {
                HopMetadata a1 = HopMetadataUtil.getHopMetadataAnnotation((Class)cl1);
                HopMetadata a2 = HopMetadataUtil.getHopMetadataAnnotation((Class)cl2);
                return a1.name().compareTo(a2.name());
            });
            for (Class metadataClass : metadataClasses) {
                HopMetadata annotation = HopMetadataUtil.getHopMetadataAnnotation((Class)metadataClass);
                Image image = GuiResource.getInstance().getImage(annotation.image(), metadataClass.getClassLoader(), 16, 16);
                TreeItem classItem = new TreeItem(this.tree, 0);
                classItem.setText(0, Const.NVL((String)TranslateUtil.translate((String)annotation.name(), (Class)metadataClass), (String)""));
                classItem.setImage(image);
                classItem.setExpanded(true);
                classItem.setData((Object)annotation.key());
                classItem.setData(KEY_HELP, (Object)annotation.description());
                classItem.setData(VIRTUAL_PATH, (Object)"");
                classItem.setData(KEY_TYPE, (Object)"MetadataItem");
                IHopMetadataSerializer serializer = metadataProvider.getSerializer(metadataClass);
                List names = serializer.listObjectNames();
                Collections.sort(names);
                for (String name : names) {
                    IHopMetadata hopMetadata;
                    try {
                        hopMetadata = serializer.load(name);
                    }
                    catch (HopException e) {
                        LogChannel.GENERAL.logError("Error loading metadata object:" + name);
                        continue;
                    }
                    TreeItem parentItem = classItem;
                    if (hopMetadata.getVirtualPath() != null && !hopMetadata.getVirtualPath().isEmpty()) {
                        ArrayList<String> folders = new ArrayList<String>(Arrays.asList(hopMetadata.getVirtualPath().split("/")));
                        folders.removeAll(Arrays.asList("", null));
                        for (String folder : folders) {
                            TreeItem alreadyExists = null;
                            if (folder.isEmpty()) continue;
                            alreadyExists = null;
                            for (TreeItem childItem : parentItem.getItems()) {
                                if (!childItem.getData(KEY_TYPE).equals(FOLDER) || !childItem.getText().equals(folder)) continue;
                                alreadyExists = childItem;
                            }
                            if (alreadyExists != null) {
                                parentItem = alreadyExists;
                                continue;
                            }
                            TreeItem folderItem = new TreeItem(parentItem, 0);
                            folderItem.setText(folder);
                            folderItem.setData((Object)annotation.key());
                            folderItem.setImage(GuiResource.getInstance().getImageFolder());
                            folderItem.setData(VIRTUAL_PATH, (Object)(String.valueOf(folderItem.getParentItem().getData(VIRTUAL_PATH)) + "/" + folder));
                            folderItem.setData(KEY_TYPE, (Object)FOLDER);
                            parentItem = folderItem;
                        }
                    }
                    TreeItem item = new TreeItem(parentItem, 0);
                    item.setText(0, Const.NVL((String)name, (String)""));
                    item.setData(VIRTUAL_PATH, parentItem.getData(VIRTUAL_PATH));
                    item.setData(KEY_TYPE, (Object)FILE);
                    MetadataEditor<?> editor = this.findEditor(annotation.key(), name);
                    if (editor == null || !editor.hasChanged()) continue;
                    item.setFont(GuiResource.getInstance().getFontBold());
                }
            }
            TreeUtil.setOptimalWidthOnColumns(this.tree);
            TreeMemory.setExpandedFromMemory(this.tree, METADATA_PERSPECTIVE_TREE);
            this.tree.setRedraw(true);
            this.updateGui();
        }
        catch (Exception e) {
            new ErrorDialog(this.getShell(), BaseMessages.getString(PKG, (String)"MetadataPerspective.RefreshMetadata.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetadataPerspective.RefreshMetadata.Error.Message", (String[])new String[0]), e);
        }
    }

    protected void updateSelection() {
        TreeItem treeItem;
        boolean isMetadataSelected = false;
        if (this.tree.getSelectionCount() > 0 && (treeItem = this.tree.getSelection()[0]).getData(KEY_TYPE).equals(FILE)) {
            isMetadataSelected = true;
        }
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_EDIT, isMetadataSelected);
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_RENAME, isMetadataSelected);
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_DUPLICATE, isMetadataSelected);
        this.toolBarWidgets.enableToolbarItem(TOOLBAR_ITEM_DELETE, isMetadataSelected);
    }

    @Override
    public boolean remove(IHopFileTypeHandler typeHandler) {
        MetadataEditor editor;
        if (typeHandler instanceof MetadataEditor && (editor = (MetadataEditor)typeHandler).isCloseable()) {
            this.editors.remove(editor);
            for (CTabItem item : this.tabFolder.getItems()) {
                if (!editor.equals(item.getData())) continue;
                item.dispose();
            }
            this.refresh();
            this.updateGui();
        }
        return false;
    }

    @Override
    public List<TabItemHandler> getItems() {
        ArrayList<TabItemHandler> items = new ArrayList<TabItemHandler>();
        for (CTabItem tabItem : this.tabFolder.getItems()) {
            for (MetadataEditor<?> editor : this.editors) {
                if (!tabItem.getData().equals(editor)) continue;
                items.add(new TabItemHandler(tabItem, editor));
            }
        }
        return items;
    }

    @Override
    public void navigateToPreviousFile() {
        if (this.hasNavigationPreviousFile()) {
            int index = this.tabFolder.getSelectionIndex() - 1;
            if (index < 0) {
                index = this.tabFolder.getItemCount() - 1;
            }
            this.tabFolder.setSelection(index);
            this.updateGui();
        }
    }

    @Override
    public void navigateToNextFile() {
        if (this.hasNavigationNextFile()) {
            int index = this.tabFolder.getSelectionIndex() + 1;
            if (index >= this.tabFolder.getItemCount()) {
                index = 0;
            }
            this.tabFolder.setSelection(index);
            this.updateGui();
        }
    }

    @Override
    public boolean hasNavigationPreviousFile() {
        return this.tabFolder.getItemCount() > 1;
    }

    @Override
    public boolean hasNavigationNextFile() {
        return this.tabFolder.getItemCount() > 1;
    }

    @Override
    public Control getControl() {
        return this.sash;
    }

    protected Shell getShell() {
        return this.hopGui.getShell();
    }

    @Override
    public List<IGuiContextHandler> getContextHandlers() {
        return new ArrayList<IGuiContextHandler>();
    }

    @Override
    public List<ISearchable> getSearchables() {
        return new ArrayList<ISearchable>();
    }

    @Override
    public void closeTab(CTabFolderEvent event, CTabItem tabItem) {
        MetadataEditor editor = (MetadataEditor)tabItem.getData();
        boolean isRemoved = this.remove(editor);
        if (!isRemoved && event != null) {
            event.doit = false;
            return;
        }
        if (this.tabFolder.getItemCount() == 0) {
            HopGui.getInstance().handleFileCapabilities(new EmptyFileType(), false, false, false);
        }
    }

    @Override
    public CTabFolder getTabFolder() {
        return this.tabFolder;
    }

    private String getKeyOfMetadataClass(Class<? extends IHopMetadata> managedClass) {
        HopMetadata annotation = managedClass.getAnnotation(HopMetadata.class);
        assert (annotation != null) : "Metadata classes need to be annotated with @HopMetadata";
        return annotation.key();
    }

    public void goToType(Class<? extends IHopMetadata> managedClass) {
        String key = this.getKeyOfMetadataClass(managedClass);
        for (TreeItem item : this.tree.getItems()) {
            String classKey = (String)item.getData();
            if (!key.equals(classKey)) continue;
            this.tree.setSelection(item);
            this.tree.showSelection();
            return;
        }
    }

    public void goToElement(Class<? extends IHopMetadata> managedClass, String elementName) {
        String key = this.getKeyOfMetadataClass(managedClass);
        for (TreeItem item : this.tree.getItems()) {
            String classKey = (String)item.getData();
            if (!key.equals(classKey)) continue;
            for (TreeItem elementItem : item.getItems()) {
                if (!elementName.equals(elementItem.getText())) continue;
                this.tree.setSelection(elementItem);
                this.tree.showSelection();
                this.onEditMetadata();
                return;
            }
            this.goToType(managedClass);
        }
    }

    public void createNewFolder() {
        TreeItem[] selection = this.tree.getSelection();
        if (selection == null || selection.length == 0) {
            return;
        }
        TreeItem item = selection[0];
        EnterStringDialog dialog = new EnterStringDialog(this.getShell(), "", BaseMessages.getString(PKG, (String)"MetadataPerspective.CreateFolder.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetadataPerspective.CreateFolder.Message", (String[])new String[]{((String)item.getData(VIRTUAL_PATH)).isEmpty() ? item.getText() : (String)item.getData(VIRTUAL_PATH)}));
        String folder = dialog.open();
        if (folder != null && !folder.isEmpty()) {
            for (TreeItem treeItem : item.getItems()) {
                if (!folder.equals(treeItem.getText()) || !treeItem.getData(KEY_TYPE).equals(FOLDER)) continue;
                ShowMessageDialog msgDialog = new ShowMessageDialog(this.getShell(), 34, BaseMessages.getString(PKG, (String)"MetadataPerspective.CreateFolder.Error.Header", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetadataPerspective.CreateFolder.Error.Message", (String[])new String[0]), false);
                msgDialog.open();
                return;
            }
            TreeItem newFolder = new TreeItem(item, 0);
            newFolder.setText(folder);
            newFolder.setData(item.getData());
            newFolder.setImage(GuiResource.getInstance().getImageFolder());
            newFolder.setData(VIRTUAL_PATH, (Object)(String.valueOf(item.getData(VIRTUAL_PATH)) + "/" + folder));
            newFolder.setData(KEY_TYPE, (Object)FOLDER);
            TreeItem emptyString = new TreeItem(newFolder, 0);
            emptyString.setText(BaseMessages.getString(PKG, (String)"MetadataPerspective.CreateFolder.EmptyFolder", (String[])new String[0]));
            emptyString.setData(KEY_TYPE, (Object)"Label");
            emptyString.setForeground(this.tree.getDisplay().getSystemColor(15));
            newFolder.setExpanded(true);
        }
    }

    @Generated
    public static MetadataPerspective getInstance() {
        return instance;
    }
}

