/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.deletefiles;

import java.util.ArrayList;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.actions.deletefiles.ActionDeleteFiles;
import org.apache.hop.workflow.actions.deletefiles.FileItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ActionDeleteFilesDialog
extends ActionDialog {
    private static final Class<?> PKG = ActionDeleteFiles.class;
    private static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])};
    private Text wName;
    private Button wIncludeSubfolders;
    private ActionDeleteFiles action;
    private boolean changed;
    private Button wPrevious;
    private Label wlFields;
    private TableView wFields;

    public ActionDeleteFilesDialog(Shell parent, ActionDeleteFiles action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.Name.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wName);
        this.wName.addListener(24, event -> this.action.setChanged());
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Group wSettings = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wSettings);
        wSettings.setText(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.Settings.Label", (String[])new String[0]));
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginWidth = 10;
        groupLayout.marginHeight = 10;
        wSettings.setLayout((Layout)groupLayout);
        Label wlIncludeSubfolders = new Label((Composite)wSettings, 131072);
        wlIncludeSubfolders.setText(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.IncludeSubfolders.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlIncludeSubfolders);
        FormData fdlIncludeSubfolders = new FormData();
        fdlIncludeSubfolders.left = new FormAttachment(0, 0);
        fdlIncludeSubfolders.top = new FormAttachment((Control)this.wName, margin);
        fdlIncludeSubfolders.right = new FormAttachment(middle, -margin);
        wlIncludeSubfolders.setLayoutData((Object)fdlIncludeSubfolders);
        this.wIncludeSubfolders = new Button((Composite)wSettings, 32);
        PropsUi.setLook((Widget)this.wIncludeSubfolders);
        this.wIncludeSubfolders.setToolTipText(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.IncludeSubfolders.Tooltip", (String[])new String[0]));
        FormData fdIncludeSubfolders = new FormData();
        fdIncludeSubfolders.left = new FormAttachment(middle, 0);
        fdIncludeSubfolders.top = new FormAttachment((Control)wlIncludeSubfolders, 0, 0x1000000);
        fdIncludeSubfolders.right = new FormAttachment(100, 0);
        this.wIncludeSubfolders.setLayoutData((Object)fdIncludeSubfolders);
        this.wIncludeSubfolders.addListener(13, event -> this.action.setChanged());
        Label wlPrevious = new Label((Composite)wSettings, 131072);
        wlPrevious.setText(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.Previous.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlPrevious);
        FormData fdlPrevious = new FormData();
        fdlPrevious.left = new FormAttachment(0, 0);
        fdlPrevious.top = new FormAttachment((Control)wlIncludeSubfolders, 2 * margin);
        fdlPrevious.right = new FormAttachment(middle, -margin);
        wlPrevious.setLayoutData((Object)fdlPrevious);
        this.wPrevious = new Button((Composite)wSettings, 32);
        PropsUi.setLook((Widget)this.wPrevious);
        this.wPrevious.setSelection(this.action.isArgFromPrevious());
        this.wPrevious.setToolTipText(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.Previous.Tooltip", (String[])new String[0]));
        FormData fdPrevious = new FormData();
        fdPrevious.left = new FormAttachment(middle, 0);
        fdPrevious.top = new FormAttachment((Control)wlPrevious, 0, 0x1000000);
        fdPrevious.right = new FormAttachment(100, 0);
        this.wPrevious.setLayoutData((Object)fdPrevious);
        this.wPrevious.addListener(13, event -> {
            this.setPrevious();
            this.action.setChanged();
        });
        FormData fdSettings = new FormData();
        fdSettings.left = new FormAttachment(0, margin);
        fdSettings.top = new FormAttachment((Control)this.wName, margin);
        fdSettings.right = new FormAttachment(100, -margin);
        wSettings.setLayoutData((Object)fdSettings);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.Fields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.right = new FormAttachment(middle, -margin);
        fdlFields.top = new FormAttachment((Control)wSettings, margin);
        this.wlFields.setLayoutData((Object)fdlFields);
        int nrRows = this.action.getFileItems().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.Fields.Argument.Label", (String[])new String[0]), 6, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.Fields.Wildcard.Label", (String[])new String[0]), 1, false)};
        colinf[0].setUsingVariables(true);
        colinf[0].setToolTip(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.Fields.Column", (String[])new String[0]));
        colinf[0].setTextVarButtonSelectionListener((SelectionListener)this.getFileSelectionAdapter());
        colinf[1].setUsingVariables(true);
        colinf[1].setToolTip(BaseMessages.getString(PKG, (String)"ActionDeleteFiles.Wildcard.Column", (String[])new String[0]));
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, colinf, nrRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.wlFields.setEnabled(!this.action.isArgFromPrevious());
        this.wFields.setEnabled(!this.action.isArgFromPrevious());
        this.getData();
        this.setPrevious();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    protected SelectionAdapter getFileSelectionAdapter() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    String path = ActionDeleteFilesDialog.this.wFields.getActiveTableItem().getText(ActionDeleteFilesDialog.this.wFields.getActiveTableColumn());
                    FileObject fileObject = HopVfs.getFileObject((String)path);
                    path = BaseDialog.presentFileDialog((Shell)ActionDeleteFilesDialog.this.shell, null, (IVariables)ActionDeleteFilesDialog.this.variables, (FileObject)fileObject, (String[])new String[]{"*"}, (String[])FILETYPES, (boolean)true);
                    if (path != null) {
                        ActionDeleteFilesDialog.this.wFields.getActiveTableItem().setText(ActionDeleteFilesDialog.this.wFields.getActiveTableColumn(), path);
                    }
                }
                catch (HopFileException e) {
                    LogChannel.UI.logError("Error selecting file or directory", (Throwable)e);
                }
            }
        };
    }

    private void setPrevious() {
        this.wlFields.setEnabled(!this.wPrevious.getSelection());
        this.wFields.setEnabled(!this.wPrevious.getSelection());
    }

    public void getData() {
        if (this.action.getName() != null) {
            this.wName.setText(this.action.getName());
        }
        int i = 0;
        for (FileItem item : this.action.getFileItems()) {
            TableItem ti = this.wFields.table.getItem(i++);
            if (item.getFileName() != null) {
                ti.setText(1, item.getFileName());
            }
            if (item.getFileMask() == null) continue;
            ti.setText(2, item.getFileMask());
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wPrevious.setSelection(this.action.isArgFromPrevious());
        this.wIncludeSubfolders.setSelection(this.action.isIncludeSubfolders());
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setIncludeSubfolders(this.wIncludeSubfolders.getSelection());
        this.action.setArgFromPrevious(this.wPrevious.getSelection());
        int numberOfItems = this.wFields.nrNonEmpty();
        ArrayList<FileItem> items = new ArrayList<FileItem>();
        for (int i = 0; i < numberOfItems; ++i) {
            String path = this.wFields.getNonEmpty(i).getText(1);
            String wildcard = this.wFields.getNonEmpty(i).getText(2);
            if (path == null || path.isEmpty()) continue;
            items.add(new FileItem(path, wildcard));
        }
        this.action.setFileItems(items);
        this.dispose();
    }
}

