/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.configuration;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.Public;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.FallbackKey;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.configuration.WritableConfig;
import org.apache.flink.configuration.YamlParserUtils;
import org.apache.flink.core.io.IOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.types.StringValue;
import org.apache.flink.util.CollectionUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Public
public class Configuration
extends ExecutionConfig.GlobalJobParameters
implements IOReadableWritable,
Serializable,
Cloneable,
ReadableConfig,
WritableConfig {
    private static final long serialVersionUID = 1L;
    private static final byte TYPE_STRING = 0;
    private static final byte TYPE_INT = 1;
    private static final byte TYPE_LONG = 2;
    private static final byte TYPE_BOOLEAN = 3;
    private static final byte TYPE_FLOAT = 4;
    private static final byte TYPE_DOUBLE = 5;
    private static final byte TYPE_BYTES = 6;
    private static final Logger LOG = LoggerFactory.getLogger(Configuration.class);
    protected final HashMap<String, Object> confData;
    protected final boolean standardYaml;

    public Configuration() {
        this.confData = new HashMap();
        this.standardYaml = GlobalConfiguration.isStandardYaml();
    }

    @VisibleForTesting
    @Internal
    public Configuration(boolean standardYaml) {
        this.confData = new HashMap();
        this.standardYaml = standardYaml;
    }

    public Configuration(Configuration other) {
        this.confData = new HashMap<String, Object>(other.confData);
        this.standardYaml = other.standardYaml;
    }

    public static Configuration fromMap(Map<String, String> map) {
        Configuration configuration = new Configuration();
        map.forEach(configuration::setString);
        return configuration;
    }

    @Deprecated
    public <T> Class<T> getClass(String key, Class<? extends T> defaultValue, ClassLoader classLoader) throws ClassNotFoundException {
        Optional<Object> o = this.getRawValue(key);
        if (!o.isPresent()) {
            return defaultValue;
        }
        if (o.get().getClass() == String.class) {
            return Class.forName((String)o.get(), true, classLoader);
        }
        throw new IllegalArgumentException("Configuration cannot evaluate object of class " + o.get().getClass() + " as a class name");
    }

    @Deprecated
    public void setClass(String key, Class<?> klazz) {
        this.setValueInternal(key, klazz.getName());
    }

    public String getString(String key, String defaultValue) {
        return this.getRawValue(key).map(o -> ConfigurationUtils.convertToString(o, this.standardYaml)).orElse(defaultValue);
    }

    @Deprecated
    @PublicEvolving
    public String getString(ConfigOption<String> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    @Deprecated
    @PublicEvolving
    public String getString(ConfigOption<String> configOption, String overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    public void setString(String key, String value) {
        this.setValueInternal(key, value);
    }

    @Deprecated
    @PublicEvolving
    public void setString(ConfigOption<String> key, String value) {
        this.setValueInternal(key.key(), value);
    }

    @Deprecated
    public int getInteger(String key, int defaultValue) {
        return this.getRawValue(key).map(ConfigurationUtils::convertToInt).orElse(defaultValue);
    }

    @Deprecated
    @PublicEvolving
    public int getInteger(ConfigOption<Integer> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    @Deprecated
    @PublicEvolving
    public int getInteger(ConfigOption<Integer> configOption, int overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    @Deprecated
    public void setInteger(String key, int value) {
        this.setValueInternal(key, value);
    }

    @Deprecated
    @PublicEvolving
    public void setInteger(ConfigOption<Integer> key, int value) {
        this.setValueInternal(key.key(), value);
    }

    @Deprecated
    public long getLong(String key, long defaultValue) {
        return this.getRawValue(key).map(ConfigurationUtils::convertToLong).orElse(defaultValue);
    }

    @Deprecated
    @PublicEvolving
    public long getLong(ConfigOption<Long> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    @Deprecated
    @PublicEvolving
    public long getLong(ConfigOption<Long> configOption, long overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    @Deprecated
    public void setLong(String key, long value) {
        this.setValueInternal(key, value);
    }

    @Deprecated
    @PublicEvolving
    public void setLong(ConfigOption<Long> key, long value) {
        this.setValueInternal(key.key(), value);
    }

    @Deprecated
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getRawValue(key).map(ConfigurationUtils::convertToBoolean).orElse(defaultValue);
    }

    @Deprecated
    @PublicEvolving
    public boolean getBoolean(ConfigOption<Boolean> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    @Deprecated
    @PublicEvolving
    public boolean getBoolean(ConfigOption<Boolean> configOption, boolean overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    @Deprecated
    public void setBoolean(String key, boolean value) {
        this.setValueInternal(key, value);
    }

    @Deprecated
    @PublicEvolving
    public void setBoolean(ConfigOption<Boolean> key, boolean value) {
        this.setValueInternal(key.key(), value);
    }

    @Deprecated
    public float getFloat(String key, float defaultValue) {
        return this.getRawValue(key).map(ConfigurationUtils::convertToFloat).orElse(Float.valueOf(defaultValue)).floatValue();
    }

    @Deprecated
    @PublicEvolving
    public float getFloat(ConfigOption<Float> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue).floatValue();
    }

    @Deprecated
    @PublicEvolving
    public float getFloat(ConfigOption<Float> configOption, float overrideDefault) {
        return this.getOptional(configOption).orElse(Float.valueOf(overrideDefault)).floatValue();
    }

    @Deprecated
    public void setFloat(String key, float value) {
        this.setValueInternal(key, Float.valueOf(value));
    }

    @Deprecated
    @PublicEvolving
    public void setFloat(ConfigOption<Float> key, float value) {
        this.setValueInternal(key.key(), Float.valueOf(value));
    }

    @Deprecated
    public double getDouble(String key, double defaultValue) {
        return this.getRawValue(key).map(ConfigurationUtils::convertToDouble).orElse(defaultValue);
    }

    @Deprecated
    @PublicEvolving
    public double getDouble(ConfigOption<Double> configOption) {
        return this.getOptional(configOption).orElseGet(configOption::defaultValue);
    }

    @Deprecated
    @PublicEvolving
    public double getDouble(ConfigOption<Double> configOption, double overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    @Deprecated
    public void setDouble(String key, double value) {
        this.setValueInternal(key, value);
    }

    @Deprecated
    @PublicEvolving
    public void setDouble(ConfigOption<Double> key, double value) {
        this.setValueInternal(key.key(), value);
    }

    public byte[] getBytes(String key, byte[] defaultValue) {
        return this.getRawValue(key).map(o -> {
            if (o.getClass().equals(byte[].class)) {
                return (byte[])o;
            }
            throw new IllegalArgumentException(String.format("Configuration cannot evaluate value %s as a byte[] value", o));
        }).orElse(defaultValue);
    }

    public void setBytes(String key, byte[] bytes) {
        this.setValueInternal(key, bytes);
    }

    @PublicEvolving
    public String getValue(ConfigOption<?> configOption) {
        return Optional.ofNullable(this.getRawValueFromOption(configOption).orElseGet(configOption::defaultValue)).map(String::valueOf).orElse(null);
    }

    @PublicEvolving
    public <T extends Enum<T>> T getEnum(Class<T> enumClass, ConfigOption<String> configOption) {
        Preconditions.checkNotNull(enumClass, "enumClass must not be null");
        Preconditions.checkNotNull(configOption, "configOption must not be null");
        Object rawValue = this.getRawValueFromOption(configOption).orElseGet(configOption::defaultValue);
        try {
            return ConfigurationUtils.convertToEnum(rawValue, enumClass);
        }
        catch (IllegalArgumentException ex) {
            String errorMessage = String.format("Value for config option %s must be one of %s (was %s)", configOption.key(), Arrays.toString(enumClass.getEnumConstants()), rawValue);
            throw new IllegalArgumentException(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet() {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            return new HashSet<String>(this.confData.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllToProperties(Properties props) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            for (Map.Entry<String, Object> entry : this.confData.entrySet()) {
                props.put(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Configuration other) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            HashMap<String, Object> hashMap2 = other.confData;
            synchronized (hashMap2) {
                this.confData.putAll(other.confData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Configuration other, String prefix) {
        StringBuilder bld = new StringBuilder();
        bld.append(prefix);
        int pl = bld.length();
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            HashMap<String, Object> hashMap2 = other.confData;
            synchronized (hashMap2) {
                for (Map.Entry<String, Object> entry : other.confData.entrySet()) {
                    bld.setLength(pl);
                    bld.append(entry.getKey());
                    this.confData.put(bld.toString(), entry.getValue());
                }
            }
        }
    }

    public Configuration clone() {
        Configuration config = new Configuration();
        config.addAll(this);
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            return this.confData.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PublicEvolving
    public boolean contains(ConfigOption<?> configOption) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            BiFunction applier = (key, canBePrefixMap) -> {
                if (canBePrefixMap.booleanValue() && ConfigurationUtils.containsPrefixMap(this.confData, key) || this.confData.containsKey(key)) {
                    return Optional.of(true);
                }
                return Optional.empty();
            };
            return this.applyWithOption(configOption, applier).orElse(false);
        }
    }

    private <T> Optional<T> applyWithOption(ConfigOption<?> option, BiFunction<String, Boolean, Optional<T>> applier) {
        boolean canBePrefixMap = ConfigurationUtils.canBePrefixMap(option);
        Optional<T> valueFromExactKey = applier.apply(option.key(), canBePrefixMap);
        if (valueFromExactKey.isPresent()) {
            return valueFromExactKey;
        }
        if (option.hasFallbackKeys()) {
            for (FallbackKey fallbackKey : option.fallbackKeys()) {
                Optional<T> valueFromFallbackKey = applier.apply(fallbackKey.getKey(), canBePrefixMap);
                if (!valueFromFallbackKey.isPresent()) continue;
                this.loggingFallback(fallbackKey, option);
                return valueFromFallbackKey;
            }
        }
        return Optional.empty();
    }

    @Override
    public <T> T get(ConfigOption<T> option) {
        return (T)this.getOptional(option).orElseGet(option::defaultValue);
    }

    @PublicEvolving
    public <T> T get(ConfigOption<T> configOption, T overrideDefault) {
        return this.getOptional(configOption).orElse(overrideDefault);
    }

    @Override
    public <T> Optional<T> getOptional(ConfigOption<T> option) {
        Optional<Object> rawValue = this.getRawValueFromOption(option);
        Class<?> clazz = option.getClazz();
        try {
            if (option.isList()) {
                return rawValue.map(v -> ConfigurationUtils.convertToList(v, clazz, this.standardYaml));
            }
            return rawValue.map(v -> ConfigurationUtils.convertValue(v, clazz, this.standardYaml));
        }
        catch (Exception e) {
            throw new IllegalArgumentException(GlobalConfiguration.isSensitive(option.key()) ? String.format("Could not parse value for key '%s'.", option.key()) : String.format("Could not parse value '%s' for key '%s'.", rawValue.map(Object::toString).orElse(""), option.key()), e);
        }
    }

    @Override
    public <T> Configuration set(ConfigOption<T> option, T value) {
        boolean canBePrefixMap = ConfigurationUtils.canBePrefixMap(option);
        this.setValueInternal(option.key(), value, canBePrefixMap);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> toMap() {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            HashMap<String, String> ret = CollectionUtil.newHashMapWithExpectedSize(this.confData.size());
            for (Map.Entry<String, Object> entry : this.confData.entrySet()) {
                ret.put(entry.getKey(), ConfigurationUtils.convertToString(entry.getValue(), this.standardYaml));
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public Map<String, String> toFileWritableMap() {
        if (this.standardYaml) {
            HashMap<String, Object> hashMap = this.confData;
            synchronized (hashMap) {
                HashMap<String, String> ret = CollectionUtil.newHashMapWithExpectedSize(this.confData.size());
                for (Map.Entry<String, Object> entry : this.confData.entrySet()) {
                    ret.put(entry.getKey(), YamlParserUtils.toYAMLString(entry.getValue()));
                }
                return ret;
            }
        }
        return this.toMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> boolean removeConfig(ConfigOption<T> configOption) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            BiFunction<String, Boolean, Optional<T>> applier = (key, canBePrefixMap) -> {
                if (canBePrefixMap.booleanValue() && ConfigurationUtils.removePrefixMap(this.confData, key) || this.confData.remove(key) != null) {
                    return Optional.of(true);
                }
                return Optional.empty();
            };
            return this.applyWithOption(configOption, applier).orElse(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeKey(String key) {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            boolean removed = this.confData.remove(key) != null;
            return removed |= ConfigurationUtils.removePrefixMap(this.confData, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> void setValueInternal(String key, T value, boolean canBePrefixMap) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        if (value == null) {
            throw new NullPointerException("Value must not be null.");
        }
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            if (canBePrefixMap) {
                ConfigurationUtils.removePrefixMap(this.confData, key);
            }
            this.confData.put(key, value);
        }
    }

    private <T> void setValueInternal(String key, T value) {
        this.setValueInternal(key, value, false);
    }

    private Optional<Object> getRawValue(String key) {
        return this.getRawValue(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Object> getRawValue(String key, boolean canBePrefixMap) {
        if (key == null) {
            throw new NullPointerException("Key must not be null.");
        }
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            Object valueFromExactKey = this.confData.get(key);
            if (!canBePrefixMap || valueFromExactKey != null) {
                return Optional.ofNullable(valueFromExactKey);
            }
            Map<String, String> valueFromPrefixMap = ConfigurationUtils.convertToPropertiesPrefixed(this.confData, key, this.standardYaml);
            if (valueFromPrefixMap.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(valueFromPrefixMap);
        }
    }

    private Optional<Object> getRawValueFromOption(ConfigOption<?> configOption) {
        return this.applyWithOption(configOption, this::getRawValue);
    }

    private void loggingFallback(FallbackKey fallbackKey, ConfigOption<?> configOption) {
        if (fallbackKey.isDeprecated()) {
            LOG.warn("Config uses deprecated configuration key '{}' instead of proper key '{}'", (Object)fallbackKey.getKey(), (Object)configOption.key());
        } else {
            LOG.info("Config uses fallback configuration key '{}' instead of key '{}'", (Object)fallbackKey.getKey(), (Object)configOption.key());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(DataInputView in) throws IOException {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            int numberOfProperties = in.readInt();
            for (int i = 0; i < numberOfProperties; ++i) {
                Object value;
                String key = StringValue.readString(in);
                byte type = in.readByte();
                switch (type) {
                    case 0: {
                        value = StringValue.readString(in);
                        break;
                    }
                    case 1: {
                        value = in.readInt();
                        break;
                    }
                    case 2: {
                        value = in.readLong();
                        break;
                    }
                    case 4: {
                        value = Float.valueOf(in.readFloat());
                        break;
                    }
                    case 5: {
                        value = in.readDouble();
                        break;
                    }
                    case 3: {
                        value = in.readBoolean();
                        break;
                    }
                    case 6: {
                        byte[] bytes = new byte[in.readInt()];
                        in.readFully(bytes);
                        value = bytes;
                        break;
                    }
                    default: {
                        throw new IOException(String.format("Unrecognized type: %s. This method is deprecated and might not work for all supported types.", type));
                    }
                }
                this.confData.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataOutputView out) throws IOException {
        HashMap<String, Object> hashMap = this.confData;
        synchronized (hashMap) {
            out.writeInt(this.confData.size());
            for (Map.Entry<String, Object> entry : this.confData.entrySet()) {
                String key = entry.getKey();
                Object val = entry.getValue();
                StringValue.writeString(key, out);
                Class<?> clazz = val.getClass();
                if (clazz == String.class) {
                    out.write(0);
                    StringValue.writeString((String)val, out);
                    continue;
                }
                if (clazz == Integer.class) {
                    out.write(1);
                    out.writeInt((Integer)val);
                    continue;
                }
                if (clazz == Long.class) {
                    out.write(2);
                    out.writeLong((Long)val);
                    continue;
                }
                if (clazz == Float.class) {
                    out.write(4);
                    out.writeFloat(((Float)val).floatValue());
                    continue;
                }
                if (clazz == Double.class) {
                    out.write(5);
                    out.writeDouble((Double)val);
                    continue;
                }
                if (clazz == byte[].class) {
                    out.write(6);
                    byte[] bytes = (byte[])val;
                    out.writeInt(bytes.length);
                    out.write(bytes);
                    continue;
                }
                if (clazz == Boolean.class) {
                    out.write(3);
                    out.writeBoolean((Boolean)val);
                    continue;
                }
                throw new IllegalArgumentException("Unrecognized type. This method is deprecated and might not work for all supported types.");
            }
        }
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (String s : this.confData.keySet()) {
            hash ^= s.hashCode();
        }
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Configuration) {
            HashMap<String, Object> otherConf = ((Configuration)obj).confData;
            for (Map.Entry<String, Object> e : this.confData.entrySet()) {
                Object thisVal = e.getValue();
                Object otherVal = otherConf.get(e.getKey());
                if (!thisVal.getClass().equals(byte[].class)) {
                    if (thisVal.equals(otherVal)) continue;
                    return false;
                }
                if (otherVal.getClass().equals(byte[].class)) {
                    if (Arrays.equals((byte[])thisVal, (byte[])otherVal)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return ConfigurationUtils.hideSensitiveValues(this.confData.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> entry.getValue().toString()))).toString();
    }
}

