/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.reads.repair;

import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.service.reads.repair.RepairedDataTracker;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.DiagnosticSnapshotService;
import org.apache.cassandra.utils.NoSpamLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RepairedDataVerifier {
    public void verify(RepairedDataTracker var1);

    public static RepairedDataVerifier verifier(ReadCommand command) {
        return DatabaseDescriptor.snapshotOnRepairedDataMismatch() ? RepairedDataVerifier.snapshotting(command) : RepairedDataVerifier.simple(command);
    }

    public static RepairedDataVerifier simple(ReadCommand command) {
        return new SimpleVerifier(command);
    }

    public static RepairedDataVerifier snapshotting(ReadCommand command) {
        return new SnapshottingVerifier(command);
    }

    public static class SnapshottingVerifier
    extends SimpleVerifier {
        private static final Logger logger = LoggerFactory.getLogger(SnapshottingVerifier.class);
        private static final String SNAPSHOTTING_WARNING = "Issuing snapshot command for mismatch between repaired datasets for table {}.{} during read of {}. {}";

        SnapshottingVerifier(ReadCommand command) {
            super(command);
        }

        @Override
        public void verify(RepairedDataTracker tracker) {
            super.verify(tracker);
            if (tracker.digests.keySet().size() > 1 && (tracker.inconclusiveDigests.isEmpty() || DatabaseDescriptor.reportUnconfirmedRepairedDataMismatches())) {
                logger.warn(SNAPSHOTTING_WARNING, new Object[]{this.command.metadata().keyspace, this.command.metadata().name, this.command.toString(), tracker});
                DiagnosticSnapshotService.repairedDataMismatch(this.command.metadata(), tracker.digests.values());
            }
        }
    }

    public static class SimpleVerifier
    implements RepairedDataVerifier {
        private static final Logger logger = LoggerFactory.getLogger(SimpleVerifier.class);
        protected final ReadCommand command;
        private static final String INCONSISTENCY_WARNING = "Detected mismatch between repaired datasets for table {}.{} during read of {}. {}";

        SimpleVerifier(ReadCommand command) {
            this.command = command;
        }

        @Override
        public void verify(RepairedDataTracker tracker) {
            Tracing.trace("Verifying repaired data tracker {}", (Object)tracker);
            if (tracker.digests.keySet().size() > 1) {
                if (tracker.inconclusiveDigests.isEmpty()) {
                    TableMetrics metrics = ColumnFamilyStore.metricsFor(this.command.metadata().id);
                    metrics.confirmedRepairedInconsistencies.mark();
                    NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.MINUTES, INCONSISTENCY_WARNING, this.command.metadata().keyspace, this.command.metadata().name, this.command.toString(), tracker);
                } else if (DatabaseDescriptor.reportUnconfirmedRepairedDataMismatches()) {
                    TableMetrics metrics = ColumnFamilyStore.metricsFor(this.command.metadata().id);
                    metrics.unconfirmedRepairedInconsistencies.mark();
                    NoSpamLogger.log(logger, NoSpamLogger.Level.WARN, 1L, TimeUnit.MINUTES, INCONSISTENCY_WARNING, this.command.metadata().keyspace, this.command.metadata().name, this.command.toString(), tracker);
                }
            }
        }
    }
}

