/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.adapter;

import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.construction.NativeTransforms;
import org.apache.beam.sdk.util.construction.PTransformTranslation;
import org.apache.beam.sdk.util.construction.SdkComponents;
import org.apache.beam.sdk.util.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class FlinkInput<@UnknownKeyFor T>
extends PTransform<PBegin, PCollection<T>> {
    public static final @UnknownKeyFor @NonNull @Initialized String URN = "beam:flink:internal:translation_input";
    private final @UnknownKeyFor @NonNull @Initialized String identifier;
    private final @UnknownKeyFor @NonNull @Initialized Coder<T> coder;
    private final @UnknownKeyFor @NonNull @Initialized boolean isBounded;

    FlinkInput(@UnknownKeyFor @NonNull @Initialized String identifier, @UnknownKeyFor @NonNull @Initialized Coder<T> coder, @UnknownKeyFor @NonNull @Initialized boolean isBounded) {
        this.identifier = identifier;
        this.coder = coder;
        this.isBounded = isBounded;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
        return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)(this.isBounded ? PCollection.IsBounded.BOUNDED : PCollection.IsBounded.UNBOUNDED), this.coder);
    }

    @AutoService(value={NativeTransforms.IsNativeTransform.class})
    public static class FlinkInputOutputIsNativeTransform
    implements NativeTransforms.IsNativeTransform {
        public @UnknownKeyFor @NonNull @Initialized boolean test(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.PTransform pTransform) {
            return FlinkInput.URN.equals(PTransformTranslation.urnForTransformOrNull((RunnerApi.PTransform)pTransform));
        }
    }

    @AutoService(value={TransformPayloadTranslatorRegistrar.class})
    public static class Translator
    implements PTransformTranslation.TransformPayloadTranslator<FlinkInput<?>>,
    TransformPayloadTranslatorRegistrar {
        public @UnknownKeyFor @NonNull @Initialized String getUrn() {
            return FlinkInput.URN;
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized RunnerApi.FunctionSpec translate(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized AppliedPTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized FlinkInput<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> application, @UnknownKeyFor @NonNull @Initialized SdkComponents components) throws @UnknownKeyFor @NonNull @Initialized IOException {
            return RunnerApi.FunctionSpec.newBuilder().setUrn(FlinkInput.URN).setPayload(ByteString.copyFromUtf8((String)((FlinkInput)application.getTransform()).identifier)).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Map<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PTransform>, @KeyForBottom @NonNull @Initialized ? extends // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return Collections.singletonMap(FlinkInput.class, this);
        }
    }
}

