/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.closure;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.closure.ClosureGenerator;
import org.apache.hop.pipeline.transforms.closure.ClosureGeneratorData;

@Transform(id="ClosureGenerator", image="closuregenerator.svg", name="i18n::ClosureGenerator.Name", description="i18n::ClosureGenerator.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::ClosureGeneratorMeta.keyword"}, documentationUrl="/pipeline/transforms/closure.html")
public class ClosureGeneratorMeta
extends BaseTransformMeta<ClosureGenerator, ClosureGeneratorData> {
    @HopMetadataProperty(key="is_root_zero")
    private boolean rootIdZero;
    @HopMetadataProperty(key="parent_id_field")
    private String parentIdFieldName;
    @HopMetadataProperty(key="child_id_field")
    private String childIdFieldName;
    @HopMetadataProperty(key="distance_field")
    private String distanceFieldName;

    public ClosureGeneratorMeta() {
    }

    public ClosureGeneratorMeta(ClosureGeneratorMeta m) {
        this.rootIdZero = m.rootIdZero;
        this.parentIdFieldName = m.parentIdFieldName;
        this.childIdFieldName = m.childIdFieldName;
        this.distanceFieldName = m.distanceFieldName;
    }

    public ClosureGeneratorMeta clone() {
        return new ClosureGeneratorMeta(this);
    }

    public void setDefault() {
    }

    public void getFields(IRowMeta row, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        IValueMeta childValueMeta;
        RowMeta result = new RowMeta();
        IValueMeta parentValueMeta = row.searchValueMeta(this.parentIdFieldName);
        if (parentValueMeta != null) {
            result.addValueMeta(parentValueMeta);
        }
        if ((childValueMeta = row.searchValueMeta(this.childIdFieldName)) != null) {
            result.addValueMeta(childValueMeta);
        }
        ValueMetaInteger distanceValueMeta = new ValueMetaInteger(this.distanceFieldName);
        distanceValueMeta.setLength(10);
        result.addValueMeta((IValueMeta)distanceValueMeta);
        row.clear();
        row.addRowMeta((IRowMeta)result);
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        IValueMeta parentValueMeta = prev.searchValueMeta(this.parentIdFieldName);
        if (parentValueMeta != null) {
            cr = new CheckResult(4, "The fieldname of the parent id could not be found.", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, "The fieldname of the parent id could be found", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        IValueMeta childValueMeta = prev.searchValueMeta(this.childIdFieldName);
        if (childValueMeta != null) {
            cr = new CheckResult(4, "The fieldname of the child id could not be found.", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, "The fieldname of the child id could be found", (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public boolean isRootIdZero() {
        return this.rootIdZero;
    }

    public void setRootIdZero(boolean rootIdZero) {
        this.rootIdZero = rootIdZero;
    }

    public String getParentIdFieldName() {
        return this.parentIdFieldName;
    }

    public void setParentIdFieldName(String parentIdFieldName) {
        this.parentIdFieldName = parentIdFieldName;
    }

    public String getChildIdFieldName() {
        return this.childIdFieldName;
    }

    public void setChildIdFieldName(String childIdFieldName) {
        this.childIdFieldName = childIdFieldName;
    }

    public String getDistanceFieldName() {
        return this.distanceFieldName;
    }

    public void setDistanceFieldName(String distanceFieldName) {
        this.distanceFieldName = distanceFieldName;
    }
}

