/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution.sampler.plugins.random;

import java.util.List;
import java.util.Random;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.execution.sampler.ExecutionDataSamplerMeta;
import org.apache.hop.execution.sampler.ExecutionDataSamplerPlugin;
import org.apache.hop.execution.sampler.IExecutionDataSampler;
import org.apache.hop.execution.sampler.plugins.ExecutionDataSamplerBase;
import org.apache.hop.execution.sampler.plugins.random.RandomRowsExecutionDataSamplerStore;
import org.apache.hop.pipeline.transform.stream.IStream;

@GuiPlugin
@ExecutionDataSamplerPlugin(id="RandomRowsExecutionDataSampler", name="Random output rows", description="Do reservoir sampling on the output rows of a transform")
public class RandomRowsExecutionDataSampler
extends ExecutionDataSamplerBase<RandomRowsExecutionDataSamplerStore>
implements IExecutionDataSampler<RandomRowsExecutionDataSamplerStore> {
    private final Random random = new Random();

    public RandomRowsExecutionDataSampler() {
    }

    public RandomRowsExecutionDataSampler(RandomRowsExecutionDataSampler sampler) {
        super(sampler);
    }

    public RandomRowsExecutionDataSampler(String sampleSize) {
        super(sampleSize, "RandomRowsExecutionDataSampler", "Random output rows");
    }

    @Override
    public RandomRowsExecutionDataSampler clone() {
        return new RandomRowsExecutionDataSampler(this);
    }

    @Override
    public RandomRowsExecutionDataSamplerStore createSamplerStore(ExecutionDataSamplerMeta samplerMeta) {
        return new RandomRowsExecutionDataSamplerStore(this, samplerMeta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sampleRow(RandomRowsExecutionDataSamplerStore samplerStore, IStream.StreamType streamType, IRowMeta rowMeta, Object[] row) throws HopValueException {
        List<Object[]> list = samplerStore.getRows();
        synchronized (list) {
            List<Object[]> rows = samplerStore.getRows();
            if (samplerStore.getMaxRows() <= 0 || streamType != IStream.StreamType.OUTPUT) {
                return;
            }
            if (rows.size() < samplerStore.getMaxRows()) {
                if (rows.isEmpty()) {
                    samplerStore.setRowMeta(rowMeta);
                }
                rows.add(row);
            } else {
                int randomIndex = this.random.nextInt(samplerStore.getMaxRows());
                if (randomIndex < samplerStore.getMaxRows()) {
                    rows.set(randomIndex, rowMeta.cloneRow(row));
                }
            }
        }
    }
}

