/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.stream.IStream;
import org.apache.hop.pipeline.transforms.validator.Validation;
import org.apache.hop.pipeline.transforms.validator.ValidatorMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterStringDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ValidatorDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = ValidatorMeta.class;
    private final ValidatorMeta input;
    private org.eclipse.swt.widgets.List wValidationsList;
    private IRowMeta inputFields;
    private Button wValidateAll;
    private Validation selectedField;
    private Label wlDescription;
    private Text wDescription;
    private Label wlFieldName;
    private CCombo wFieldName;
    private Button wNullAllowed;
    private Button wOnlyNullAllowed;
    private Button wOnlyNumeric;
    private final List<Validation> selectionList;
    private TextVar wMaxLength;
    private TextVar wMinLength;
    private Group wgData;
    private Group wgType;
    private Button wDataTypeVerified;
    private CCombo wDataType;
    private TextVar wConversionMask;
    private TextVar wDecimalSymbol;
    private TextVar wGroupingSymbol;
    private TextVar wMaxValue;
    private TextVar wMinValue;
    private Label wlAllowedValues;
    private org.eclipse.swt.widgets.List wAllowedValues;
    private Button wSourceValues;
    private Label wlSourceTransform;
    private CCombo wSourceTransform;
    private Label wlSourceField;
    private CCombo wSourceField;
    private Button wbAddAllowed;
    private Button wbRemoveAllowed;
    private TextVar wStartStringExpected;
    private TextVar wEndStringExpected;
    private TextVar wStartStringDisallowed;
    private TextVar wEndStringDisallowed;
    private TextVar wRegExpExpected;
    private TextVar wRegExpDisallowed;
    private Label wlErrorCode;
    private TextVar wErrorCode;
    private Label wlErrorDescription;
    private TextVar wErrorDescription;
    private Button wConcatErrors;
    private TextVar wConcatSeparator;

    public ValidatorDialog(Shell parent, IVariables variables, ValidatorMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
        List infoStreams = this.input.getTransformIOMeta().getInfoStreams();
        for (int i = 0; i < infoStreams.size(); ++i) {
            this.input.getValidations().get(i).setSourcingTransformName(((IStream)infoStreams.get(i)).getTransformName());
        }
        this.selectedField = null;
        this.selectionList = new ArrayList<Validation>();
        for (Validation field : this.input.getValidations()) {
            this.selectionList.add(field.clone());
        }
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        this.shell.setLayout(this.props.createFormLayout());
        this.shell.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.Transform.Name", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = PropsUi.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        Button wNew = new Button((Composite)this.shell, 8);
        wNew.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.NewButton.Label", (String[])new String[0]));
        wNew.addListener(13, e -> this.newValidation());
        Button wClear = new Button((Composite)this.shell, 8);
        wClear.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.ClearButton.Label", (String[])new String[0]));
        wClear.addListener(13, e -> this.clearValidation());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, wNew, wClear, this.wCancel}, margin, null);
        Label wlFieldList = new Label((Composite)this.shell, 16384);
        wlFieldList.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.FieldList.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFieldList);
        FormData fdlFieldList = new FormData();
        fdlFieldList.left = new FormAttachment(0, 0);
        fdlFieldList.right = new FormAttachment(middle, -margin);
        fdlFieldList.top = new FormAttachment((Control)this.wTransformName, margin);
        wlFieldList.setLayoutData((Object)fdlFieldList);
        this.wValidationsList = new org.eclipse.swt.widgets.List((Composite)this.shell, 19204);
        PropsUi.setLook((Widget)this.wValidationsList);
        this.wValidationsList.addListener(13, e -> this.showSelectedValidatorField(this.wValidationsList.getSelection()[0]));
        FormData fdFieldList = new FormData();
        fdFieldList.left = new FormAttachment(0, 0);
        fdFieldList.top = new FormAttachment((Control)wlFieldList, margin);
        fdFieldList.right = new FormAttachment(middle / 2, -margin);
        fdFieldList.bottom = new FormAttachment((Control)this.wOk, -margin * 2);
        this.wValidationsList.setLayoutData((Object)fdFieldList);
        this.wValidateAll = new Button((Composite)this.shell, 32);
        this.wValidateAll.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.ValidateAll.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wValidateAll);
        FormData fdValidateAll = new FormData();
        fdValidateAll.left = new FormAttachment(middle, 0);
        fdValidateAll.right = new FormAttachment(100, 0);
        fdValidateAll.top = new FormAttachment((Control)this.wTransformName, margin);
        this.wValidateAll.setLayoutData((Object)fdValidateAll);
        this.wValidateAll.addListener(13, e -> this.setFlags());
        this.wConcatErrors = new Button((Composite)this.shell, 32);
        this.wConcatErrors.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.ConcatErrors.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wConcatErrors);
        FormData fdConcatErrors = new FormData();
        fdConcatErrors.left = new FormAttachment(middle, 0);
        fdConcatErrors.top = new FormAttachment((Control)this.wValidateAll, margin);
        this.wConcatErrors.setLayoutData((Object)fdConcatErrors);
        this.wConcatErrors.addListener(13, e -> this.setFlags());
        this.wConcatSeparator = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wConcatSeparator);
        FormData fdConcatSeparator = new FormData();
        fdConcatSeparator.left = new FormAttachment((Control)this.wConcatErrors, margin);
        fdConcatSeparator.right = new FormAttachment(100, 0);
        fdConcatSeparator.top = new FormAttachment((Control)this.wValidateAll, margin);
        this.wConcatSeparator.setLayoutData((Object)fdConcatSeparator);
        ScrolledComposite wSComp = new ScrolledComposite((Composite)this.shell, 768);
        PropsUi.setLook((Widget)wSComp);
        wSComp.setLayout((Layout)new FillLayout());
        FormData fdComp = new FormData();
        fdComp.left = new FormAttachment(middle / 2, 0);
        fdComp.top = new FormAttachment((Control)this.wConcatSeparator, margin);
        fdComp.right = new FormAttachment(100, 0);
        fdComp.bottom = new FormAttachment((Control)this.wOk, -margin * 2);
        wSComp.setLayoutData((Object)fdComp);
        Composite wComp = new Composite((Composite)wSComp, 2048);
        PropsUi.setLook((Widget)wComp);
        FormLayout compLayout = new FormLayout();
        compLayout.marginWidth = 3;
        compLayout.marginHeight = 3;
        wComp.setLayout((Layout)compLayout);
        this.wlDescription = new Label(wComp, 131072);
        this.wlDescription.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.Description.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlDescription);
        FormData fdlDescription = new FormData();
        fdlDescription.left = new FormAttachment(0, 0);
        fdlDescription.right = new FormAttachment(middle, -margin);
        fdlDescription.top = new FormAttachment(0, 0);
        this.wlDescription.setLayoutData((Object)fdlDescription);
        this.wDescription = new Text(wComp, 18436);
        PropsUi.setLook((Widget)this.wDescription);
        FormData fdDescription = new FormData();
        fdDescription.left = new FormAttachment(middle, margin);
        fdDescription.right = new FormAttachment(100, 0);
        fdDescription.top = new FormAttachment(0, 0);
        this.wDescription.setLayoutData((Object)fdDescription);
        this.wDescription.addListener(24, event -> {
            int index;
            String description;
            Validation validation;
            if (this.wValidationsList != null && this.wValidationsList.getItemCount() > 0 && this.wValidationsList.getSelection().length == 1 && (validation = Validation.findValidation(this.selectionList, description = this.wValidationsList.getItem(index = this.wValidationsList.getSelectionIndex()))) != null) {
                String newDescription = this.wDescription.getText();
                validation.setName(newDescription);
                this.wValidationsList.setItem(index, newDescription);
                this.wValidationsList.select(index);
            }
        });
        this.wlFieldName = new Label(wComp, 131072);
        this.wlFieldName.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.FieldName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFieldName);
        FormData fdlFieldName = new FormData();
        fdlFieldName.left = new FormAttachment(0, 0);
        fdlFieldName.right = new FormAttachment(middle, -margin);
        fdlFieldName.top = new FormAttachment((Control)this.wDescription, margin);
        this.wlFieldName.setLayoutData((Object)fdlFieldName);
        this.wFieldName = new CCombo(wComp, 18436);
        PropsUi.setLook((Widget)this.wFieldName);
        FormData fdFieldName = new FormData();
        fdFieldName.left = new FormAttachment(middle, margin);
        fdFieldName.right = new FormAttachment(100, 0);
        fdFieldName.top = new FormAttachment((Control)this.wDescription, margin);
        this.wFieldName.setLayoutData((Object)fdFieldName);
        try {
            this.inputFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
            this.wFieldName.setItems(this.inputFields.getFieldNames());
        }
        catch (HopTransformException ex) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ValidatorDialog.Exception.CantGetFieldsFromPreviousTransforms.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ValidatorDialog.Exception.CantGetFieldsFromPreviousTransforms.Message", (String[])new String[0]), (Exception)((Object)ex));
        }
        this.wlErrorCode = new Label(wComp, 131072);
        this.wlErrorCode.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.ErrorCode.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlErrorCode);
        FormData fdlErrorCode = new FormData();
        fdlErrorCode.left = new FormAttachment(0, 0);
        fdlErrorCode.right = new FormAttachment(middle, -margin);
        fdlErrorCode.top = new FormAttachment((Control)this.wFieldName, margin);
        this.wlErrorCode.setLayoutData((Object)fdlErrorCode);
        this.wErrorCode = new TextVar(this.variables, wComp, 18436);
        PropsUi.setLook((Widget)this.wErrorCode);
        FormData fdErrorCode = new FormData();
        fdErrorCode.left = new FormAttachment(middle, margin);
        fdErrorCode.right = new FormAttachment(100, 0);
        fdErrorCode.top = new FormAttachment((Control)this.wFieldName, margin);
        this.wErrorCode.setLayoutData((Object)fdErrorCode);
        this.addSpacesWarning(this.wErrorCode);
        this.wlErrorDescription = new Label(wComp, 131072);
        this.wlErrorDescription.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.ErrorDescription.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlErrorDescription);
        FormData fdlErrorDescription = new FormData();
        fdlErrorDescription.left = new FormAttachment(0, 0);
        fdlErrorDescription.right = new FormAttachment(middle, -margin);
        fdlErrorDescription.top = new FormAttachment((Control)this.wErrorCode, margin);
        this.wlErrorDescription.setLayoutData((Object)fdlErrorDescription);
        this.wErrorDescription = new TextVar(this.variables, wComp, 18436);
        PropsUi.setLook((Widget)this.wErrorDescription);
        FormData fdErrorDescription = new FormData();
        fdErrorDescription.left = new FormAttachment(middle, margin);
        fdErrorDescription.right = new FormAttachment(100, 0);
        fdErrorDescription.top = new FormAttachment((Control)this.wErrorCode, margin);
        this.wErrorDescription.setLayoutData((Object)fdErrorDescription);
        this.addSpacesWarning(this.wErrorDescription);
        this.wgType = new Group(wComp, 0);
        PropsUi.setLook((Widget)this.wgType);
        this.wgType.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.TypeGroup.Label", (String[])new String[0]));
        FormLayout typeGroupLayout = new FormLayout();
        typeGroupLayout.marginHeight = 5;
        typeGroupLayout.marginWidth = 5;
        this.wgType.setLayout((Layout)typeGroupLayout);
        FormData fdType = new FormData();
        fdType.left = new FormAttachment(0, 0);
        fdType.right = new FormAttachment(100, 0);
        fdType.top = new FormAttachment((Control)this.wErrorDescription, margin * 2);
        this.wgType.setLayoutData((Object)fdType);
        Label wlDataTypeVerified = new Label((Composite)this.wgType, 131072);
        wlDataTypeVerified.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.DataTypeVerified.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDataTypeVerified);
        FormData fdlDataTypeVerified = new FormData();
        fdlDataTypeVerified.left = new FormAttachment(0, 0);
        fdlDataTypeVerified.right = new FormAttachment(middle, -margin);
        fdlDataTypeVerified.top = new FormAttachment(0, 0);
        wlDataTypeVerified.setLayoutData((Object)fdlDataTypeVerified);
        this.wDataTypeVerified = new Button((Composite)this.wgType, 32);
        PropsUi.setLook((Widget)this.wDataTypeVerified);
        FormData fdDataTypeVerified = new FormData();
        fdDataTypeVerified.left = new FormAttachment(middle, margin);
        fdDataTypeVerified.right = new FormAttachment(100, 0);
        fdDataTypeVerified.top = new FormAttachment((Control)wlDataTypeVerified, 0, 0x1000000);
        this.wDataTypeVerified.setLayoutData((Object)fdDataTypeVerified);
        Label wlDataType = new Label((Composite)this.wgType, 131072);
        wlDataType.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.DataType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDataType);
        FormData fdlDataType = new FormData();
        fdlDataType.left = new FormAttachment(0, 0);
        fdlDataType.right = new FormAttachment(middle, -margin);
        fdlDataType.top = new FormAttachment((Control)wlDataTypeVerified, margin);
        wlDataType.setLayoutData((Object)fdlDataType);
        this.wDataType = new CCombo((Composite)this.wgType, 18436);
        this.wDataType.setItems(ValueMetaFactory.getValueMetaNames());
        PropsUi.setLook((Widget)this.wDataType);
        FormData fdDataType = new FormData();
        fdDataType.left = new FormAttachment(middle, margin);
        fdDataType.right = new FormAttachment(100, 0);
        fdDataType.top = new FormAttachment((Control)wlDataType, 0, 0x1000000);
        this.wDataType.setLayoutData((Object)fdDataType);
        Label wlConversionMask = new Label((Composite)this.wgType, 131072);
        wlConversionMask.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.ConversionMask.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlConversionMask);
        FormData fdlConversionMask = new FormData();
        fdlConversionMask.left = new FormAttachment(0, 0);
        fdlConversionMask.right = new FormAttachment(middle, -margin);
        fdlConversionMask.top = new FormAttachment((Control)wlDataType, margin);
        wlConversionMask.setLayoutData((Object)fdlConversionMask);
        this.wConversionMask = new TextVar(this.variables, (Composite)this.wgType, 18436);
        PropsUi.setLook((Widget)this.wConversionMask);
        FormData fdConversionMask = new FormData();
        fdConversionMask.left = new FormAttachment(middle, margin);
        fdConversionMask.right = new FormAttachment(100, 0);
        fdConversionMask.top = new FormAttachment((Control)this.wDataType, margin);
        this.wConversionMask.setLayoutData((Object)fdConversionMask);
        this.addSpacesWarning(this.wConversionMask);
        Label wlDecimalSymbol = new Label((Composite)this.wgType, 131072);
        wlDecimalSymbol.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.DecimalSymbol.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlDecimalSymbol);
        FormData fdlDecimalSymbol = new FormData();
        fdlDecimalSymbol.left = new FormAttachment(0, 0);
        fdlDecimalSymbol.right = new FormAttachment(middle, -margin);
        fdlDecimalSymbol.top = new FormAttachment((Control)this.wConversionMask, margin);
        wlDecimalSymbol.setLayoutData((Object)fdlDecimalSymbol);
        this.wDecimalSymbol = new TextVar(this.variables, (Composite)this.wgType, 18436);
        PropsUi.setLook((Widget)this.wDecimalSymbol);
        FormData fdDecimalSymbol = new FormData();
        fdDecimalSymbol.left = new FormAttachment(middle, margin);
        fdDecimalSymbol.right = new FormAttachment(100, 0);
        fdDecimalSymbol.top = new FormAttachment((Control)this.wConversionMask, margin);
        this.wDecimalSymbol.setLayoutData((Object)fdDecimalSymbol);
        this.addSpacesWarning(this.wDecimalSymbol);
        Label wlGroupingSymbol = new Label((Composite)this.wgType, 131072);
        wlGroupingSymbol.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.GroupingSymbol.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlGroupingSymbol);
        FormData fdlGroupingSymbol = new FormData();
        fdlGroupingSymbol.left = new FormAttachment(0, 0);
        fdlGroupingSymbol.right = new FormAttachment(middle, -margin);
        fdlGroupingSymbol.top = new FormAttachment((Control)this.wDecimalSymbol, margin);
        wlGroupingSymbol.setLayoutData((Object)fdlGroupingSymbol);
        this.wGroupingSymbol = new TextVar(this.variables, (Composite)this.wgType, 18436);
        PropsUi.setLook((Widget)this.wGroupingSymbol);
        FormData fdGroupingSymbol = new FormData();
        fdGroupingSymbol.left = new FormAttachment(middle, margin);
        fdGroupingSymbol.right = new FormAttachment(100, 0);
        fdGroupingSymbol.top = new FormAttachment((Control)this.wDecimalSymbol, margin);
        this.wGroupingSymbol.setLayoutData((Object)fdGroupingSymbol);
        this.addSpacesWarning(this.wGroupingSymbol);
        this.wgData = new Group(wComp, 0);
        PropsUi.setLook((Widget)this.wgData);
        this.wgData.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.DataGroup.Label", (String[])new String[0]));
        this.wgData.setLayout(this.props.createFormLayout());
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.right = new FormAttachment(100, 0);
        fdData.top = new FormAttachment((Control)this.wgType, margin);
        this.wgData.setLayoutData((Object)fdData);
        Label wlNullAllowed = new Label((Composite)this.wgData, 131072);
        wlNullAllowed.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.NullAllowed.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlNullAllowed);
        FormData fdlNullAllowed = new FormData();
        fdlNullAllowed.left = new FormAttachment(0, 0);
        fdlNullAllowed.right = new FormAttachment(middle, -margin);
        fdlNullAllowed.top = new FormAttachment(0, 0);
        wlNullAllowed.setLayoutData((Object)fdlNullAllowed);
        this.wNullAllowed = new Button((Composite)this.wgData, 32);
        PropsUi.setLook((Widget)this.wNullAllowed);
        FormData fdNullAllowed = new FormData();
        fdNullAllowed.left = new FormAttachment(middle, margin);
        fdNullAllowed.right = new FormAttachment(100, 0);
        fdNullAllowed.top = new FormAttachment((Control)wlNullAllowed, 0, 0x1000000);
        this.wNullAllowed.setLayoutData((Object)fdNullAllowed);
        Label wlOnlyNullAllowed = new Label((Composite)this.wgData, 131072);
        wlOnlyNullAllowed.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.OnlyNullAllowed.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOnlyNullAllowed);
        FormData fdlOnlyNullAllowed = new FormData();
        fdlOnlyNullAllowed.left = new FormAttachment(0, 0);
        fdlOnlyNullAllowed.right = new FormAttachment(middle, -margin);
        fdlOnlyNullAllowed.top = new FormAttachment((Control)wlNullAllowed, margin);
        wlOnlyNullAllowed.setLayoutData((Object)fdlOnlyNullAllowed);
        this.wOnlyNullAllowed = new Button((Composite)this.wgData, 32);
        PropsUi.setLook((Widget)this.wOnlyNullAllowed);
        FormData fdOnlyNullAllowed = new FormData();
        fdOnlyNullAllowed.left = new FormAttachment(middle, margin);
        fdOnlyNullAllowed.right = new FormAttachment(100, 0);
        fdOnlyNullAllowed.top = new FormAttachment((Control)wlOnlyNullAllowed, 0, 0x1000000);
        this.wOnlyNullAllowed.setLayoutData((Object)fdOnlyNullAllowed);
        Label wlOnlyNumeric = new Label((Composite)this.wgData, 131072);
        wlOnlyNumeric.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.OnlyNumeric.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOnlyNumeric);
        FormData fdlOnlyNumeric = new FormData();
        fdlOnlyNumeric.left = new FormAttachment(0, 0);
        fdlOnlyNumeric.right = new FormAttachment(middle, -margin);
        fdlOnlyNumeric.top = new FormAttachment((Control)wlOnlyNullAllowed, margin);
        wlOnlyNumeric.setLayoutData((Object)fdlOnlyNumeric);
        this.wOnlyNumeric = new Button((Composite)this.wgData, 32);
        PropsUi.setLook((Widget)this.wOnlyNumeric);
        FormData fdOnlyNumeric = new FormData();
        fdOnlyNumeric.left = new FormAttachment(middle, margin);
        fdOnlyNumeric.right = new FormAttachment(100, 0);
        fdOnlyNumeric.top = new FormAttachment((Control)wlOnlyNumeric, 0, 0x1000000);
        this.wOnlyNumeric.setLayoutData((Object)fdOnlyNumeric);
        Label wlMaxLength = new Label((Composite)this.wgData, 131072);
        wlMaxLength.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.MaxLength.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMaxLength);
        FormData fdlMaxLength = new FormData();
        fdlMaxLength.left = new FormAttachment(0, 0);
        fdlMaxLength.right = new FormAttachment(middle, -margin);
        fdlMaxLength.top = new FormAttachment((Control)wlOnlyNumeric, margin);
        wlMaxLength.setLayoutData((Object)fdlMaxLength);
        this.wMaxLength = new TextVar(this.variables, (Composite)this.wgData, 18436);
        PropsUi.setLook((Widget)this.wMaxLength);
        FormData fdMaxLength = new FormData();
        fdMaxLength.left = new FormAttachment(middle, margin);
        fdMaxLength.right = new FormAttachment(100, 0);
        fdMaxLength.top = new FormAttachment((Control)wlMaxLength, 0, 0x1000000);
        this.wMaxLength.setLayoutData((Object)fdMaxLength);
        this.addSpacesWarning(this.wMaxLength);
        Label wlMinLength = new Label((Composite)this.wgData, 131072);
        wlMinLength.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.MinLength.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMinLength);
        FormData fdlMinLength = new FormData();
        fdlMinLength.left = new FormAttachment(0, 0);
        fdlMinLength.right = new FormAttachment(middle, -margin);
        fdlMinLength.top = new FormAttachment((Control)this.wMaxLength, margin);
        wlMinLength.setLayoutData((Object)fdlMinLength);
        this.wMinLength = new TextVar(this.variables, (Composite)this.wgData, 18436);
        PropsUi.setLook((Widget)this.wMinLength);
        FormData fdMinLength = new FormData();
        fdMinLength.left = new FormAttachment(middle, margin);
        fdMinLength.right = new FormAttachment(100, 0);
        fdMinLength.top = new FormAttachment((Control)this.wMaxLength, margin);
        this.wMinLength.setLayoutData((Object)fdMinLength);
        this.addSpacesWarning(this.wMinLength);
        Label wlMaxValue = new Label((Composite)this.wgData, 131072);
        wlMaxValue.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.MaxValue.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMaxValue);
        FormData fdlMaxValue = new FormData();
        fdlMaxValue.left = new FormAttachment(0, 0);
        fdlMaxValue.right = new FormAttachment(middle, -margin);
        fdlMaxValue.top = new FormAttachment((Control)this.wMinLength, margin);
        wlMaxValue.setLayoutData((Object)fdlMaxValue);
        this.wMaxValue = new TextVar(this.variables, (Composite)this.wgData, 18436);
        PropsUi.setLook((Widget)this.wMaxValue);
        FormData fdMaxValue = new FormData();
        fdMaxValue.left = new FormAttachment(middle, margin);
        fdMaxValue.right = new FormAttachment(100, 0);
        fdMaxValue.top = new FormAttachment((Control)this.wMinLength, margin);
        this.wMaxValue.setLayoutData((Object)fdMaxValue);
        this.addSpacesWarning(this.wMaxValue);
        Label wlMinValue = new Label((Composite)this.wgData, 131072);
        wlMinValue.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.MinValue.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlMinValue);
        FormData fdlMinValue = new FormData();
        fdlMinValue.left = new FormAttachment(0, 0);
        fdlMinValue.right = new FormAttachment(middle, -margin);
        fdlMinValue.top = new FormAttachment((Control)this.wMaxValue, margin);
        wlMinValue.setLayoutData((Object)fdlMinValue);
        this.wMinValue = new TextVar(this.variables, (Composite)this.wgData, 18436);
        PropsUi.setLook((Widget)this.wMinValue);
        FormData fdMinValue = new FormData();
        fdMinValue.left = new FormAttachment(middle, margin);
        fdMinValue.right = new FormAttachment(100, 0);
        fdMinValue.top = new FormAttachment((Control)this.wMaxValue, margin);
        this.wMinValue.setLayoutData((Object)fdMinValue);
        this.addSpacesWarning(this.wMinValue);
        Label wlStartStringExpected = new Label((Composite)this.wgData, 131072);
        wlStartStringExpected.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.StartStringExpected.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlStartStringExpected);
        FormData fdlStartStringExpected = new FormData();
        fdlStartStringExpected.left = new FormAttachment(0, 0);
        fdlStartStringExpected.right = new FormAttachment(middle, -margin);
        fdlStartStringExpected.top = new FormAttachment((Control)this.wMinValue, margin);
        wlStartStringExpected.setLayoutData((Object)fdlStartStringExpected);
        this.wStartStringExpected = new TextVar(this.variables, (Composite)this.wgData, 18436);
        PropsUi.setLook((Widget)this.wStartStringExpected);
        FormData fdStartStringExpected = new FormData();
        fdStartStringExpected.left = new FormAttachment(middle, margin);
        fdStartStringExpected.right = new FormAttachment(100, 0);
        fdStartStringExpected.top = new FormAttachment((Control)this.wMinValue, margin);
        this.wStartStringExpected.setLayoutData((Object)fdStartStringExpected);
        this.addSpacesWarning(this.wStartStringExpected);
        Label wlEndStringExpected = new Label((Composite)this.wgData, 131072);
        wlEndStringExpected.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.EndStringExpected.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEndStringExpected);
        FormData fdlEndStringExpected = new FormData();
        fdlEndStringExpected.left = new FormAttachment(0, 0);
        fdlEndStringExpected.right = new FormAttachment(middle, -margin);
        fdlEndStringExpected.top = new FormAttachment((Control)this.wStartStringExpected, margin);
        wlEndStringExpected.setLayoutData((Object)fdlEndStringExpected);
        this.wEndStringExpected = new TextVar(this.variables, (Composite)this.wgData, 18436);
        PropsUi.setLook((Widget)this.wEndStringExpected);
        FormData fdEndStringExpected = new FormData();
        fdEndStringExpected.left = new FormAttachment(middle, margin);
        fdEndStringExpected.right = new FormAttachment(100, 0);
        fdEndStringExpected.top = new FormAttachment((Control)this.wStartStringExpected, margin);
        this.wEndStringExpected.setLayoutData((Object)fdEndStringExpected);
        this.addSpacesWarning(this.wEndStringExpected);
        Label wlStartStringDisallowed = new Label((Composite)this.wgData, 131072);
        wlStartStringDisallowed.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.StartStringDisallowed.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlStartStringDisallowed);
        FormData fdlStartStringDisallowed = new FormData();
        fdlStartStringDisallowed.left = new FormAttachment(0, 0);
        fdlStartStringDisallowed.right = new FormAttachment(middle, -margin);
        fdlStartStringDisallowed.top = new FormAttachment((Control)this.wEndStringExpected, margin);
        wlStartStringDisallowed.setLayoutData((Object)fdlStartStringDisallowed);
        this.wStartStringDisallowed = new TextVar(this.variables, (Composite)this.wgData, 18436);
        PropsUi.setLook((Widget)this.wStartStringDisallowed);
        FormData fdStartStringDisallowed = new FormData();
        fdStartStringDisallowed.left = new FormAttachment(middle, margin);
        fdStartStringDisallowed.right = new FormAttachment(100, 0);
        fdStartStringDisallowed.top = new FormAttachment((Control)this.wEndStringExpected, margin);
        this.wStartStringDisallowed.setLayoutData((Object)fdStartStringDisallowed);
        this.addSpacesWarning(this.wStartStringDisallowed);
        Label wlEndStringDisallowed = new Label((Composite)this.wgData, 131072);
        wlEndStringDisallowed.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.EndStringDisallowed.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlEndStringDisallowed);
        FormData fdlEndStringDisallowed = new FormData();
        fdlEndStringDisallowed.left = new FormAttachment(0, 0);
        fdlEndStringDisallowed.right = new FormAttachment(middle, -margin);
        fdlEndStringDisallowed.top = new FormAttachment((Control)this.wStartStringDisallowed, margin);
        wlEndStringDisallowed.setLayoutData((Object)fdlEndStringDisallowed);
        this.wEndStringDisallowed = new TextVar(this.variables, (Composite)this.wgData, 18436);
        PropsUi.setLook((Widget)this.wEndStringDisallowed);
        FormData fdEndStringDisallowed = new FormData();
        fdEndStringDisallowed.left = new FormAttachment(middle, margin);
        fdEndStringDisallowed.right = new FormAttachment(100, 0);
        fdEndStringDisallowed.top = new FormAttachment((Control)this.wStartStringDisallowed, margin);
        this.wEndStringDisallowed.setLayoutData((Object)fdEndStringDisallowed);
        this.addSpacesWarning(this.wEndStringDisallowed);
        Label wlRegExpExpected = new Label((Composite)this.wgData, 131072);
        wlRegExpExpected.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.RegExpExpected.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRegExpExpected);
        FormData fdlRegExpExpected = new FormData();
        fdlRegExpExpected.left = new FormAttachment(0, 0);
        fdlRegExpExpected.right = new FormAttachment(middle, -margin);
        fdlRegExpExpected.top = new FormAttachment((Control)this.wEndStringDisallowed, margin);
        wlRegExpExpected.setLayoutData((Object)fdlRegExpExpected);
        this.wRegExpExpected = new TextVar(this.variables, (Composite)this.wgData, 18436);
        PropsUi.setLook((Widget)this.wRegExpExpected);
        FormData fdRegExpExpected = new FormData();
        fdRegExpExpected.left = new FormAttachment(middle, margin);
        fdRegExpExpected.right = new FormAttachment(100, 0);
        fdRegExpExpected.top = new FormAttachment((Control)this.wEndStringDisallowed, margin);
        this.wRegExpExpected.setLayoutData((Object)fdRegExpExpected);
        this.addSpacesWarning(this.wRegExpExpected);
        Label wlRegExpDisallowed = new Label((Composite)this.wgData, 131072);
        wlRegExpDisallowed.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.RegExpDisallowed.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlRegExpDisallowed);
        FormData fdlRegExpDisallowed = new FormData();
        fdlRegExpDisallowed.left = new FormAttachment(0, 0);
        fdlRegExpDisallowed.right = new FormAttachment(middle, -margin);
        fdlRegExpDisallowed.top = new FormAttachment((Control)this.wRegExpExpected, margin);
        wlRegExpDisallowed.setLayoutData((Object)fdlRegExpDisallowed);
        this.wRegExpDisallowed = new TextVar(this.variables, (Composite)this.wgData, 18436);
        PropsUi.setLook((Widget)this.wRegExpDisallowed);
        FormData fdRegExpDisallowed = new FormData();
        fdRegExpDisallowed.left = new FormAttachment(middle, margin);
        fdRegExpDisallowed.right = new FormAttachment(100, 0);
        fdRegExpDisallowed.top = new FormAttachment((Control)this.wRegExpExpected, margin);
        this.wRegExpDisallowed.setLayoutData((Object)fdRegExpDisallowed);
        this.addSpacesWarning(this.wRegExpDisallowed);
        this.wbAddAllowed = new Button((Composite)this.wgData, 8);
        this.wbAddAllowed.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.ButtonAddAllowed.Label", (String[])new String[0]));
        FormData fdbAddAllowed = new FormData();
        fdbAddAllowed.right = new FormAttachment(100, 0);
        fdbAddAllowed.top = new FormAttachment((Control)this.wRegExpDisallowed, margin);
        this.wbAddAllowed.setLayoutData((Object)fdbAddAllowed);
        this.wbAddAllowed.addListener(13, e -> this.addAllowedValue());
        this.wbRemoveAllowed = new Button((Composite)this.wgData, 8);
        this.wbRemoveAllowed.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.ButtonRemoveAllowed.Label", (String[])new String[0]));
        FormData fdbRemoveAllowed = new FormData();
        fdbRemoveAllowed.right = new FormAttachment(100, 0);
        fdbRemoveAllowed.top = new FormAttachment((Control)this.wbAddAllowed, margin);
        this.wbRemoveAllowed.setLayoutData((Object)fdbRemoveAllowed);
        this.wbRemoveAllowed.addListener(13, e -> this.removeAllowedValue());
        this.wlAllowedValues = new Label((Composite)this.wgData, 131072);
        this.wlAllowedValues.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.AllowedValues.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAllowedValues);
        FormData fdlAllowedValues = new FormData();
        fdlAllowedValues.left = new FormAttachment(0, 0);
        fdlAllowedValues.right = new FormAttachment(middle, -margin);
        fdlAllowedValues.top = new FormAttachment((Control)this.wRegExpDisallowed, margin);
        this.wlAllowedValues.setLayoutData((Object)fdlAllowedValues);
        this.wAllowedValues = new org.eclipse.swt.widgets.List((Composite)this.wgData, 19202);
        PropsUi.setLook((Widget)this.wAllowedValues);
        FormData fdAllowedValues = new FormData();
        fdAllowedValues.left = new FormAttachment(middle, margin);
        fdAllowedValues.right = new FormAttachment((Control)this.wbRemoveAllowed, -20);
        fdAllowedValues.top = new FormAttachment((Control)this.wRegExpDisallowed, margin);
        fdAllowedValues.bottom = new FormAttachment((Control)this.wRegExpDisallowed, (int)(this.props.getZoomFactor() * 150.0));
        this.wAllowedValues.setLayoutData((Object)fdAllowedValues);
        Label wlSourceValues = new Label((Composite)this.wgData, 131072);
        wlSourceValues.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.SourceValues.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSourceValues);
        FormData fdlSourceValues = new FormData();
        fdlSourceValues.left = new FormAttachment(0, 0);
        fdlSourceValues.right = new FormAttachment(middle, -margin);
        fdlSourceValues.top = new FormAttachment((Control)this.wAllowedValues, margin);
        wlSourceValues.setLayoutData((Object)fdlSourceValues);
        this.wSourceValues = new Button((Composite)this.wgData, 32);
        PropsUi.setLook((Widget)this.wSourceValues);
        FormData fdSourceValues = new FormData();
        fdSourceValues.left = new FormAttachment(middle, margin);
        fdSourceValues.right = new FormAttachment(100, 0);
        fdSourceValues.top = new FormAttachment((Control)wlSourceValues, 0, 0x1000000);
        this.wSourceValues.setLayoutData((Object)fdSourceValues);
        this.wSourceValues.addListener(13, e -> this.enableFields());
        this.wlSourceTransform = new Label((Composite)this.wgData, 131072);
        this.wlSourceTransform.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.SourceTransform.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlSourceTransform);
        FormData fdlSourceTransform = new FormData();
        fdlSourceTransform.left = new FormAttachment(0, margin);
        fdlSourceTransform.right = new FormAttachment(middle, -margin);
        fdlSourceTransform.top = new FormAttachment((Control)wlSourceValues, margin);
        this.wlSourceTransform.setLayoutData((Object)fdlSourceTransform);
        this.wSourceTransform = new CCombo((Composite)this.wgData, 18436);
        PropsUi.setLook((Widget)this.wSourceTransform);
        FormData fdSourceTransform = new FormData();
        fdSourceTransform.left = new FormAttachment(middle, margin);
        fdSourceTransform.right = new FormAttachment(100, 0);
        fdSourceTransform.top = new FormAttachment((Control)this.wSourceValues, margin);
        this.wSourceTransform.setLayoutData((Object)fdSourceTransform);
        this.wSourceTransform.addListener(15, e -> this.getTransforms());
        this.wSourceTransform.addListener(13, e -> this.getTransforms());
        this.wlSourceField = new Label((Composite)this.wgData, 131072);
        this.wlSourceField.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.SourceField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlSourceField);
        FormData fdlSourceField = new FormData();
        fdlSourceField.left = new FormAttachment(0, margin);
        fdlSourceField.right = new FormAttachment(middle, -margin);
        fdlSourceField.top = new FormAttachment((Control)this.wSourceTransform, margin);
        this.wlSourceField.setLayoutData((Object)fdlSourceField);
        this.wSourceField = new CCombo((Composite)this.wgData, 18436);
        PropsUi.setLook((Widget)this.wSourceField);
        FormData fdSourceField = new FormData();
        fdSourceField.left = new FormAttachment(middle, margin);
        fdSourceField.right = new FormAttachment(100, 0);
        fdSourceField.top = new FormAttachment((Control)this.wSourceTransform, margin);
        this.wSourceField.setLayoutData((Object)fdSourceField);
        this.wSourceField.addListener(15, e -> this.getFields());
        this.wSourceField.addListener(13, e -> this.getFields());
        wComp.layout();
        wComp.pack();
        Rectangle bounds = wComp.getBounds();
        wSComp.setContent((Control)wComp);
        wSComp.setExpandHorizontal(true);
        wSComp.setExpandVertical(true);
        wSComp.setMinWidth(bounds.width);
        wSComp.setMinHeight(bounds.height);
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void showSelectedValidatorField(String selection) {
        this.saveChanges();
        Validation field = Validation.findValidation(this.selectionList, selection);
        if (field == null) {
            field = new Validation(selection);
            IValueMeta valueMeta = this.inputFields.searchValueMeta(selection);
            if (valueMeta != null) {
                field.setDataType(valueMeta.getTypeDesc());
            }
        }
        this.selectedField = field;
        this.getValidatorFieldData(this.selectedField);
        this.enableFields();
    }

    private void saveChanges() {
        if (this.selectedField != null) {
            this.selectedField.setFieldName(this.wFieldName.getText());
            this.selectedField.setErrorCode(this.wErrorCode.getText());
            this.selectedField.setErrorDescription(this.wErrorDescription.getText());
            this.selectedField.setDataTypeVerified(this.wDataTypeVerified.getSelection());
            this.selectedField.setDataType(this.wDataType.getText());
            this.selectedField.setConversionMask(this.wConversionMask.getText());
            this.selectedField.setDecimalSymbol(this.wDecimalSymbol.getText());
            this.selectedField.setGroupingSymbol(this.wGroupingSymbol.getText());
            this.selectedField.setNullAllowed(this.wNullAllowed.getSelection());
            this.selectedField.setOnlyNullAllowed(this.wOnlyNullAllowed.getSelection());
            this.selectedField.setOnlyNumericAllowed(this.wOnlyNumeric.getSelection());
            this.selectedField.setMaximumLength(this.wMaxLength.getText());
            this.selectedField.setMinimumLength(this.wMinLength.getText());
            this.selectedField.setMaximumValue(this.wMaxValue.getText());
            this.selectedField.setMinimumValue(this.wMinValue.getText());
            this.selectedField.setStartString(this.wStartStringExpected.getText());
            this.selectedField.setEndString(this.wEndStringExpected.getText());
            this.selectedField.setStartStringNotAllowed(this.wStartStringDisallowed.getText());
            this.selectedField.setEndStringNotAllowed(this.wEndStringDisallowed.getText());
            this.selectedField.setRegularExpression(this.wRegExpExpected.getText());
            this.selectedField.setRegularExpressionNotAllowed(this.wRegExpDisallowed.getText());
            this.selectedField.setAllowedValues(new ArrayList<String>(Arrays.asList(this.wAllowedValues.getItems())));
            this.selectedField.setSourcingValues(this.wSourceValues.getSelection());
            this.selectedField.setSourcingField(this.wSourceField.getText());
            this.selectedField.setSourcingTransformName(this.wSourceTransform.getText());
            this.selectedField.setSourcingTransform(this.pipelineMeta.findTransform(this.wSourceTransform.getText()));
        }
    }

    protected void setFlags() {
        this.wConcatErrors.setEnabled(this.wValidateAll.getSelection());
        this.wConcatSeparator.setEnabled(this.wConcatErrors.getSelection());
    }

    private void addSpacesWarning(TextVar text) {
        Text widget = text.getTextWidget();
        widget.addListener(24, e -> {
            boolean showWarning = false;
            String message = null;
            if (this.spacesValidation(text.getText())) {
                showWarning = true;
                message = BaseMessages.getString(PKG, (String)"System.Warning.OnlySpaces", (String[])new String[0]);
            } else if (this.trailingSpacesValidation(text.getText())) {
                showWarning = true;
                message = BaseMessages.getString(PKG, (String)"System.Warning.TrailingSpaces", (String[])new String[0]);
            }
            if (showWarning) {
                widget.setBackground(GuiResource.getInstance().getColorRed());
                widget.setForeground(GuiResource.getInstance().getColorWhite());
                widget.setToolTipText(message);
            } else {
                PropsUi.setLook((Widget)widget);
                widget.setToolTipText("");
            }
        });
    }

    public boolean spacesValidation(String text) {
        return text != null && Const.onlySpaces((String)text) && StringUtils.isNotEmpty((String)text);
    }

    public boolean trailingSpacesValidation(String text) {
        return text != null && text.endsWith(" ");
    }

    protected void removeAllowedValue() {
        String[] selection;
        for (String string : selection = this.wAllowedValues.getSelection()) {
            this.wAllowedValues.remove(string);
        }
    }

    protected void addAllowedValue() {
        EnterStringDialog dialog = new EnterStringDialog(this.shell, "", BaseMessages.getString(PKG, (String)"ValidatorDialog.Dialog.AddAllowedValue.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ValidatorDialog.Dialog.AddAllowedValue.Message", (String[])new String[0]), true, this.variables);
        String value = dialog.open();
        if (StringUtils.isNotEmpty((String)value)) {
            this.wAllowedValues.add(value);
        }
    }

    private void getValidatorFieldData(Validation field) {
        this.wDescription.setText(Const.NVL((String)field.getName(), (String)""));
        this.wFieldName.setText(Const.NVL((String)field.getFieldName(), (String)""));
        this.wErrorCode.setText(Const.NVL((String)field.getErrorCode(), (String)""));
        this.wErrorDescription.setText(Const.NVL((String)field.getErrorDescription(), (String)""));
        this.wDataTypeVerified.setSelection(field.isDataTypeVerified());
        this.wDataType.setText(Const.NVL((String)field.getDataType(), (String)""));
        this.wConversionMask.setText(Const.NVL((String)field.getConversionMask(), (String)""));
        this.wDecimalSymbol.setText(Const.NVL((String)field.getDecimalSymbol(), (String)""));
        this.wGroupingSymbol.setText(Const.NVL((String)field.getGroupingSymbol(), (String)""));
        this.wNullAllowed.setSelection(field.isNullAllowed());
        this.wOnlyNullAllowed.setSelection(field.isOnlyNullAllowed());
        this.wOnlyNumeric.setSelection(field.isOnlyNumericAllowed());
        this.wMaxLength.setText(Const.NVL((String)field.getMaximumLength(), (String)""));
        this.wMinLength.setText(Const.NVL((String)field.getMinimumLength(), (String)""));
        this.wMaxValue.setText(Const.NVL((String)field.getMaximumValue(), (String)""));
        this.wMinValue.setText(Const.NVL((String)field.getMinimumValue(), (String)""));
        this.wStartStringExpected.setText(Const.NVL((String)field.getStartString(), (String)""));
        this.wEndStringExpected.setText(Const.NVL((String)field.getEndString(), (String)""));
        this.wStartStringDisallowed.setText(Const.NVL((String)field.getStartStringNotAllowed(), (String)""));
        this.wEndStringDisallowed.setText(Const.NVL((String)field.getEndStringNotAllowed(), (String)""));
        this.wRegExpExpected.setText(Const.NVL((String)field.getRegularExpression(), (String)""));
        this.wRegExpDisallowed.setText(Const.NVL((String)field.getRegularExpressionNotAllowed(), (String)""));
        this.wAllowedValues.removeAll();
        if (field.getAllowedValues() != null) {
            for (String allowedValue : field.getAllowedValues()) {
                this.wAllowedValues.add(Const.NVL((String)allowedValue, (String)""));
            }
        }
        this.wSourceValues.setSelection(field.isSourcingValues());
        this.wSourceTransform.setText(Const.NVL((String)field.getSourcingTransformName(), (String)""));
        this.wSourceField.setText(Const.NVL((String)field.getSourcingField(), (String)""));
    }

    private void enableFields() {
        boolean visible = this.selectedField != null;
        this.wgType.setVisible(visible);
        this.wgData.setVisible(visible);
        this.wlFieldName.setVisible(visible);
        this.wFieldName.setVisible(visible);
        this.wlDescription.setVisible(visible);
        this.wDescription.setVisible(visible);
        this.wlErrorCode.setVisible(visible);
        this.wErrorCode.setVisible(visible);
        this.wlErrorDescription.setVisible(visible);
        this.wErrorDescription.setVisible(visible);
        this.wlSourceTransform.setEnabled(this.wSourceValues.getSelection());
        this.wSourceTransform.setEnabled(this.wSourceValues.getSelection());
        this.wlSourceField.setEnabled(this.wSourceValues.getSelection());
        this.wSourceField.setEnabled(this.wSourceValues.getSelection());
        this.wlAllowedValues.setEnabled(!this.wSourceValues.getSelection());
        this.wAllowedValues.setEnabled(!this.wSourceValues.getSelection());
        this.wbAddAllowed.setEnabled(!this.wSourceValues.getSelection());
        this.wbRemoveAllowed.setEnabled(!this.wSourceValues.getSelection());
    }

    public void getData() {
        Validation validatorField;
        String description;
        int index;
        this.refreshValidationsList();
        this.enableFields();
        this.wValidateAll.setSelection(this.input.isValidatingAll());
        this.wConcatErrors.setSelection(this.input.isConcatenatingErrors());
        this.wConcatSeparator.setText(Const.NVL((String)this.input.getConcatenationSeparator(), (String)""));
        if (!this.input.getValidations().isEmpty() && (index = this.wValidationsList.indexOf(description = (validatorField = this.input.getValidations().get(0)).getName())) >= 0) {
            this.wValidationsList.select(index);
            this.showSelectedValidatorField(description);
        }
        this.setFlags();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void refreshValidationsList() {
        this.wValidationsList.removeAll();
        for (Validation validation : this.selectionList) {
            this.wValidationsList.add(validation.getName());
        }
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (StringUtils.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.saveChanges();
        this.input.setChanged();
        this.input.setValidatingAll(this.wValidateAll.getSelection());
        this.input.setConcatenatingErrors(this.wConcatErrors.getSelection());
        this.input.setConcatenationSeparator(this.wConcatSeparator.getText());
        this.input.setValidations(this.selectionList);
        this.input.searchInfoAndTargetTransforms(this.pipelineMeta.getTransforms());
        this.dispose();
    }

    private void getTransforms() {
        Cursor busy = new Cursor((Device)this.shell.getDisplay(), 1);
        this.shell.setCursor(busy);
        String fieldTransform = this.wSourceTransform.getText();
        this.wSourceTransform.removeAll();
        this.wSourceTransform.setItems(this.pipelineMeta.getPrevTransformNames(this.transformMeta));
        this.wSourceTransform.setText(fieldTransform);
        this.shell.setCursor(null);
        busy.dispose();
    }

    private void getFields() {
        Cursor busy = new Cursor((Device)this.shell.getDisplay(), 1);
        this.shell.setCursor(busy);
        try {
            String sourceTransformName = this.wSourceTransform.getText();
            if (StringUtils.isNotEmpty((String)sourceTransformName)) {
                String fieldName = this.wSourceField.getText();
                IRowMeta r = this.pipelineMeta.getTransformFields(this.variables, sourceTransformName);
                if (r != null) {
                    this.wSourceField.setItems(r.getFieldNames());
                }
                this.wSourceField.setText(fieldName);
            }
            this.shell.setCursor(null);
            busy.dispose();
        }
        catch (HopException ke) {
            this.shell.setCursor(null);
            busy.dispose();
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ValidatorDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ValidatorDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void newValidation() {
        EnterStringDialog enterStringDialog = new EnterStringDialog(this.shell, "", BaseMessages.getString(PKG, (String)"ValidatorDialog.EnterValidationRuleName.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ValidatorDialog.EnterValidationRuleName.Message", (String[])new String[0]));
        String description = enterStringDialog.open();
        if (description != null) {
            if (Validation.findValidation(this.selectionList, description) != null) {
                MessageBox messageBox = new MessageBox(this.shell, 1);
                messageBox.setText(BaseMessages.getString(PKG, (String)"ValidatorDialog.ValidationRuleNameAlreadyExists.Title", (String[])new String[0]));
                messageBox.setMessage(BaseMessages.getString(PKG, (String)"ValidatorDialog.ValidationRuleNameAlreadyExists.Message", (String[])new String[0]));
                messageBox.open();
                return;
            }
            this.saveChanges();
            Validation validation = new Validation();
            validation.setName(description);
            this.selectionList.add(validation);
            this.selectedField = validation;
            this.refreshValidationsList();
            this.wValidationsList.select(this.selectionList.size() - 1);
            this.getValidatorFieldData(validation);
            this.showSelectedValidatorField(description);
        }
    }

    private void clearValidation() {
        int index = this.wValidationsList.getSelectionIndex();
        if (index >= 0) {
            this.selectionList.remove(index);
            this.selectedField = null;
            this.wValidationsList.remove(index);
            this.enableFields();
            if (!this.selectionList.isEmpty()) {
                this.wValidationsList.select(this.selectionList.size() - 1);
            }
        }
    }
}

