/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.copymoveresultfilenames;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileUtil;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.w3c.dom.Node;

@Action(id="COPY_MOVE_RESULT_FILENAMES", name="i18n::ActionCopyMoveResultFilenames.Name", description="i18n::ActionCopyMoveResultFilenames.Description", image="CopyMoveResultFilenames.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionCopyMoveResultFilenames.keyword"}, documentationUrl="/workflow/actions/processresultfilenames.html")
public class ActionCopyMoveResultFilenames
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionCopyMoveResultFilenames.class;
    private String folderName = null;
    private boolean specifyWildcard = false;
    private String wildcard = null;
    private String wildcardExclude = null;
    private String destinationFolder = null;
    private String nrErrorsLessThan = "10";
    public static final String SUCCESS_IF_AT_LEAST_X_FILES = "success_when_at_least";
    public static final String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public static final String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    private static final String CONST_SPACE_SHORT = "      ";
    private String successCondition = "success_if_no_errors";
    private Pattern wildcardPattern;
    private Pattern wildcardExcludePattern;
    private boolean addDate = false;
    private boolean addTime = false;
    private boolean specifyFormat = false;
    private String dateTimeFormat = null;
    private boolean addDateBeforeExtension = false;
    private String action = "copy";
    private boolean overwriteFile = false;
    private boolean createDestinationFolder = false;
    boolean removedSourceFilename = true;
    boolean addDestinationFilename = true;
    int nrErrors = 0;
    private int nrSuccess = 0;
    boolean successConditionBroken = false;
    boolean successConditionBrokenExit = false;
    int limitFiles = 0;

    public ActionCopyMoveResultFilenames(String n) {
        super(n, "");
    }

    public ActionCopyMoveResultFilenames() {
        this("");
    }

    public Object clone() {
        ActionCopyMoveResultFilenames je = (ActionCopyMoveResultFilenames)super.clone();
        return je;
    }

    public String getXml() {
        return super.getXml() + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"foldername", (String)this.folderName) + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"specify_wildcard", (boolean)this.specifyWildcard) + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"wildcard", (String)this.wildcard) + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"wildcardexclude", (String)this.wildcardExclude) + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"destination_folder", (String)this.destinationFolder) + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"nr_errors_less_than", (String)this.nrErrorsLessThan) + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"success_condition", (String)this.successCondition) + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"add_date", (boolean)this.addDate) + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"add_time", (boolean)this.addTime) + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"SpecifyFormat", (boolean)this.specifyFormat) + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"date_time_format", (String)this.dateTimeFormat) + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"action", (String)this.action) + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"AddDateBeforeExtension", (boolean)this.addDateBeforeExtension) + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"OverwriteFile", (boolean)this.overwriteFile) + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"CreateDestinationFolder", (boolean)this.createDestinationFolder) + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"RemovedSourceFilename", (boolean)this.removedSourceFilename) + CONST_SPACE_SHORT + XmlHandler.addTagValue((String)"AddDestinationFilename", (boolean)this.addDestinationFilename);
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.folderName = XmlHandler.getTagValue((Node)entrynode, (String)"foldername");
            this.specifyWildcard = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"specify_wildcard"));
            this.wildcard = XmlHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.wildcardExclude = XmlHandler.getTagValue((Node)entrynode, (String)"wildcardexclude");
            this.destinationFolder = XmlHandler.getTagValue((Node)entrynode, (String)"destination_folder");
            this.nrErrorsLessThan = XmlHandler.getTagValue((Node)entrynode, (String)"nr_errors_less_than");
            this.successCondition = XmlHandler.getTagValue((Node)entrynode, (String)"success_condition");
            this.addDate = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"add_date"));
            this.addTime = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"add_time"));
            this.specifyFormat = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"SpecifyFormat"));
            this.addDateBeforeExtension = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"AddDateBeforeExtension"));
            this.dateTimeFormat = XmlHandler.getTagValue((Node)entrynode, (String)"date_time_format");
            this.action = XmlHandler.getTagValue((Node)entrynode, (String)"action");
            this.overwriteFile = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"OverwriteFile"));
            this.createDestinationFolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"CreateDestinationFolder"));
            this.removedSourceFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"RemovedSourceFilename"));
            this.addDestinationFilename = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"AddDestinationFilename"));
        }
        catch (HopXmlException xe) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionCopyMoveResultFilenames.CanNotLoadFromXML", (String[])new String[]{xe.getMessage()}));
        }
    }

    public void setSpecifyWildcard(boolean specifyWildcard) {
        this.specifyWildcard = specifyWildcard;
    }

    public boolean isSpecifyWildcard() {
        return this.specifyWildcard;
    }

    public void setFoldername(String folderName) {
        this.folderName = folderName;
    }

    public String getFoldername() {
        return this.folderName;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public String getWildcardExclude() {
        return this.wildcardExclude;
    }

    public String getRealWildcard() {
        return this.resolve(this.getWildcard());
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public void setWildcardExclude(String wildcardExclude) {
        this.wildcardExclude = wildcardExclude;
    }

    public void setAddDate(boolean adddate) {
        this.addDate = adddate;
    }

    public boolean isAddDate() {
        return this.addDate;
    }

    public void setAddTime(boolean addtime) {
        this.addTime = addtime;
    }

    public boolean isAddTime() {
        return this.addTime;
    }

    public void setAddDateBeforeExtension(boolean addDateBeforeExtension) {
        this.addDateBeforeExtension = addDateBeforeExtension;
    }

    public boolean isAddDateBeforeExtension() {
        return this.addDateBeforeExtension;
    }

    public boolean isOverwriteFile() {
        return this.overwriteFile;
    }

    public void setOverwriteFile(boolean overwriteFile) {
        this.overwriteFile = overwriteFile;
    }

    public void setCreateDestinationFolder(boolean createDestinationFolder) {
        this.createDestinationFolder = createDestinationFolder;
    }

    public boolean isCreateDestinationFolder() {
        return this.createDestinationFolder;
    }

    public boolean isRemovedSourceFilename() {
        return this.removedSourceFilename;
    }

    public void setRemovedSourceFilename(boolean removedSourceFilename) {
        this.removedSourceFilename = removedSourceFilename;
    }

    public void setAddDestinationFilename(boolean addDestinationFilename) {
        this.addDestinationFilename = addDestinationFilename;
    }

    public boolean isAddDestinationFilename() {
        return this.addDestinationFilename;
    }

    public boolean isSpecifyFormat() {
        return this.specifyFormat;
    }

    public void setSpecifyFormat(boolean specifyFormat) {
        this.specifyFormat = specifyFormat;
    }

    public void setDestinationFolder(String destinationFolder) {
        this.destinationFolder = destinationFolder;
    }

    public String getDestinationFolder() {
        return this.destinationFolder;
    }

    public void setNrErrorsLessThan(String nrErrorsLessThan) {
        this.nrErrorsLessThan = nrErrorsLessThan;
    }

    public String getNrErrorsLessThan() {
        return this.nrErrorsLessThan;
    }

    public void setSuccessCondition(String successCondition) {
        this.successCondition = successCondition;
    }

    public String getSuccessCondition() {
        return this.successCondition;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        boolean deleteFile = this.getAction().equals("delete");
        String realdestinationFolder = null;
        if (!deleteFile && !this.createDestinationFolder(realdestinationFolder = this.resolve(this.getDestinationFolder()))) {
            return result;
        }
        if (!Utils.isEmpty((CharSequence)this.wildcard)) {
            this.wildcardPattern = Pattern.compile(this.resolve(this.wildcard));
        }
        if (!Utils.isEmpty((CharSequence)this.wildcardExclude)) {
            this.wildcardExcludePattern = Pattern.compile(this.resolve(this.wildcardExclude));
        }
        if (previousResult != null) {
            this.nrErrors = 0;
            this.limitFiles = Const.toInt((String)this.resolve(this.getNrErrorsLessThan()), (int)10);
            this.nrErrors = 0;
            this.nrSuccess = 0;
            this.successConditionBroken = false;
            this.successConditionBrokenExit = false;
            FileObject file = null;
            try {
                List resultFiles;
                int size = result.getResultFiles().size();
                if (this.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ActionCopyMoveResultFilenames.log.FilesFound", (String[])new String[]{"" + size}));
                }
                if ((resultFiles = result.getResultFilesList()) != null && !resultFiles.isEmpty()) {
                    Iterator it = resultFiles.iterator();
                    while (it.hasNext() && !this.parentWorkflow.isStopped()) {
                        if (this.successConditionBroken) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionCopyMoveResultFilenames.Error.SuccessConditionbroken", (String[])new String[]{"" + this.nrErrors}));
                            throw new Exception(BaseMessages.getString(PKG, (String)"ActionCopyMoveResultFilenames.Error.SuccessConditionbroken", (String[])new String[]{"" + this.nrErrors}));
                        }
                        ResultFile resultFile = (ResultFile)it.next();
                        file = resultFile.getFile();
                        if (file != null && file.exists()) {
                            if (this.specifyWildcard && (!this.checkFileWildcard(file.getName().getBaseName(), this.wildcardPattern, true) || this.checkFileWildcard(file.getName().getBaseName(), this.wildcardExcludePattern, false) || !this.specifyWildcard) || this.processFile(file, realdestinationFolder, result, (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, deleteFile)) continue;
                            this.updateErrors();
                            continue;
                        }
                        this.logError(BaseMessages.getString(PKG, (String)"ActionCopyMoveResultFilenames.log.ErrorCanNotFindFile", (String[])new String[]{file.toString()}));
                        this.updateErrors();
                    }
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionCopyMoveResultFilenames.Error", (String[])new String[]{e.toString()}));
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                        file = null;
                    }
                    catch (Exception exception) {}
                }
            }
        }
        result.setNrErrors((long)this.nrErrors);
        result.setNrLinesWritten((long)this.nrSuccess);
        if (this.getSuccessStatus()) {
            result.setResult(true);
        }
        return result;
    }

    private void updateErrors() {
        ++this.nrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        return this.nrErrors > 0 && this.getSuccessCondition().equals(SUCCESS_IF_NO_ERRORS) || this.nrErrors >= this.limitFiles && this.getSuccessCondition().equals(SUCCESS_IF_ERRORS_LESS);
    }

    private boolean getSuccessStatus() {
        return this.nrErrors == 0 && this.getSuccessCondition().equals(SUCCESS_IF_NO_ERRORS) || this.nrSuccess >= this.limitFiles && this.getSuccessCondition().equals(SUCCESS_IF_AT_LEAST_X_FILES) || this.nrErrors <= this.limitFiles && this.getSuccessCondition().equals(SUCCESS_IF_ERRORS_LESS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createDestinationFolder(String folderName) {
        block20: {
            boolean bl;
            FileObject folder = null;
            try {
                folder = HopVfs.getFileObject((String)folderName);
                if (!folder.exists()) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionCopyMoveResultFilenames.Log.FolderNotExists", (String[])new String[]{folderName}));
                    if (!this.isCreateDestinationFolder()) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    folder.createFolder();
                    if (this.isBasic()) {
                        this.logBasic(BaseMessages.getString(PKG, (String)"ActionCopyMoveResultFilenames.Log.FolderCreated", (String[])new String[]{folderName}));
                    }
                } else if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCopyMoveResultFilenames.Log.FolderExists", (String[])new String[]{folderName}));
                }
                bl = true;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"ActionCopyMoveResultFilenames.Log.CanNotCreatedFolder", (String[])new String[]{folderName, e.toString()}));
                break block20;
            }
            finally {
                if (folder != null) {
                    try {
                        folder.close();
                        folder = null;
                    }
                    catch (Exception exception) {}
                }
            }
            return bl;
        }
        return false;
    }

    private boolean processFile(FileObject sourcefile, String destinationFolder, Result result, IWorkflowEngine<WorkflowMeta> parentWorkflow, boolean deleteFile) {
        boolean retval = false;
        try {
            if (deleteFile) {
                if (sourcefile.delete()) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCopyMoveResultFilenames.log.DeletedFile", (String[])new String[]{sourcefile.toString()}));
                    }
                    result.getResultFiles().remove(sourcefile.toString());
                    ++this.nrSuccess;
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCopyMoveResultFilenames.RemovedFileFromResult", (String[])new String[]{sourcefile.toString()}));
                    }
                } else {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionCopyMoveResultFilenames.CanNotDeletedFile", (String[])new String[]{sourcefile.toString()}));
                }
            } else {
                String shortfilename = this.getDestinationFilename(sourcefile.getName().getBaseName());
                String destinationFilename = destinationFolder + Const.FILE_SEPARATOR + shortfilename;
                FileObject destinationfile = HopVfs.getFileObject((String)destinationFilename);
                boolean filexists = destinationfile.exists();
                if (filexists && this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCopyMoveResultFilenames.Log.FileExists", (String[])new String[]{destinationFilename}));
                }
                if (!filexists || filexists && this.isOverwriteFile()) {
                    if (this.getAction().equals("copy")) {
                        FileUtil.copyContent((FileObject)sourcefile, (FileObject)destinationfile);
                        ++this.nrSuccess;
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCopyMoveResultFilenames.log.CopiedFile", (String[])new String[]{sourcefile.toString(), destinationFolder}));
                        }
                    } else {
                        sourcefile.moveTo(destinationfile);
                        ++this.nrSuccess;
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCopyMoveResultFilenames.log.MovedFile", (String[])new String[]{sourcefile.toString(), destinationFolder}));
                        }
                    }
                    if (this.isRemovedSourceFilename()) {
                        result.getResultFiles().remove(sourcefile.toString());
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCopyMoveResultFilenames.RemovedFileFromResult", (String[])new String[]{sourcefile.toString()}));
                        }
                    }
                    if (this.isAddDestinationFilename()) {
                        ResultFile resultFile = new ResultFile(0, HopVfs.getFileObject((String)destinationfile.toString()), parentWorkflow.getWorkflowName(), this.toString());
                        result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCopyMoveResultFilenames.AddedFileToResult", (String[])new String[]{destinationfile.toString()}));
                        }
                    }
                }
            }
            retval = true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"ActionCopyMoveResultFilenames.Log.ErrorProcessing", (String[])new String[]{e.toString()}));
        }
        return retval;
    }

    private String getDestinationFilename(String shortsourcefilename) {
        Object shortfilename = shortsourcefilename;
        int lenstring = shortsourcefilename.length();
        int lastindexOfDot = ((String)shortfilename).lastIndexOf(46);
        if (this.isAddDateBeforeExtension()) {
            shortfilename = ((String)shortfilename).substring(0, lastindexOfDot);
        }
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (this.isSpecifyFormat() && !Utils.isEmpty((CharSequence)this.getDateTimeFormat())) {
            daf.applyPattern(this.getDateTimeFormat());
            String dt = daf.format(now);
            shortfilename = (String)shortfilename + dt;
        } else {
            if (this.isAddDate()) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                shortfilename = (String)shortfilename + "_" + d;
            }
            if (this.isAddTime()) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                shortfilename = (String)shortfilename + "_" + t;
            }
        }
        if (this.isAddDateBeforeExtension()) {
            shortfilename = (String)shortfilename + shortsourcefilename.substring(lastindexOfDot, lenstring);
        }
        return shortfilename;
    }

    private boolean checkFileWildcard(String selectedfile, Pattern pattern, boolean include) {
        boolean getIt = include;
        if (pattern != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public boolean isEvaluation() {
        return true;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileDoesNotExistValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename", remarks, ctx);
    }
}

