/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.admin.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.InternalApi;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcCallableFactory;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.admin.v2.OptimizeRestoredTableMetadata;
import com.google.bigtable.admin.v2.TableName;
import com.google.cloud.bigtable.admin.v2.models.ConsistencyRequest;
import com.google.cloud.bigtable.admin.v2.stub.AwaitConsistencyCallable;
import com.google.cloud.bigtable.admin.v2.stub.AwaitReplicationCallable;
import com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStubSettings;
import com.google.cloud.bigtable.admin.v2.stub.GrpcBigtableTableAdminStub;
import com.google.cloud.bigtable.data.v2.internal.TableAdminRequestContext;
import com.google.longrunning.Operation;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import io.grpc.MethodDescriptor;
import java.io.IOException;
import java.io.InputStream;
import org.threeten.bp.Duration;

@InternalApi
public class EnhancedBigtableTableAdminStub
extends GrpcBigtableTableAdminStub {
    private final BigtableTableAdminStubSettings settings;
    private final ClientContext clientContext;
    private final TableAdminRequestContext requestContext;
    private final AwaitReplicationCallable awaitReplicationCallable;
    private final AwaitConsistencyCallable awaitConsistencyCallable;
    private final OperationCallable<Void, Empty, OptimizeRestoredTableMetadata> optimizeRestoredTableOperationBaseCallable;

    public static EnhancedBigtableTableAdminStub createEnhanced(BigtableTableAdminStubSettings settings, TableAdminRequestContext requestContext) throws IOException {
        return new EnhancedBigtableTableAdminStub(settings, ClientContext.create((StubSettings)settings), requestContext);
    }

    private EnhancedBigtableTableAdminStub(BigtableTableAdminStubSettings settings, ClientContext clientContext, TableAdminRequestContext requestContext) throws IOException {
        super(settings, clientContext);
        this.settings = settings;
        this.clientContext = clientContext;
        this.requestContext = requestContext;
        this.awaitConsistencyCallable = this.createAwaitConsistencyCallable();
        this.awaitReplicationCallable = this.createAwaitReplicationCallable();
        this.optimizeRestoredTableOperationBaseCallable = this.createOptimizeRestoredTableOperationBaseCallable();
    }

    private AwaitReplicationCallable createAwaitReplicationCallable() {
        return AwaitReplicationCallable.create(this.awaitConsistencyCallable);
    }

    private AwaitConsistencyCallable createAwaitConsistencyCallable() {
        RetrySettings pollingSettings = RetrySettings.newBuilder().setTotalTimeout(this.settings.checkConsistencySettings().getRetrySettings().getTotalTimeout()).setInitialRetryDelay(Duration.ofSeconds((long)10L)).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ofSeconds((long)10L)).setJittered(true).setInitialRpcTimeout(Duration.ZERO).setMaxRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).build();
        return AwaitConsistencyCallable.create(this.generateConsistencyTokenCallable(), this.checkConsistencyCallable(), this.clientContext, pollingSettings, this.requestContext);
    }

    private OperationCallable<Void, Empty, OptimizeRestoredTableMetadata> createOptimizeRestoredTableOperationBaseCallable() {
        GrpcCallSettings unusedInitialCallSettings = GrpcCallSettings.create((MethodDescriptor)MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.admin.v2.BigtableTableAdmin/OptimizeRestoredTable").setRequestMarshaller((MethodDescriptor.Marshaller)new MethodDescriptor.Marshaller<Void>(){

            public InputStream stream(Void value) {
                throw new UnsupportedOperationException("not used");
            }

            public Void parse(InputStream stream) {
                throw new UnsupportedOperationException("not used");
            }
        }).setResponseMarshaller((MethodDescriptor.Marshaller)new MethodDescriptor.Marshaller<Operation>(){

            public InputStream stream(Operation value) {
                throw new UnsupportedOperationException("not used");
            }

            public Operation parse(InputStream stream) {
                throw new UnsupportedOperationException("not used");
            }
        }).build());
        final ProtoOperationTransformers.MetadataTransformer protoMetadataTransformer = ProtoOperationTransformers.MetadataTransformer.create(OptimizeRestoredTableMetadata.class);
        final ProtoOperationTransformers.ResponseTransformer protoResponseTransformer = ProtoOperationTransformers.ResponseTransformer.create(Empty.class);
        OperationCallSettings operationCallSettings = OperationCallSettings.newBuilder().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setSimpleTimeoutNoRetries(Duration.ZERO).build()).setMetadataTransformer((ApiFunction)new ApiFunction<OperationSnapshot, OptimizeRestoredTableMetadata>(){

            public OptimizeRestoredTableMetadata apply(OperationSnapshot input) {
                return (OptimizeRestoredTableMetadata)protoMetadataTransformer.apply(input);
            }
        }).setResponseTransformer((ApiFunction)new ApiFunction<OperationSnapshot, Empty>(){

            public Empty apply(OperationSnapshot input) {
                return (Empty)protoResponseTransformer.apply(input);
            }
        }).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)600000L)).build())).build();
        return GrpcCallableFactory.createOperationCallable((GrpcCallSettings)unusedInitialCallSettings, (OperationCallSettings)operationCallSettings, (ClientContext)this.clientContext, (OperationsStub)this.getOperationsStub());
    }

    public UnaryCallable<TableName, Void> awaitReplicationCallable() {
        return this.awaitReplicationCallable;
    }

    public UnaryCallable<ConsistencyRequest, Void> awaitConsistencyCallable() {
        return this.awaitConsistencyCallable;
    }

    public OperationCallable<Void, Empty, OptimizeRestoredTableMetadata> awaitOptimizeRestoredTableCallable() {
        return this.optimizeRestoredTableOperationBaseCallable;
    }
}

